<?php
/**
 * Joomla!パラメータクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: JParameter.php 1795 2009-04-24 09:29:31Z fishbone $
 * @link       http://www.magic3.org
 */

class JParameter
{
	private $params = array();

	/**
	 * コンストラクタ
	 *
	 * @param string $data		初期化データ
	 * @param string $path		初期設定ファイル
	 */
	function __construct($data = '', $path = '')
	{
		$data = trim($data);
		if (!empty($data)){
			$lines = explode("\n", $data);
			$count = count($lines);
			for ($i = 0; $i < $count; $i++){
				list($key, $value) = explode("=", $lines[$i]);
				$this->params[$key] = $value;
			}
		}
	}
	/**
	 * キーを指定して値を設定
	 *
	 * @param string $key		取得キー
	 * @param string			設定値
	 * @return 					なし
	 */
	public function set($key, $value)
	{
		$this->params[$key] = $value;
	}
	/**
	 * キーを指定して値を取得
	 *
	 * @param string $key		取得キー
	 * @return string			取得値
	 */
	public function get($key)
	{
		return $this->params[$key];
	}
}
class JUser
{
	/**
	 */
	public function authorize()
	{
		return true;
	}
}
/*class JHTML
{
	function _($type)
	{
		return false;
	}
}*/
class JText
{
	function _($string, $jsSafe = false)
	{
		return $string;
	}
}
class JRequest
{
	function getCmd($name, $default = '', $hash = 'default')
	{
		return '';
	}
}
?>
