<?php
/**
 * Joomla!モジュールHTML作成クラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: JRender.php 1798 2009-04-25 03:11:41Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($this->gEnv->getJoomlaRootPath() . '/JParameter.php');
require_once($this->gEnv->getJoomlaRootPath() . '/class/html.php');
require_once($this->gEnv->getJoomlaRootPath() . '/class/arrayhelper.php');
require_once($this->gEnv->getJoomlaRootPath() . '/class/uri.php');
require_once($this->gEnv->getJoomlaRootPath() . '/class/plugin.php');

class JRender
{
	private $templateId;		// テンプレートID

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
	}
	/**
	 * テンプレートの設定
	 *
	 * @param string $templateId	テンプレートID
	 * @return						なし
	 */
	function setTemplate($id)
	{
		$this->templateId = $id;
	}
	/**
	 * Joomlaモジュール用コンテンツ取得
	 * 
	 * @param string $style			表示スタイル
	 * @param string $content		ウィジェット出力
	 * @param string $title			タイトル(空のときはタイトル非表示)
	 * @param array $attribs		その他属性
	 * @return string				モジュール出力
	 */
	public function getModuleContents($style, $content, $title = '', $attribs = array())
	{
		global $gEnvManager;
		
		// 必要なスクリプトを読み込む
		$templateId = empty($this->templateId) ? $gEnvManager->getCurrentTemplateId() : $this->templateId;
		$path = $gEnvManager->getTemplatesPath() . '/' . $templateId . '/html/modules.php';		// テンプレート独自の変換処理
		require_once($gEnvManager->getJoomlaRootPath() . '/modules.php');		// デフォルトの出力方法
		if (is_readable($path)) require_once($path);
		
		$contents = '';
		$params   = new JParameter();
		$chromeMethod = 'modChrome_' . $style;

		// Apply chrome and render module
		if (function_exists($chromeMethod))
		{
			//$module->style = $attribs['style'];
			$module->content = $content;
			if (!empty($title)){
				$module->showtitle = 1;
				$module->title = htmlentities($title, ENT_COMPAT, M3_HTML_CHARSET);
			}
			ob_clean();
			$chromeMethod($module, $params, $attribs);
			$contents = ob_get_contents();
			ob_clean();
		}
		return $contents;
	}
	/**
	 * Joomlaコンポーネント用コンテンツ取得
	 * 
	 * @param string $style			表示スタイル
	 * @param string $content		ウィジェット出力
	 * @param string $title			タイトル(空のときはタイトル非表示)
	 * @param array $attribs		その他属性
	 * @return string				コンポーネント出力
	 */
	public function getComponentContents($style, $content, $title = '', $attribs = array())
	{
		global $gEnvManager;
		
		// 設定を作成
		$contents = '';
		$this->params   = new JParameter();
		$this->user = new JUser();
		if (!empty($title)){
			$this->params->set('show_title', 1);
			$this->article->title = $title;
		}
		$this->article->text = $content;
		
		// スクリプトを実行
		$templateId = empty($this->templateId) ? $gEnvManager->getCurrentTemplateId() : $this->templateId;
		$path = $gEnvManager->getTemplatesPath() . '/' . $templateId . '/html/com_content/article/default.php';		// テンプレート独自の変換処理
		if (!is_readable($path)){// テンプレートの変換処理がない場合はデフォルトを使用
			$path = $gEnvManager->getJoomlaRootPath() . '/default.php';
		}
		ob_clean();
		require($path);		// 毎回実行する
		$contents = ob_get_contents();
		ob_clean();
		return $contents;
	}
	public function escape($src)
	{
		return htmlentities($src, ENT_COMPAT, M3_HTML_CHARSET);
	}
}
?>
