<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: _installCheckdbWidgetContainer.php 1282 2008-11-25 02:46:44Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/_installDb.php');

class _installCheckdbWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;	// DB接続オブジェクト
	private $createTableScripts;			// テーブル作成スクリプト
	private $insertTableScripts;			// データインストールスクリプト
	const SERVER_ID = 'server_id';
	const INSTALL_DT = 'install_dt';		// システムインストール日時
	const WORK_DIR = 'work_dir';			// 一時ディレクトリ
	const UPDATE_DIR = 'update';			// 追加スクリプトディレクトリ名
	const FIRST_VER = 2008111301;			// バージョンアップ可能なDBのバージョン

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new _installDB();
		$this->sysDb = $this->gInstance->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'checkdb.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		$act = $request->trimValueOf('act');
		
		// バージョンアップが可能かどうかチェック
		$canVerUp = false;

		// DB接続可能なときはDBのバージョンを取得
		$status = $this->sysDb->getDisplayErrMessage();	// 出力状態を取得
		$currentVer = $this->sysDb->getSystemConfig(M3_TB_FIELD_DB_VERSION);
		$this->sysDb->displayErrMessage($status);		// 抑止解除
		if (empty($currentVer)) $currentVer = 0;
		if ($currentVer >= self::FIRST_VER) $canVerUp = true;
		
		if ($canVerUp){			// DBバージョンアップ可能なとき
			$this->tmpl->addVar("_widget", "update_selected", 'selected');		// バージョンアップ選択
		} else {
			if (empty($currentVer)){		// 新規インストールのとき
				// DB構築画面へ遷移
				$this->gPage->redirect('?task=initdb&from=inputparam');
			} else {
				$msg = 'このDBのバージョン(' . $currentVer . ')はバージョンアップ対象外です<br />バージョンアップ機能はシステムバージョン1.7.0以降のDBが対象です';
				$this->tmpl->addVar("_widget", "message", $msg);
			}
			$this->tmpl->addVar("_widget", "init_selected", 'selected');		// 初期化選択
			$this->tmpl->addVar("_widget", "update_type_disabled", 'disabled');		// 選択無効
		}
	}
}
?>
