<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ec_menuWidgetContainer.php 1797 2009-04-24 09:36:38Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/ec_menuDb.php');

class ec_menuWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $outputText;	// 作成したメニュー
	CONST EC_MENU_ID = 'ec_menu';				// メインメニューID
	const TARGET_WIDGET = 'ec_main';		// 呼び出しウィジェットID
	const DEFAULT_TITLE = '商品カテゴリー';
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_menuDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		// メニュー情報を取得
		$ret = $this->db->getMenu(self::EC_MENU_ID, $this->gEnv->getCurrentLanguage(), $row);
		if (!$ret){// 現在の言語で作成できない場合はデフォルト言語で作成
			$ret = $this->db->getMenu(self::EC_MENU_ID, $this->gEnv->getDefaultLanguage(), $row);
		}
		return 'menu.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		// メインメニューの項目取得
		// 現在の言語で作成
		$this->db->getMenuItems(array($this, 'itemsLoop'), self::EC_MENU_ID, $this->gEnv->getCurrentLanguage());
		if ($this->outputText == ''){// 現在の言語で作成できない場合はデフォルト言語で作成
			$this->db->getMenuItems(array($this, 'itemsLoop'), self::EC_MENU_ID, $this->gEnv->getDefaultLanguage());
		}
	}
	/**
	 * ウィジェットのタイトルを設定
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						ウィジェットのタイトル名
	 */
	function _setTitle($request, &$param)
	{
		return self::DEFAULT_TITLE;
	}
	/**
	 * 取得したメニュー項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function itemsLoop($index, $fetchedRow)
	{
		// リンクタイプに合わせてタグを生成
		$option = '';
		switch ($fetchedRow['mi_link_type']){
			case 0:			// 同ウィンドウで開くリンク
				break;
			case 1:			// 別ウィンドウで開くリンク
				$option = 'target="_blank"';
				break;
		}
		
		// 「mainlevel」「sublevel」「active_menu」クラス名を設定する
		$name = '';
		if ($fetchedRow['mi_show_name']){	// 名前を表示するとき
			$name = $fetchedRow['mi_name'];
		}
		// リンク先の作成
		$linkUrl = $this->createCmdUrlToWidget(self::TARGET_WIDGET, $fetchedRow['mi_param']);
		if ($fetchedRow['mi_enable']){		// 遷移可能なとき
			$link = '<a href="' . $linkUrl . '" class="mainlevel" ' . $option . '>' . $name . '</a>';
		} else {
			$link = $name;
		}
		
		$row = array(
			'menu_class' => 'mainlevel',	//
			'link' => $link		// リンク
		);
		$this->tmpl->addVars('linklist', $row);
		$this->tmpl->parseTemplate('linklist', 'a');
		
		$this->outputText .= $fetchedRow['mi_name'];
		return true;
	}
}
?>
