<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_ec_dispOtherWidgetContainer.php 2048 2009-07-07 06:12:22Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_ec_dispBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_dispDb.php');

class admin_ec_dispOtherWidgetContainer extends admin_ec_dispBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	const USE_EMAIL		= 'use_email';		// EMAIL機能が使用可能かどうか
	const AUTO_EMAIL_SENDER	= 'auto_email_sender';		// 自動送信メール用送信者アドレス
	const DEFAULT_CURRENCY	= 'default_currency';				// デフォルト通貨
	const DISP_PRODUCT_COUNT	= 'disp_product_count';		// 商品一覧の商品表示数
	const CF_PERMIT_NON_MEMBER_ORDER = 'permit_non_member_order';			// 非会員の購入許可
			
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();

		// DBオブジェクト作成
		$this->db = new ec_dispDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_other.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$defaultLang	= $this->gEnv->getDefaultLanguage();
		
		$act = $request->trimValueOf('act');
		
		$this->defaultCurrency = $request->trimValueOf('currency');			// デフォルト通貨
		$useEmail = ($request->trimValueOf('use_email') == 'on') ? 1 : 0;		// EMAIL機能が使用可能かどうか
		$autoEmailSender = $request->trimValueOf('auto_email');						// 自動送信メールの送信元アドレス
		$productCount = $request->trimValueOf('product_list_count');						// 商品表示数
		$nonMemberOrder = ($request->trimValueOf('non_member_order') == 'on') ? 1 : 0;		// 非会員からの注文を許可するかどうか
		
		if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			$this->checkInput($this->defaultCurrency, 'デフォルト通貨');
			$this->checkMailAddress($autoEmailSender, '自動送信メールの送信元メールアドレス');
			$this->checkNumeric($productCount, '表示項目数');
			
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$isErr = false;
				
				if (!$isErr){
					if (!$this->db->updateConfig(self::DEFAULT_CURRENCY, $this->defaultCurrency)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::USE_EMAIL, $useEmail)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::AUTO_EMAIL_SENDER, $autoEmailSender)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::DISP_PRODUCT_COUNT, $productCount)) $isErr = true;// 商品一覧の商品表示数
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::CF_PERMIT_NON_MEMBER_ORDER, $nonMemberOrder)) $isErr = true;// 非会員からの注文受付
				}
			
				// 値を再取得
				$this->defaultCurrency = $this->db->getConfig(self::DEFAULT_CURRENCY);		// デフォルト通貨
				$useEmail	= $this->db->getConfig(self::USE_EMAIL);
				$autoEmailSender	= $this->db->getConfig(self::AUTO_EMAIL_SENDER);
				$productCount = $this->db->getConfig(self::DISP_PRODUCT_COUNT);						// 商品一覧の商品表示数
				$nonMemberOrder = $this->db->getConfig(self::CF_PERMIT_NON_MEMBER_ORDER);			// 非会員からの注文受付
			}
		} else {		// 初期表示の場合
			$this->defaultCurrency = $this->db->getConfig(self::DEFAULT_CURRENCY);		// デフォルト通貨
			$useEmail	= $this->db->getConfig(self::USE_EMAIL);
			$autoEmailSender	= $this->db->getConfig(self::AUTO_EMAIL_SENDER);
			$productCount = $this->db->getConfig(self::DISP_PRODUCT_COUNT);						// 商品一覧の商品表示数
			$nonMemberOrder = $this->db->getConfig(self::CF_PERMIT_NON_MEMBER_ORDER);			// 非会員からの注文受付
		}
		// 画面に書き戻す
		$checked = '';
		if ($useEmail) $checked = 'checked';
		$this->tmpl->addVar("_widget", "use_email", $checked);
		$this->tmpl->addVar("_widget", "auto_email", $autoEmailSender);
		$this->tmpl->addVar("_widget", "product_list_count", $productCount);		// 商品一覧の商品表示数
		$checked = '';
		if (!empty($nonMemberOrder)) $checked = 'checked';
		$this->tmpl->addVar("_widget", "non_member_order", $checked);			// 非会員からの注文受付
		
		// 通貨タイプ選択メニュー作成
		$this->db->getCurrency($defaultLang, array($this, 'currencyLoop'));
	}
	/**
	 * 取得した通貨種別をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function currencyLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		if ($fetchedRow['cu_id'] == $this->defaultCurrency){
			$selected = 'selected';
		}
		$name = $this->convertToDispString($fetchedRow['cu_name']);

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['cu_id']),			// 言語ID
			'name'     => $name,			// 言語名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('currency_list', $row);
		$this->tmpl->parseTemplate('currency_list', 'a');
		return true;
	}
}
?>
