<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_ec_mainBaseWidgetContainer.php 2054 2009-07-07 08:49:45Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class admin_ec_mainBaseWidgetContainer extends BaseWidgetContainer
{
	const TARGET_PRODUCT_WIDGET = 'ec_disp';		// 商品表示ウィジェット
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _postAssign($request, &$param)
	{
		global $gEnvManager;

		// 表示画面を決定
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		if (empty($task)) $task = 'top';
		
		// パンくずリストを作成
		switch ($task){
			case 'top';			// トップ画面
				$linkList = '';// パンくずリスト
				break;
			case 'category':	// 商品カテゴリ管理
			case 'category_detail':	// 商品カテゴリ管理(詳細)
				$linkList = ' &gt;&gt; カテゴリー管理 &gt;&gt; カテゴリー一覧';// パンくずリスト
				break;
			case 'productlist':		// 商品管理
				$linkList = ' &gt;&gt; 商品管理 &gt;&gt; 商品一覧';// パンくずリスト
				break;
			case 'product':		// 商品管理
				$linkList = ' &gt;&gt; 商品管理 &gt;&gt; 商品詳細';// パンくずリスト
				break;
			case 'productcsv':		// 商品管理
				$linkList = ' &gt;&gt; 商品管理 &gt;&gt; CSVデータ';// パンくずリスト
				break;
			case 'order':		// 受注管理
			case 'order_detail':		// 受注管理(詳細)
				$linkList = ' &gt;&gt; 受注管理 &gt;&gt; 受注一覧';// パンくずリスト
				break;
			case 'stock':		// 在庫管理
				$linkList = ' &gt;&gt; 在庫管理 &gt;&gt; 在庫一覧';// パンくずリスト
				break;
			case 'stockplan':		// 在庫予定
			case 'stockplan_detail':		// 在庫予定
				$linkList = ' &gt;&gt; 在庫管理 &gt;&gt; 在庫予定';// パンくずリスト
				break;
			case 'member':		// 会員管理
			case 'member_detail':		// 会員管理(詳細)
				$linkList = ' &gt;&gt; 会員管理 &gt;&gt; 会員一覧';// パンくずリスト
				break;
			case 'membercsv':		// 会員CSVデータ
				$linkList = ' &gt;&gt; 会員管理 &gt;&gt; CSVデータ';// パンくずリスト
				break;
			/*case 'shopinfo':		// ショップ情報
				$linkList = ' &gt;&gt; 基本設定 &gt;&gt; ショップ情報';// パンくずリスト
				break;*/
			case 'mailinfo':		// メール送信情報
				$linkList = ' &gt;&gt; 基本設定 &gt;&gt; メール連携';// パンくずリスト
				break;
			case 'paymethod':		// 支払方法
			case 'paymethod_detail':		// 支払方法(詳細)
				$linkList = ' &gt;&gt; 基本設定 &gt;&gt; 支払方法';// パンくずリスト
				break;
			case 'delivmethod':		// 配送方法
			case 'delivmethod_detail':		// 配送方法(詳細)
				$linkList = ' &gt;&gt; 基本設定 &gt;&gt; 配送方法';// パンくずリスト
				break;
			case 'customer':	// 取引先管理
			case 'customer_detail':	// 取引先管理(詳細)
				$linkList = ' &gt;&gt; 基本設定 &gt;&gt; 取引先';// パンくずリスト
				break;
			case 'keyword':		// 文字列変換設定
			case 'keyword_detail':		// 文字列変換設定(詳細)
				$linkList = ' &gt;&gt; 基本設定 &gt;&gt; 置換文字列編集';// パンくずリスト
				break;
			case 'imageupload':		// 画像アップロード
				$linkList = ' &gt;&gt; 基本設定 &gt;&gt; 画像アップロード';// パンくずリスト
				break;
			case 'other':		// その他設定
				$linkList = ' &gt;&gt; 基本設定 &gt;&gt; その他';// パンくずリスト
				break;
		}
		// ####### 上段メニューの作成 #######
		$menuText = '<div id="configmenu-upper">' . M3_NL;
		$menuText .= '<ul>' . M3_NL;
		
		$current = '';
		$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId();
				
		// カテゴリー管理
		$current = '';
		$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=category';
		if ($task == 'category' ||
			$task == 'category_detail'){		
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>カテゴリー管理</span></a></li>' . M3_NL;
		
		// 商品管理
		$current = '';
		$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=productlist';
		if ($task == 'product' || 		// 商品詳細
			$task == 'productlist' || 	// 商品一覧
			$task == 'productcsv' ||		// CSVデータ
			$task == 'imageupload'){		// 画像アップロード
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>商品管理</span></a></li>' . M3_NL;
		
		// 受注管理
		$current = '';
		$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=order';
		if ($task == 'order' ||
			$task == 'order_detail'){
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>受注管理</span></a></li>' . M3_NL;
		
		// 在庫管理
		$current = '';
		$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=stock';
		if ($task == 'stock' ||
			$task == 'stockplan' ||
			$task == 'stockplan_detail'){
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>在庫管理</span></a></li>' . M3_NL;
		
		// 会員管理
		$current = '';
		$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=member';
		if ($task == 'member' ||
			$task == 'member_detail' ||
			$task == 'membercsv'	){			// 会員CSVデータ
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>会員管理</span></a></li>' . M3_NL;
		
		// 基本設定
		$current = '';
		$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=keyword';
		if ($task == 'shopinfo' ||		// ショップ情報
			$task == 'mailinfo' ||		// メール送信情報
			$task == 'paymethod' ||		// 支払方法
			$task == 'paymethod_detail' ||		// 支払方法(詳細)
			$task == 'delivmethod' ||		// 配送方法
			$task == 'delivmethod_detail' ||		// 配送方法(詳細)
			$task == 'customer' ||		// 取引先
			$task == 'customer_detail' ||		// 取引先(詳細)
			$task == 'keyword' ||		// 文字列変換設定
			$task == 'keyword_detail' ||		// 文字列変換設定(詳細)
			$task == 'other'){		// その他設定
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>基本設定</span></a></li>' . M3_NL;
		
		// 上段メニュー終了
		$menuText .= '</ul>' . M3_NL;
		$menuText .= '</div>' . M3_NL;
		
		// ####### 下段メニューの作成 #######		
		$menuText .= '<div id="configmenu-lower">' . M3_NL;
		$menuText .= '<ul>' . M3_NL;

		if ($task == 'category' ||
			$task == 'category_detail'){	// 商品カテゴリ管理
			// 商品カテゴリ
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=category';
			if ($task == 'category' || $task == 'category_detail') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>カテゴリー一覧</span></a></li>' . M3_NL;
		} else if ($task == 'product' || 		// 商品詳細
			$task == 'productlist' || 	// 商品一覧
			$task == 'productcsv' ||	// CSVデータ
			$task == 'imageupload'){		// 画像アップロード
			// 商品一覧
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=productlist';
			if ($task == 'productlist') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>商品一覧</span></a></li>' . M3_NL;
			
			// 商品詳細
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=product';
			if ($task == 'product') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>商品詳細</span></a></li>' . M3_NL;
			
			// CSVデータ
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=productcsv';
			if ($task == 'productcsv') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>CSVデータ</span></a></li>' . M3_NL;
			
			// 画像アップロード
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=imageupload';
			if ($task == 'imageupload') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>画像アップロード</span></a></li>' . M3_NL;
		} else if ($task == 'order' ||
					$task == 'order_detail'){	// 受注管理
			// 受注一覧
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=order';
			if ($task == 'order' || $task == 'order_detail') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>受注一覧</span></a></li>' . M3_NL;
		} else if ($task == 'stock' ||
					$task == 'stockplan' ||
					$task == 'stockplan_detail'){	// 在庫管理
			// 在庫一覧(商品単位の在庫数一覧)
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=stock';
			if ($task == 'stock') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>在庫一覧</span></a></li>' . M3_NL;
			
			// 在庫予定
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=stockplan';
			if ($task == 'stockplan' || $task == 'stockplan_detail') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>在庫予定</span></a></li>' . M3_NL;
		} else if ($task == 'member' ||
					$task == 'member_detail' ||
					$task == 'membercsv'){	// 会員管理
			// 会員一覧
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=member';
			if ($task == 'member' || $task == 'member_detail') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>会員一覧</span></a></li>' . M3_NL;
			
			// 会員CSV
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=membercsv';
			if ($task == 'membercsv') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>CSVデータ</span></a></li>' . M3_NL;
		} else if ($task == 'shopinfo' ||		// ショップ情報
			$task == 'mailinfo' ||		// メール送信情報
			$task == 'paymethod' ||		// 支払方法
			$task == 'paymethod_detail' ||		// 支払方法(詳細)
			$task == 'delivmethod' ||		// 配送方法
			$task == 'delivmethod_detail' ||		// 配送方法(詳細)
			$task == 'customer' ||		// 取引先
			$task == 'customer_detail' ||		// 取引先(詳細)
			$task == 'keyword' ||		// 文字列変換設定
			$task == 'keyword_detail' ||		// 文字列変換設定(詳細)
			$task == 'other'){		// その他
			
			// ショップ情報
			/*$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=shopinfo';
			if ($task == 'shopinfo') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>ショップ情報</span></a></li>' . M3_NL;*/
		
			// 置換文字列編集
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=keyword';
			if ($task == 'keyword' || $task == 'keyword_detail') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>置換文字列編集</span></a></li>' . M3_NL;
			
			// 配送方法
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=delivmethod';
			if ($task == 'delivmethod' || $task == 'delivmethod_detail') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>配送方法</span></a></li>' . M3_NL;
		
			// 支払方法
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=paymethod';
			if ($task == 'paymethod' || $task == 'paymethod_detail') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>支払方法</span></a></li>' . M3_NL;
			
			// 取引先
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=customer';
			if ($task == 'customer' || $task == 'customer_detail') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>取引先</span></a></li>' . M3_NL;
		
			// メール連携
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=mailinfo';
			if ($task == 'mailinfo') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>メール連携</span></a></li>' . M3_NL;
			
			// 商品表示設定
			$current = '';
			$link = $gEnvManager->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
					'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $gEnvManager->getCurrentWidgetId() . '&task=other';
			if ($task == 'other') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>その他</span></a></li>' . M3_NL;
		}
		
		// 下段メニュー終了
		$menuText .= '</ul>' . M3_NL;
		$menuText .= '</div>' . M3_NL;

		// 作成データの埋め込み
		$linkList = '<div id="configmenu-top"><label>' . 'Eコマース' . $linkList . '</div>';
		//$outputText .= '<table width="100%"><tr><td><div id="configmenu-top"><label>' . $linkList . '</label></div></td></tr><tr><td>' . M3_NL . $menuText . '</td></tr></table>' . M3_NL;
		$outputText .= '<table width="90%"><tr><td>' . $linkList . $menuText . '</td></tr></table>' . M3_NL;
		$this->tmpl->addVar("_widget", "menu_items", $outputText);
	}
}
?>
