<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ec_mainRegcustomerWidgetContainer.php 2078 2009-07-10 06:04:05Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainOrderDb.php');

// ##### 会員登録しないで購入する場合の購入者登録 #####
class ec_mainRegcustomerWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $state;	// 都道府県
	private $userId;		// 現在のユーザ
	private $langId;		// 現在の言語
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const DEFAULT_COUNTRY_ID = 'JPN';	// デフォルト国ID
	const STANDARD_PRICE = 'selling';		// 通常価格
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new ec_mainOrderDb();
		
		// 価格計算用オブジェクト取得
		$this->ecObj = $this->gInstance->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'regcustomer.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$now = date("Y/m/d H:i:s");	// 現在日時
		$countryId = self::DEFAULT_COUNTRY_ID;			// デフォルト国ID
		$this->langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		$this->userId = $this->gEnv->getCurrentUserId();
		$defaultCurrency = $this->ecObj->getDefaultCurrency();		// 通貨
		
		// 初期データ取得
		$name = $request->trimValueOf('item_name');			// 名前
		$nameKana = $request->trimValueOf('item_name_kana');			// 名前カナ
		$zipcode = $request->trimValueOf('item_zipcode');	// 郵便番号
		$this->state = $request->trimValueOf('item_state');	// 都道府県
		$address = $request->trimValueOf('item_address');	// 住所
		$address2 = $request->trimValueOf('item_address2');	// 住所
		$phone = $request->trimValueOf('item_phone');	// 電話番号
		$fax = $request->trimValueOf('item_fax');	// FAX
		$email = $request->trimValueOf('item_email');	// Email
		$email2 = $request->trimValueOf('item_email2');	// Email確認用
		
		$act = $request->trimValueOf('act');
		if ($act == 'regist'){			// 購入者登録
			$this->checkInput($name, '名前');		
			$this->checkInput($nameKana, '名前カナ');
			$this->checkSingleByte($zipcode, '郵便番号');
			$this->checkNumeric($this->state, '都道府県');
			$this->checkInput($address, '住所');	
			$this->checkSingleByte($phone, '電話番号');
			$this->checkMailAddress($email, 'Eメール');
			$this->checkMailAddress($email2, 'Eメール(確認)');
			
			if ($this->getMsgCount() == 0){			// メールアドレスのチェック
				if ($email != $email2) $this->setAppErrorMsg('Eメールアドレスに誤りがあります');
			}
				
			// エラーなしの場合
			if ($this->getMsgCount() == 0){
				$canRegist = false;			// 登録可能かどうか
				if (empty($this->userId)){			// 非会員の購入の場合
					$cid = $this->gAccess->getClientId();			// ブラウザのクライアントIDを取得
					if (!empty($cid)){
						// 顧客は購入者の情報
						$custm_id = 0;
						$custm_name = $name;
						$custm_name_kana = $nameKana;
						$custm_person = '';
						$custm_person_kana = '';
						$custm_zipcode = $zipcode;
						$custm_state_id = $this->state;
						$custm_address = $address;
						$custm_address2 = $address2;
						$custm_phone = $phone;
						$custm_fax = '';
						$custm_email = $email;
						$custm_country_id = '';
						$canRegist = true;			// 登録可能
					}
				} else {		// 会員の購入の場合
					// 購入者の情報を取得
					$ret = $this->db->getMemberInfo($this->userId, $memberInfo, $personInfo, $companyInfo, $addressRow);
					if ($ret){
						// 現在のログインユーザを購入者とする。購入者のID(会員ID)を取得
						$custm_id = 0;
						$ret = $this->db->getMember($this->userId, $memberRow);
						if ($ret) $custm_id = $memberRow['sm_id'] * (-1);		// 会員IDに「-」を付けて格納

						// 顧客は購入者の情報
						$custm_name = $personInfo['pi_family_name'] . $personInfo['pi_first_name'];
						$custm_name_kana = $personInfo['pi_family_name_kana'] . $personInfo['pi_first_name_kana'];
						$custm_person = '';
						$custm_person_kana = '';
						$custm_zipcode = $addressRow['ad_zipcode'];
						$custm_state_id = $addressRow['ad_state_id'];
						$custm_address = $addressRow['ad_address1'];
						$custm_address2 = $addressRow['ad_address2'];
						$custm_phone = $addressRow['ad_phone'];
						$custm_fax = $addressRow['ad_fax'];
						$custm_email = $personInfo['pi_email'];
						$custm_country_id = $addressRow['ad_country_id'];
					
						$cid = '';			// ブラウザのクライアントIDは使用しない
						$canRegist = true;			// 登録可能
					} else {
						$this->setAppErrorMsg('ログイン中のユーザはEコマース会員登録されていません。会員登録が必要です。');
					}
				}
				if ($canRegist){			// 登録可能なとき
					// 格納値初期化
					if (empty($this->userId)){			// 非会員の購入の場合
						$ret = $this->db->getOrderSheetByClientId($cid, $row);
						if (!$ret) $this->db->delOrderSheetByClientId($this->gAccess->getClientId());		// エラーのときはエラーデータを削除
					} else {		// 会員の購入の場合
						$ret = $this->db->getOrderSheet($this->userId, $this->langId, $row);
					}
					// 既存データがあるなしに関わらずデータを初期化
					// ***** 請求先は購入者の情報で初期化 *****
					$bill_id = $custm_id;
					$bill_name = $custm_name;
					$bill_name_kana = $custm_name_kana;
					$bill_person = $custm_person;
					$bill_person_kana = $custm_person_kana;
					$bill_zipcode = $custm_zipcode;
					$bill_state_id = $custm_state_id;
					$bill_address = $custm_address;
					$bill_address2 = $custm_address2;
					$bill_phone = $custm_phone;
					$bill_fax = $custm_fax;
					$bill_email = $custm_email;
					$bill_country_id = $custm_country_id;
						
					// 配送先を初期化
					$deliv_id = 0;
					$deliv_name = '';
					$deliv_name_kana = '';
					$deliv_person = '';
					$deliv_person_kana = '';
					$deliv_zipcode = '';
					$deliv_state_id = 0;
					$deliv_address = '';
					$deliv_address2 = '';
					$deliv_phone = '';
					$deliv_fax = '';
					$deliv_email = '';
					$deliv_country_id = '';
					
					// 配送方法、支払方法を初期化
					$deliv_method_id = '';			// 配送方法
					$pay_method_id = '';			// 支払方法
					$card_type = '';
					$card_owner = '';
					$card_number = '';
					$card_expires = '';
					$demand_dt = $this->gEnv->getInitValueOfTimestamp();		// 希望日
					$demand_time = '';	// 希望時間帯
					$appoint_dt = $this->gEnv->getInitValueOfTimestamp();		// 予定納期
						
					// 金額を初期化
					$currency_id = '';
					$subtotal = 0;		// 商品合計
					$deliv_fee = 0;		// 配送料
					$charge = 0;		// 手数料
					$discount = 0;		// 値引き額
					$total = $subtotal - $discount + $deliv_fee + $charge;		// 総支払額を求める
					
					$ret = $this->db->updateOrderSheet($this->userId, $this->langId, $cid,
						$custm_id, $custm_name, $custm_name_kana, $custm_person, $custm_person_kana, $custm_zipcode, $custm_state_id, $custm_address, $custm_address2, $custm_phone, $custm_fax, $custm_email, $custm_country_id, 
						$deliv_id, $deliv_name, $deliv_name_kana, $deliv_person, $deliv_person_kana, $deliv_zipcode, $deliv_state_id, $deliv_address, $deliv_address2, $deliv_phone, $deliv_fax, $deliv_email, $deliv_country_id,
						$bill_id,  $bill_name,  $bill_name_kana,  $bill_person,  $bill_person_kana,  $bill_zipcode,  $bill_state_id,  $bill_address, $bill_address2,  $bill_phone,  $bill_fax, $bill_email, $bill_country_id,
						$deliv_method_id, $pay_method_id, $card_type, $card_owner, $card_number, $card_expires, $demand_dt, $demand_time, $appoint_dt, $currency_id, $subtotal, $discount, $deliv_fee, $charge, $total);
					// エラーがなければ配送先入力画面へ
					if ($ret){
						$deliveryPage = $this->gEnv->createCurrentPageUrl() . '&task=delivery';
						$this->gPage->redirect($deliveryPage);
						return;
					} else {
						$this->setAppErrorMsg('登録処理に失敗しました。');
					}
				}
			}
		} else {		// 初期表示
			// ユーザが認識できない場合のみ初期値を取得
			if (empty($this->userId)){
				$ret = $this->db->getOrderSheetByClientId($this->gAccess->getClientId(), $row);// クライアントIDから登録データを取得
				if ($ret){
					$name = $row['oe_custm_name'];
					$nameKana = $row['oe_custm_name_kana'];
					$zipcode = $row['oe_custm_zipcode'];
					$address = $row['oe_custm_address1'];
					$address2 = $row['oe_custm_address2'];
					$phone = $row['oe_custm_phone'];
					$this->state = $row['oe_custm_state_id'];
					$email = $row['oe_custm_email'];
					$email2 = $row['oe_custm_email'];
				} else {
					$this->db->delOrderSheetByClientId($this->gAccess->getClientId());		// エラーのときはエラーデータを削除
				}
			}
		}
		
		// 入力値を戻す
		$this->tmpl->addVar("_widget", "name", $name);
		$this->tmpl->addVar("_widget", "name_kana", $nameKana);
		$this->tmpl->addVar("_widget", "zipcode", $zipcode);
		$this->tmpl->addVar("_widget", "address", $address);
		$this->tmpl->addVar("_widget", "address2", $address2);
		$this->tmpl->addVar("_widget", "phone", $phone);
		$this->tmpl->addVar("_widget", "email", $email);
		$this->tmpl->addVar("_widget", "email2", $email2);
		
		// 都道府県を設定
		$this->db->getAllState('JPN', $this->langId, array($this, 'stateLoop'));
		
		// タイトルのCSSを設定
		$this->tmpl->addVar("_widget", "class", $this->gDesign->getDefaultContentHeadClassString());		// コンテンツヘッダ用CSSクラス
		
		// 遷移先を設定
		$this->tmpl->addVar("_widget", "login_url", $this->gEnv->createCurrentPageUrl() . '&task=login');		// ログイン用URL
	}
	/**
	 * 取得した都道府県をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function stateLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		if ($fetchedRow['gz_id'] == $this->state){		// 選択中の都道府県
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['gz_id']),			// ID
			'name'     => $this->convertToDispString($fetchedRow['gz_name']),			// 表示名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('state_list', $row);
		$this->tmpl->parseTemplate('state_list', 'a');
		return true;
	}
}
?>
