<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_ec_menuWidgetContainer.php 2048 2009-07-07 06:12:22Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/ec_menuDb.php');

class admin_ec_menuWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $serialNo;		// 選択中の項目のシリアル番号
	private $serialArray = array();			// 表示中のシリアル番号
	private $langId;
	private $categoryListData;		// 商品カテゴリー
	private $categoryArray;			// カテゴリー設定値
	CONST EC_MENU_ID = 'ec_menu';
	const CATEGORY_COUNT = 2;				// 商品カテゴリーの選択可能数
	const PARAM_CONTENT_ID = 'pcontent';	// コンテンツIDキー
	const PARAM_CATEGORY_ID = 'category';	// カテゴリーIDキー
	const CONTENT_TYPE = 'ec_menu';			// コンテンツタイプ
	//const VIEW_WIDGET = 'ec_main';			// 表示用ウィジェット
	const VIEW_WIDGET = 'ec_disp';			// 表示用ウィジェット
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_menuDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'detail'){		// 詳細画面
			return 'admin_menu_detail.tmpl.html';
		} else {			// 一覧画面
			return 'admin_menu.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'detail'){	// 詳細画面
			return $this->createDetail($request);
		} else {			// 一覧画面
			return $this->createList($request);
		}
	}
	/**
	 * 一覧画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createList($request)
	{
		$userId		= $this->gEnv->getCurrentUserId();
		$this->langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		$act = $request->trimValueOf('act');
		
		if ($act == 'updatemenu'){		// メニュー項目順の更新のとき
			$menuitems = $request->trimValueOf('menuitems');
			if (!empty($menuitems)){
				$menuItemNoArray = explode(',', $menuitems);
			
				// メニューの並び順を変更
				$this->db->orderMenuItems(self::EC_MENU_ID, $this->langId, $menuItemNoArray);
			}
			$this->gPage->updateParentWindow();// 親ウィンドウを更新
		} else if ($act == 'delete'){		// メニュー項目の削除
			$listedItem = explode(',', $request->trimValueOf('seriallist'));
			$delItems = array();
			for ($i = 0; $i < count($listedItem); $i++){
				// 項目がチェックされているかを取得
				$itemName = 'item' . $i . '_selected';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
				if ($itemValue){		// チェック項目
					$delItems[] = $listedItem[$i];
				}
			}
			if (count($delItems) > 0){
				$ret = $this->delMenuItems($delItems);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
			$this->gPage->updateParentWindow();// 親ウィンドウを更新
		}
		// メニュー項目を取得
		$this->db->getAllMenuItems(array($this, 'itemListLoop'), self::EC_MENU_ID, $this->langId);

		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
		$this->tmpl->addVar('_widget', 'admin_url', $this->gEnv->getDefaultAdminUrl());// 管理者URL
	}
	/**
	 * 詳細画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		$userId		= $this->gEnv->getCurrentUserId();
		$this->langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		
		$name = $request->trimValueOf('item_name');
		$linkType = $request->trimValueOf('link_type_list');
		$html = $request->valueOf('item_html');		// ヘッダコンテンツ
		$visible = ($request->trimValueOf('item_visible') == 'on') ? 1 : 0;		// チェックボックス
		$enable = ($request->trimValueOf('item_enable') == 'on') ? 1 : 0;		// チェックボックス
		// カテゴリーを取得
		$this->categoryArray = array();
		for ($i = 0; $i < self::CATEGORY_COUNT; $i++){
			$itemName = 'item_category' . $i;
			$itemValue = $request->trimValueOf($itemName);
			if (!empty($itemValue)){		// 0以外の値を取得
				$this->categoryArray[] = $itemValue;
			}
		}
		
		$replaceNew = false;		// データを再取得するかどうか
		if ($act == 'add'){// 新規追加
			// 入力チェック
			$this->checkInput($name, '名前');

			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				// トランザクションスタート
				$this->db->startTransaction();
				
				// コンテンツ登録
				$contentId = 0;// コンテンツID初期化
				$default = 0;
				$key = '';
				$ret = $this->db->updateContentItem(self::CONTENT_TYPE, $contentId, $this->langId, $name, $html, 1/*コンテンツ表示*/, $default, $key, $userId, $newContentId, $newSerial);
				if ($ret) $contentId = $newContentId;// コンテンツID更新
				
				// IDを生成
				if ($ret){
					// パラメータ作成
					$param = self::PARAM_CATEGORY_ID . '=' . implode(',', $this->categoryArray) . '&' . self::PARAM_CONTENT_ID . '=' . $contentId;
				
					$id = $this->db->getNewMenuId();
					$ret = $this->db->addMenuItem(self::EC_MENU_ID, $id, $this->langId, $name, 0, $linkType, '', $param, $visible, $enable, $userId, $newSerial);
				}
				// トランザクション終了
				$ret = $this->db->endTransaction();
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					$this->serialNo = $newSerial;		// シリアル番号を更新
					$replaceNew = true;		// データを再取得するかどうか
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
			}
		} else if ($act == 'update'){		// 項目更新の場合
			$this->checkInput($name, '名前');

			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				// トランザクションスタート
				$this->db->startTransaction();
				
				$ret = $this->db->getMenuBySerial($this->serialNo, $row);
				if ($ret){
					// ヘッダコンテンツIDを取得
					$param = $row['mi_param'];
					$parsedParam = parseUrlParam($param);
					$contentId = $parsedParam[self::PARAM_CONTENT_ID];
					if ($contentId == '') $contentId = 0;		// コンテンツID初期化
				}
										
				// コンテンツを更新
				if ($ret){
					$default = 0;
					$key = '';
					$ret = $this->db->updateContentItem(self::CONTENT_TYPE, $contentId, $this->langId, $name, $html, 1/*コンテンツ表示*/, $default, $key, $userId, $newContentId, $newSerial);
					if ($ret) $contentId = $newContentId;// コンテンツID更新
				}
				
				if ($ret){
					// パラメータ作成
					$param = self::PARAM_CATEGORY_ID . '=' . implode(',', $this->categoryArray) . '&' . self::PARAM_CONTENT_ID . '=' . $contentId;
					// メニューを更新
					$ret = $this->db->updateMenuItemBySerial($this->serialNo, self::EC_MENU_ID, $name, 0, $linkType, '', $param, $visible, $enable, $userId);
				}
				
				// トランザクション終了
				$ret = $this->db->endTransaction();
				if ($ret){
					$this->setGuidanceMsg('データを更新しました');
					$replaceNew = true;		// データを再取得するかどうか
				} else {
					$this->setAppErrorMsg('データ更新に失敗しました');
				}
			}
		} else if ($act == 'delete'){		// 項目削除の場合
			if (empty($this->serialNo)){
				$this->setUserErrorMsg('削除項目が選択されていません');
			}
			// エラーなしの場合は、データを削除
			if ($this->getMsgCount() == 0){
				$ret = $this->delMenuItems(array($this->serialNo));
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else {
			if (empty($this->serialNo)){		// 新規項目追加のとき
				$id = 0;			// ID
				$name = '';		// 名前
				$linkType = 0;	// リンクタイプ
				$visible = 1;
				$enable = 1;
				$url = '';	// リンク先			
			} else {
				$replaceNew = true;		// データを再取得するかどうか
			}
		}
		if ($replaceNew){		// データを再取得するとき
			$ret = $this->db->getMenuBySerial($this->serialNo, $row);
			if ($ret){
				// 取得値を設定
				$id = $row['mi_id'];			// ID
				$name = $row['mi_name'];		// 名前
				$linkType = $row['mi_link_type'];	// リンクタイプ
				$visible = $row['mi_visible'];
				$enable = $row['mi_enable'];
				$this->serialNo = $row['mi_serial'];
				$url = $row['mi_link_url'];	// リンク先
				
				// カテゴリーIDとヘッダコンテンツIDを取得
				$param = $row['mi_param'];
				$parsedParam = parseUrlParam($param);
				$contentId = $parsedParam[self::PARAM_CONTENT_ID];
				$this->categoryArray = explode(',', $parsedParam[self::PARAM_CATEGORY_ID]);
				
				// コンテンツを取得
				$ret = $this->db->getContentByContentId(self::CONTENT_TYPE, $contentId, $this->langId, $row);
				if ($ret){
					$html = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->gEnv->getRootUrl(), $row['cn_html']);// アプリケーションルートを変換
				}
			}
		}
		// カテゴリーメニューを作成
		$this->db->getAllCategory($this->langId, $this->categoryListData);
		$this->createCategoryMenu();
		
		// プレビュー用リンク先
		if (!empty($param)) $url = $this->gPage->getDefaultPageUrlByWidget(self::VIEW_WIDGET, $param);
		
		// ### 入力値を再設定 ###
		$this->tmpl->addVar("_widget", "sel_item_name", $name);		// 名前
		$this->tmpl->addVar("_widget", "sel_item_url", $url);		// URL
		$this->tmpl->addVar("_widget", "save_url", $url);		// URL
		$this->tmpl->addVar("_widget", "sel_item_html", $html);		// ヘッダコンテンツ
		
		// リンクタイプ
		switch ($linkType){
			case 0:			// 同ウィンドウで開くリンク
				$this->tmpl->addVar("_widget", "link_type_0", 'selected');
				break;
			case 1:			// 別ウィンドウで開くリンク
				$this->tmpl->addVar("_widget", "link_type_1", 'selected');
				break;
		}
		// 項目表示、項目利用可否チェックボックス
		$visibleStr = '';
		if ($visible){
			$visibleStr = 'checked';
		}
		$enableStr = '';
		if ($enable){
			$enableStr = 'checked';
		}
		$this->tmpl->addVar("_widget", "sel_item_visible", $visibleStr);
		$this->tmpl->addVar("_widget", "sel_item_enable", $enableStr);
		
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);// 選択中のシリアル番号、IDを設定
		$this->tmpl->addVar("_widget", "root_url", $this->gEnv->getRootUrl());// FCKEditor用
		$this->tmpl->addVar("_widget", "widget_sc_url", $this->gEnv->getCurrentWidgetScriptsUrl());// FCKEditor用

		// ボタンの表示制御
		if (empty($this->serialNo)){		// 新規追加項目を選択しているとき
			//$this->tmpl->addVar("_widget", "title", 'メニュー項目新規');// タイトル
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
		} else {
			//$this->tmpl->addVar("_widget", "title", 'メニュー項目更新');// タイトル
			$this->tmpl->setAttribute('del_button', 'visibility', 'visible');// 「削除」ボタン
		}
	}
	/**
	 * メニュー項目削除
	 *
	 * @param array $serial		削除するメニュー項目
	 * @param bool				true=成功、false=失敗
	 */
	function delMenuItems($serial)
	{
		$userId		= $this->gEnv->getCurrentUserId();
				
		// トランザクションスタート
		$this->db->startTransaction();
		
		for ($i = 0; $i < count($serial); $i++){
			$ret = $this->db->getMenuBySerial($serial[$i], $row);
			if ($ret){
				// ヘッダコンテンツIDを取得
				$param = $row['mi_param'];
				$parsedParam = parseUrlParam($param);
				$contentId = $parsedParam[self::PARAM_CONTENT_ID];
				if ($contentId == '') $contentId = 0;		// コンテンツID初期化
			}
			if ($ret) $ret = $this->db->delMenuItem($serial[$i]);
			if ($ret) $ret = $this->db->delContentItem(self::CONTENT_TYPE, $contentId, $this->langId, $userId);		// コンテンツを削除
			if (!$ret){			// エラーの場合は終了
				$this->db->endTransaction();
				return false;
			}
		}
		// トランザクション終了
		$ret = $this->db->endTransaction();
		return $ret;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function itemListLoop($index, $fetchedRow, $param)
	{
		static $rowno = 0;
		
		$serial = $fetchedRow['mi_serial'];		// シリアル番号
		
		$visible = '';
		if ($fetchedRow['mi_visible']){
			$visible = 'checked';
		}
		$enable = '';
		if ($fetchedRow['mi_enable']){
			$enable = 'checked';
		}
		// 行カラーの設定
		/*$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}*/
		// リンクタイプ
		$linkString = '';
		switch ($fetchedRow['mi_link_type']){
			case 0:			// 同ウィンドウで開くリンク
				$linkString = '同ウィンドウ';
				break;
			case 1:			// 別ウィンドウで開くリンク
				$linkString = '別ウィンドウ';
				break;
		}
		// リンク先URL作成
		$linkUrl = $this->gPage->getDefaultPageUrlByWidget(self::VIEW_WIDGET, $fetchedRow['mi_param']);
		$linkUrlStr = '<div style="overflow:auto;"><a href="#" onClick="showUrl(\'' . $linkUrl . '\');">' . $linkUrl . '</a></div>';
		
		// カテゴリー名を取得
		$param = $fetchedRow['mi_param'];
		$parsedParam = parseUrlParam($param);
		$categoryParam = $parsedParam[self::PARAM_CATEGORY_ID];
		$category = '';
		if (!empty($categoryParam)){
			$ret = $this->db->getCategory($this->langId, $categoryParam, $rows);
			if ($ret){
				$count = count($rows);
				for ($i = 0; $i < $count; $i++){
					$category .= $rows[$i]['pc_name'];
					if ($i != $count -1) $category .= ',';
				}
			}
		}
		$row = array(
			//'line_color' => $lineColor,											// 行のカラー
			'index' => $index,													// 行番号
			'rowno' => $rowno,													// 行番号
			'serial' => $serial,			// シリアル番号
			'id' => $this->convertToDispString($fetchedRow['mi_id']),			// ID
			'name' => $this->convertToDispString($fetchedRow['mi_name']),		// 名前
			'link_type' => $linkString,											// リンクタイプ
			'link_str' => $linkUrlStr,		// リンクURL
			'category' => $category,											// カテゴリー
			'update_dt' => $this->convertToDispDateTime($fetchedRow['mi_create_dt']),	// 更新日時
			'visible' => $visible,											// メニュー項目表示制御
			'enable' => $enable												// メニュー項目利用制御
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		// メニューのプレビュー
		if ($fetchedRow['mi_visible']){		// 表示項目のみ追加
			$this->tmpl->addVars('menuitemlist', $row);
			$this->tmpl->parseTemplate('menuitemlist', 'a');
			$rowno++;
		}
		
		// シリアル番号を保存
		$this->serialArray[] = $serial;
		return true;
	}
	/**
	 * 商品カテゴリーメニューを作成
	 *
	 * @return なし						
	 */
	function createCategoryMenu()
	{
		for ($j = 0; $j < self::CATEGORY_COUNT; $j++){
			// selectメニューの作成
			$this->tmpl->clearTemplate('category_list');
			for ($i = 0; $i < count($this->categoryListData); $i++){
				$categoryId = $this->categoryListData[$i]['pc_id'];
				$selected = '';
				if ($j < count($this->categoryArray) && $this->categoryArray[$j] == $categoryId){
					$selected = 'selected';
				}
				$menurow = array(
					'value'		=> $categoryId,			// カテゴリーID
					'name'		=> $this->categoryListData[$i]['pc_name'],			// カテゴリー名
					'selected'	=> $selected														// 選択中かどうか
				);
				$this->tmpl->addVars('category_list', $menurow);
				$this->tmpl->parseTemplate('category_list', 'a');
			}
			$itemRow = array(		
					'index'		=> $j			// 項目番号											
			);
			$this->tmpl->addVars('category', $itemRow);
			$this->tmpl->parseTemplate('category', 'a');
		}
	}
}
?>
