<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_photoslideWidgetContainer.php 2263 2009-08-28 05:21:34Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseAdminWidgetContainer.php');

class admin_photoslideWidgetContainer extends BaseAdminWidgetContainer
{
	private $sysDb;	// DB接続オブジェクト
	private $serialNo;		// 選択中の項目のシリアル番号
	private $serialArray = array();			// 表示中のシリアル番号
	private $langId;
	private $configId;		// 定義ID
	private $paramObj;		// パラメータ保存用オブジェクト
	private $effectItems = array('blindX', 'blindY', 'blindZ', 'cover', 'curtainX', 'curtainY', 'fade', 'fadeZoom', 'growX', 'growY', 'scrollUp', 'scrollDown',
								'scrollLeft', 'scrollRight', 'scrollHorz', 'scrollVert', 'shuffle', 'slideX', 'slideY', 'toss', 'turnUp', 'turnDown',
								'turnLeft', 'turnRight', 'uncover', 'wipe', 'zoom');
	private $speedItems = array('slow', 'normal', 'fast');
	private $effect;		// 選択中のエフェクト
	private $speed;			// エフェクトのspeedパラメータ
	private $css;			// 追加CSS
	const DEFAULT_NAME_HEAD = '名称未設定';			// デフォルトの設定名
	const DEFAULT_DIR = '/resource/image/sample/photo';			// デフォルト読み込みディレクトリ
	const DEFAULT_CSS = ".photoslide {\n    height:  160px;\n    width:   180px;\n    padding: 0;\n    margin:  0;\n}\n.photoslide img {\n    padding: 10px;\n    border:  1px solid #ccc;\n    background-color: #eee;\n    width:  150px;\n    height: 113px;\n    top:  0;\n    left: 0;\n}";
	const DEFAULT_EFFECT = 'fade';		// デフォルトのエフェクト
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'list'){		// 一覧画面
			return 'admin_list.tmpl.html';
		} else {			// 一覧画面
			return 'admin.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'list'){		// 一覧画面
			return $this->createList($request);
		} else {			// 詳細設定画面
			return $this->createDetail($request);
		}
	}
	/**
	 * 詳細画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		global $gEnvManager;
		global $gPageManager;
		
		$userId		= $gEnvManager->getCurrentUserId();
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		
		// ページ定義IDとページ定義のレコードシリアル番号
		$defConfigId = $this->getPageDefConfigId($request);				// 定義ID取得
		$defSerial = $this->getPageDefSerial($request);		// ページ定義のレコードシリアル番号
		$value = $request->trimValueOf('defconfig');		// ページ定義の定義ID
		if (!empty($value)) $defConfigId = $value;
		$value = $request->trimValueOf('defserial');		// ページ定義のレコードシリアル番号
		if (!empty($value)) $defSerial = $value;

		$name	= $request->trimValueOf('item_name');			// ヘッダタイトル
		$url	= $request->trimValueOf('item_url');		// 画像読み込みURL
		$this->css	= $request->trimValueOf('item_css');		// 追加CSS
		$showTitle = ($request->trimValueOf('item_showtitle') == 'on') ? 1 : 0;		// タイトルを表示するかどうか
		$this->effect	= $request->trimValueOf('item_effect');		// エフェクト
		$this->speed	= $request->trimValueOf('item_speed');
		$this->configId = $request->trimValueOf('item_id');		// 定義ID
		if (empty($this->configId)) $this->configId = $defConfigId;		// 呼び出しウィンドウから引き継いだ定義ID
				
		// パラメータオブジェクトを取得
		$this->paramObj = $this->getWidgetParamObjectWithId();
		
		$replaceNew = false;		// データを再取得するかどうか
		if (empty($act)){// 初期起動時
			// デフォルト値設定
			$this->configId = $defConfigId;		// 呼び出しウィンドウから引き継いだ定義ID
			$replaceNew = true;			// データ再取得
		} else if ($act == 'add'){// 新規追加
			// 入力チェック
			$this->checkInput($name, '名前');
			$this->checkInput($url, '画像読み込みディレクトリ');
			$this->checkInput($this->effect, 'エフェクト');
			
			// 設定名の重複チェック
			for ($i = 0; $i < count($this->paramObj); $i++){
				$targetObj = $this->paramObj[$i]->object;
				if ($name == $targetObj->name){		// 定義名
					$this->setUserErrorMsg('名前が重複しています');
					break;
				}
			}
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				// 追加オブジェクト作成
				$newObj = new stdClass;
				$newObj->name	= $name;// 表示名
				$newObj->url = $url;		// 画像読み込みURL
				$newObj->css = $this->css;		// 追加CSS
				$newObj->showTitle	= $showTitle;					// タイトルを表示するかどうか
				$newObj->effect		= $this->effect;				// エフェクト
				$newObj->speed		= $this->speed;
				
				$newParam = new stdClass;
				$newParam->id = -1;		// 新規追加
				$newParam->object = $newObj;
			
				// ウィジェットパラメータオブジェクト更新
				$ret = $this->updateWidgetParamObjectWithId($newParam);
				if ($ret){
					$this->paramObj[] = $newParam;		// 新規定義を追加
					$newConfigId = $newParam->id;
				}
				
				// 画面定義更新
				if ($ret && !empty($defSerial)){
					$ret = $this->sysDb->updateWidgetConfigId($gEnvManager->getCurrentWidgetId(), $defSerial, $newConfigId, $name);
				}
				
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					
					if (!empty($defSerial)) $defConfigId = $newConfigId;		// 定義定義IDを更新
					$this->configId = $newConfigId;		// 定義定義IDを更新
					$replaceNew = true;			// データ再取得
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
				$gPageManager->updateParentWindow($defSerial);// 親ウィンドウを更新
			}
		} else if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			$this->checkInput($url, '画像読み込みディレクトリ');
			$this->checkInput($this->effect, 'エフェクト');
			
			if ($this->getMsgCount() == 0){			// エラーのないとき
				// 該当項目を更新
				$ret = false;
				for ($i = 0; $i < count($this->paramObj); $i++){
					$id			= $this->paramObj[$i]->id;// 定義ID
					$targetObj	= $this->paramObj[$i]->object;
					if ($id == $this->configId){
						// ウィジェットオブジェクト更新
						$targetObj->url	= $url;		// 画像読み込みURL
						$targetObj->css = $this->css;		// 追加CSS
						$targetObj->showTitle	= $showTitle;					// タイトルを表示するかどうか
						$targetObj->effect		= $this->effect;				// エフェクト
						$targetObj->speed		= $this->speed;
						
						// ウィジェットパラメータオブジェクトを更新
						$ret = $this->updateWidgetParamObjectWithId($this->paramObj[$i]);
						break;
					}
				}
				
				if (empty($defConfigId) && !empty($defSerial)){		// 画面定義の定義IDが設定されていないときは設定
					// 画面定義更新
					if ($ret) $ret = $this->sysDb->updateWidgetConfigId($gEnvManager->getCurrentWidgetId(), $defSerial, $this->configId, $targetObj->name);
				}
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					
					if (empty($defConfigId) && !empty($defSerial)){		// 画面定義の定義IDが設定されていないときは設定
						$defConfigId = $this->configId;		// 定義定義IDを更新
					}
					$replaceNew = true;			// データ再取得
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
				$gPageManager->updateParentWindow($defSerial);// 親ウィンドウを更新
			}
		} else if ($act == 'select'){	// 定義IDを変更
			$replaceNew = true;			// データ再取得
		}
		
		// 設定項目選択メニュー作成
		$this->createItemMenu();
		
		// 表示用データを取得
		if (empty($this->configId)){		// 新規登録の場合
			$this->tmpl->setAttribute('item_name_visible', 'visibility', 'visible');// 名前入力フィールド表示
			$name = $this->createDefaultName();			// デフォルト登録項目名
			$url = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . self::DEFAULT_DIR;		// FlashファイルのURL
			$this->css = self::DEFAULT_CSS;		// 追加CSS
			$showTitle = 1;					// タイトルを表示するかどうか
			$this->effect	= self::DEFAULT_EFFECT;				// エフェクト
			$this->speed	= '';
			$this->serialNo = 0;
		} else {
			// 定義からウィジェットパラメータを検索して、定義データを取得
			for ($i = 0; $i < count($this->paramObj); $i++){
				$id			= $this->paramObj[$i]->id;// 定義ID
				$targetObj	= $this->paramObj[$i]->object;
				if ($id == $this->configId) break;
			}
			if ($i < count($this->paramObj)){		// 該当項目があるとき
				// ウィジェットオブジェクトから値を取得
				if ($replaceNew){		// データ再取得のとき
					$name	= $targetObj->name;// 名前
					$url	= $targetObj->url;		// 画像読み込みURL
					$this->css	= $targetObj->css;		// 追加CSS
					$showTitle		= $targetObj->showTitle;		// タイトルを表示するかどうか
					$this->effect	= $targetObj->effect;			// エフェクト
					$this->speed	= $targetObj->speed;
				}
				$this->serialNo = $this->configId;
				
				// 新規作成でないときは、メニューを変更不可にする
				if (!empty($defConfigId) && !empty($defSerial)) $this->tmpl->addVar("_widget", "id_disabled", 'disabled');
			}
		}
		// エフェクトメニュー作成
		$this->createEffectMenu();
		
		// プレビュースライドショー用画像一覧作成
		$this->createImageList($url);
		
		// エフェクト設定を作成
		$effectStr = $this->createEffect($this->effect, $this->speed);
		$this->tmpl->addVar('_widget', 'effect', $effectStr);
		
		// 画面にデータを埋め込む
		$this->tmpl->addVar("item_name_visible", "name", $name);		// 名前
		$this->tmpl->addVar("_widget", "url",	$url);
		$this->tmpl->addVar("_widget", "css",	$this->css);
		
		$checked = '';
		if ($showTitle) $checked = 'checked';
		$this->tmpl->addVar("_widget", "show_title", $checked);	// タイトルを表示するかどうか
				
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);// 選択中のシリアル番号、IDを設定
		
		// 画面定義用の情報を戻す
		$this->tmpl->addVar("_widget", "def_serial", $defSerial);	// ページ定義のレコードシリアル番号
		$this->tmpl->addVar("_widget", "def_config", $defConfigId);	// ページ定義の定義ID
		
		// ボタンの表示制御
		if (empty($this->serialNo)){		// 新規追加項目を選択しているとき
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
		} else {
			$this->tmpl->setAttribute('update_button', 'visibility', 'visible');// 「更新」ボタン
		}
	}
	/**
	 * CSSデータをHTMLヘッダ部に設定
	 *
	 * CSSデータをHTMLのheadタグ内に追加出力する。
	 * _assign()よりも後に実行される。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。
	 * @return string 						CSS文字列。出力しない場合は空文字列を設定。
	 */
	function _addCssToHead($request, &$param)
	{
		return $this->css;
	}
	/**
	 * 選択用メニューを作成
	 *
	 * @return なし						
	 */
	function createItemMenu()
	{
		for ($i = 0; $i < count($this->paramObj); $i++){
			$id = $this->paramObj[$i]->id;// 定義ID
			$targetObj = $this->paramObj[$i]->object;
			$name = $targetObj->name;// 定義名
			$selected = '';
			if ($this->configId == $id) $selected = 'selected';

			$row = array(
				'name' => $name,		// 名前
				'value' => $id,		// 定義ID
				'selected' => $selected	// 選択中の項目かどうか
			);
			$this->tmpl->addVars('title_list', $row);
			$this->tmpl->parseTemplate('title_list', 'a');
		}
	}
	/**
	 * エフェクト選択用メニューを作成
	 *
	 * @return なし						
	 */
	function createEffectMenu()
	{
		for ($i = 0; $i < count($this->effectItems); $i++){
			$name = $this->effectItems[$i];
			$selected = '';
			if ($this->effect == $name) $selected = 'selected';

			$row = array(
				'name' => $name,		// 名前
				'value' => $name,		// 定義ID
				'selected' => $selected	// 選択中の項目かどうか
			);
			$this->tmpl->addVars('effect_list', $row);
			$this->tmpl->parseTemplate('effect_list', 'a');
		}
		for ($i = 0; $i < count($this->speedItems); $i++){
			$name = $this->speedItems[$i];
			$selected = '';
			if ($this->speed == $name) $selected = 'selected';

			$row = array(
				'name' => $name,		// 名前
				'value' => $name,		// 定義ID
				'selected' => $selected	// 選択中の項目かどうか
			);
			$this->tmpl->addVars('speed_list', $row);
			$this->tmpl->parseTemplate('speed_list', 'a');
		}
	}
	/**
	 * デフォルトの名前を取得
	 *
	 * @return string	デフォルト名						
	 */
	function createDefaultName()
	{
		$name = self::DEFAULT_NAME_HEAD;
		for ($j = 1; $j < 100; $j++){
			$name = self::DEFAULT_NAME_HEAD . $j;
			// 設定名の重複チェック
			for ($i = 0; $i < count($this->paramObj); $i++){
				$targetObj = $this->paramObj[$i]->object;
				if ($name == $targetObj->name){		// 定義名
					break;
				}
			}
			// 重複なしのときは終了
			if ($i == count($this->paramObj)) break;
		}
		return $name;
	}
	/**
	 * スライドショー用画像一覧を作成
	 *
	 * @param string $url		画像のあるディレクトリ(URL表記)
	 * @return なし							
	 */
	function createImageList($url)
	{
		global $gEnvManager;
		
		// 画像ディレクトリを読み込み
		$searchPath = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getSystemRootPath(), $url);		// 画像検索パス
		$urlPath = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $url);
		if (is_dir($searchPath)){
			$dir = dir($searchPath);
			while (($file = $dir->read()) !== false){
				$filePath = $searchPath . '/' . $file;
				// ファイルかどうかチェック
				if (strncmp($file, '.', 1) != 0 && $file != '..' && is_file($filePath)
					&& strncmp($file, '_', 1) != 0){		// 「_」で始まる名前のファイルは読み込まない
				
					$imageUrl = $urlPath . '/' . $file;
					$row = array(
						'url'    => $this->getUrl($imageUrl)			// ファイル名
					);
					$this->tmpl->addVars('image_list', $row);
					$this->tmpl->parseTemplate('image_list', 'a');
					
					// 画像一覧用
					$this->tmpl->addVars('image_list2', $row);
					$this->tmpl->parseTemplate('image_list2', 'a');
				}
			}
			$dir->close();
		}
	}
	/**
	 * エフェクトの設定を作成
	 *
	 * @param string $effect		エフェクト
	 * @param string $speed			speedパラメータ
	 * @return string				エフェクト文字列
	 */
	function createEffect($effect, $speed)
	{
		$effectStr = '';
		if (!empty($effect)) $effectStr .= 'fx: \'' . $effect . '\'';
		if (!empty($speed)){
			if (!empty($effectStr)) $effectStr .= ',';
			$effectStr .= 'speed: \'' . $speed . '\'';
		}
		return $effectStr;
	}
	/**
	 * 一覧画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createList($request)
	{
		global $gEnvManager;
		global $gPageManager;
		
		$userId		= $gEnvManager->getCurrentUserId();
		$langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$act = $request->trimValueOf('act');
		
		// ページ定義IDとページ定義のレコードシリアル番号
		$defConfigId = $this->getPageDefConfigId($request);				// 定義ID取得
		$defSerial = $this->getPageDefSerial($request);		// ページ定義のレコードシリアル番号
		$value = $request->trimValueOf('defconfig');		// ページ定義の定義ID
		if (!empty($value)) $defConfigId = $value;
		$value = $request->trimValueOf('defserial');		// ページ定義のレコードシリアル番号
		if (!empty($value)) $defSerial = $value;

		// パラメータオブジェクトを取得
		$this->paramObj = $this->getWidgetParamObjectWithId();
		
		if ($act == 'delete'){		// メニュー項目の削除
			$listedItem = explode(',', $request->trimValueOf('seriallist'));
			$delItems = array();
			for ($i = 0; $i < count($listedItem); $i++){
				// 項目がチェックされているかを取得
				$itemName = 'item' . $i . '_selected';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
				if ($itemValue){		// チェック項目
					$delItems[] = $listedItem[$i];
				}
			}
			if (count($delItems) > 0){
				for ($i = 0; $i < count($this->paramObj); $i++){
					$id			= $this->paramObj[$i]->id;// 定義ID
					if (in_array($id, $delItems)){		// 削除対象のとき
						$newParam = new stdClass;
						$newParam->id = $id;
						$newParam->object = null;		// 削除処理
						$ret = $this->updateWidgetParamObjectWithId($newParam);
						if (!$ret) break;
					}
				}
				
				// ウィジェットパラメータオブジェクト更新
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
				// パラメータオブジェクトを取得
				$this->paramObj = $this->getWidgetParamObjectWithId();
			}
		}
		// 定義一覧作成
		$this->createItemList();
		
		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
		
		// 画面定義用の情報を戻す
		$this->tmpl->addVar("_widget", "def_serial", $defSerial);	// ページ定義のレコードシリアル番号
		$this->tmpl->addVar("_widget", "def_config", $defConfigId);	// ページ定義の定義ID
	}
	/**
	 * 定義一覧作成
	 *
	 * @return なし						
	 */
	function createItemList()
	{
		global $gEnvManager;
		
		for ($i = 0; $i < count($this->paramObj); $i++){
			$id			= $this->paramObj[$i]->id;// 定義ID
			$targetObj	= $this->paramObj[$i]->object;
			$name = $targetObj->name;// 定義名
			
			// 読み込みディレクトリ
			$filename = trim(str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, '', $targetObj->url), '/');
			
			$defCount = 0;
			if (!empty($id)){
				$defCount = $this->sysDb->getPageDefCount($gEnvManager->getCurrentWidgetId(), $id);
			}
			$operationDisagled = '';
			if ($defCount > 0) $operationDisagled = 'disabled';
			$row = array(
				'index' => $i,
				'ope_disabled' => $operationDisagled,			// 選択可能かどうか
				'name' => $this->convertToDispString($name),		// 名前
				'filename' => $filename,		// ファイル名
				'url' => $this->getUrl($url),					// URL
				'width' => $targetObj->width,					// Flashファイル幅
				'height' => $targetObj->height,					// Flashファイル高さ
				'def_count' => $defCount							// 使用数
			);
			$this->tmpl->addVars('itemlist', $row);
			$this->tmpl->parseTemplate('itemlist', 'a');
			
			// シリアル番号を保存
			$this->serialArray[] = $id;
		}
	}
}
?>
