<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ec_mainSendpwdWidgetContainer.php 2264 2009-08-28 06:08:21Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_mainDb.php');

class ec_mainSendpwdWidgetContainer extends BaseWidgetContainer
{
	private $mainDb;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	const USE_EMAIL		= 'use_email';		// EMAIL機能が使用可能かどうか
	const SEND_PASSWORD_FORM = 'send_password';		// パスワード送信用フォーム
	const AUTO_EMAIL_SENDER	= 'auto_email_sender';		// 自動送信メール用送信者アドレス
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->mainDb = new ec_mainDb();
		$this->sysDb = $this->gInstance->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'sendpwd.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$act = $request->trimValueOf('act');
		$useEmail = $this->mainDb->getConfig(self::USE_EMAIL);
		if ($act == 'sendpassword'){			// パスワード再送信のとき
			$account = $request->trimValueOf('ec_account');
			if ($useEmail == '1'){		// メール送信可能のとき
				$isSend = false;
				if ($this->sysDb->getLoginUserRecord($account, $row)){		// アカウントからログインIDを取得
					// パスワード作成
					$password = $this->makePassword();
			
					// パスワード変更
					$ret = $this->sysDb->updateLoginUserPassword($row['lu_id'], $password);
					if ($ret){
					/*
						$fromAddress = $this->mainDb->getConfig(self::AUTO_EMAIL_SENDER);	// 自動送信送信元
						$toAddress = $account;			// eメール(ログインアカウント)
						$mailParam = array();
						$mailParam['PASSWORD'] = $password;*/
						//$ret = $this->gMail->sendFormMail(1/*自動送信*/, $this->gEnv->getCurrentWidgetId(), $toAddress, $fromAddress, '', '', self::SEND_PASSWORD_FORM, $mailParam);
						//$isSend = true;		// 送信完了
						$fromAddress = $this->mainDb->getConfig(self::AUTO_EMAIL_SENDER);	// 自動送信送信元
						if (empty($fromAddress)) $fromAddress = $this->gEnv->getSiteEmail();// 送信元が取得できないときは、システムのデフォルトメールアドレスを使用
						$toAddress = $account;			// eメール(ログインアカウント)
						//$forwardParam = M3_REQUEST_PARAM_FORWARD . '=' . urlencode('task=changepwd');		// パスワード変更画面へ遷移
						$url = $this->gEnv->createCurrentPageUrl() . '&task=login&act=ec_maillogin&account=' . 
										urlencode($account) . '&pwd=' . urlencode($password);		// ログイン用URL
						$mailParam = array();
						$mailParam['PASSWORD'] = $password;
						$mailParam['URL']		= $this->getUrl($url, true);		// ログイン用URL
						$ret = $this->gMail->sendFormMail(1/*自動送信*/, $this->gEnv->getCurrentWidgetId(), $toAddress, $fromAddress, '', '', self::SEND_PASSWORD_FORM, $mailParam);// 自動送信
						$isSend = true;		// 送信完了
					}
				}
				if ($isSend){
					$this->setGuidanceMsg('パスワード送信しました');
					$this->tmpl->addVar("_widget", "account_disabled", 'disabled');		// アカウント編集不可
					$this->tmpl->addVar("_widget", "button_disabled", 'disabled');		// ボタン使用不可
				} else {
					$this->setAppErrorMsg('パスワード送信に失敗しました');
				}
			} else {
				$this->setAppErrorMsg('パスワード送信できません');
			}
			$this->tmpl->addVar("_widget", "account", $account);		// アカウント再設定
		}
		if ($useEmail == 0){		// メール送信機能が使用可能になっていないとき
			$this->tmpl->addVar("_widget", "account_disabled", 'disabled');		// アカウント編集不可
			$this->tmpl->addVar("_widget", "button_disabled", 'disabled');		// ボタン使用不可
			$this->tmpl->addVar("_widget", "button_label", '送信機能停止中');		// ボタンのラベル
		} else {
			$this->tmpl->addVar("_widget", "button_label", 'パスワード送信');		// ボタンのラベル
		}
		// タイトルのCSSを設定
		$this->tmpl->addVar("_widget", "class", $this->gDesign->getDefaultContentHeadClassString());		// コンテンツヘッダ用CSSクラス
	}
}
?>
