<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: default_contentWidgetContainer.php 2296 2009-09-09 10:14:28Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/default_contentDb.php');
require_once($gEnvManager->getCommonPath() . '/valueCheck.php');

class default_contentWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $_contentCreated;	// コンテンツが取得できたかどうか
	private $currentDay;		// 現在日
	private $currentHour;		// 現在時間
	private $headTitle;		// HTMLヘッダタイトル
	private $showTitle;			// コンテンツタイトルの表示制御
	const CONTENT_TYPE = 'ct';		// 参照数カウント用
	const DEFAULT_SEARCH_LIST_COUNT = 20;			// 最大リスト表示数
	const MESSAGE_NO_CONTENT		= 'コンテンツが見つかりません';
	const CONTENT_SIZE = 200;			// 検索結果コンテンツの文字列最大長
	const DEFAULT_MESSAGE_DENY = 'コンテンツを表示できません';		// アクセス不可の場合のメッセージ
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new default_contentDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$act = $request->trimValueOf('act');
		if ($act == 'search'){
			return 'search.tmpl.html';
		} else {
			// Joomlaテンプレートのバージョンに合わせて出力
			$this->templateType = $this->gEnv->getCurrentTemplateType();
			if ($this->templateType == 0){			// Joomla!v1.0のとき
				return 'main_old.tmpl.html';
			} else {
				return 'main.tmpl.html';
			}
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		// 現在日時を取得
		$this->currentDay = date("Y/m/d");		// 日
		$this->currentHour = (int)date("H");		// 時間
		$this->currentPageUrl = $this->gEnv->createCurrentPageUrl();// 現在のページURL

		// ログインユーザでないときは、ユーザ制限のない項目だけ表示
		$all = false;
		if ($this->gEnv->isCurrentUserLogined()) $all = true;
		
		// ウィジェットパラメータ取得
		$this->showTitle = 1;			// コンテンツタイトルを表示するかどうか
		$showMessageDeny = 1;					// アクセス不可の場合にメッセージを表示するかどうか
		$messageDeny = self::DEFAULT_MESSAGE_DENY;							// アクセス不可の場合のメッセージ
		$paramObj = $this->getWidgetParamObj();
		if (!empty($paramObj)){
			$this->showTitle = $paramObj->showTitle;			// コンテンツタイトルを表示するかどうか
			$showMessageDeny = $paramObj->showMessageDeny;					// アクセス不可の場合にメッセージを表示するかどうか
			$messageDeny = $paramObj->messageDeny;							// アクセス不可の場合のメッセージ
		}
			
		$act = $request->trimValueOf('act');
		$contentid = $request->trimValueOf('contentid');
		$keyword = $request->trimValueOf('keyword');// 検索キーワード
		if ($act == 'search'){			// 検索
			$itemCount = self::DEFAULT_SEARCH_LIST_COUNT;		// 取得数
			
			// キーワード検索のとき
			if (empty($keyword)){
				$keyword = '検索キーワードが入力されていません';
				$this->headTitle = 'コンテンツ検索';
			} else {
				$this->db->searchContentByKeyword($itemCount, 1, $keyword, $this->gEnv->getCurrentLanguage(), $all, array($this, 'searchItemsLoop'));
				$this->headTitle = 'コンテンツ検索[' . $keyword . ']';
				if (!$this->isExistsViewData) $keyword .= '&nbsp;&nbsp;' . self::MESSAGE_NO_CONTENT;
			}
			$this->tmpl->addVar("_widget", "keyword", $keyword);
			$headClassStr = $this->gDesign->getDefaultContentHeadClassString();			// コンテンツヘッダ用CSSクラス
			$this->tmpl->addVar("_widget", "class", $headClassStr);
		} else if (empty($contentid)){	// コンテンツIDがないときはデフォルトデータを取得
			$this->db->getContentItems(array($this, 'itemsLoop'), null, $this->gEnv->getCurrentLanguage(), $all);
			if (!$this->_contentCreated){		// コンテンツが取得できなかったときはデフォルト言語で取得
				$this->db->getContentItems(array($this, 'itemsLoop'), null, $this->gEnv->getDefaultLanguage(), $all);
			}
		} else {		// コンテンツIDで指定
			// データエラーチェック
			$contentIdArray = explode(',', $contentid);
			if (ValueCheck::isNumeric($contentIdArray)){		// すべて数値であるかチェック
				$this->db->getContentItems(array($this, 'itemsLoop'), $contentIdArray, $this->gEnv->getCurrentLanguage(), $all);
				if (!$this->_contentCreated){		// コンテンツが取得できなかったときはデフォルト言語で取得
					$this->db->getContentItems(array($this, 'itemsLoop'), $contentIdArray, $this->gEnv->getDefaultLanguage(), $all);
				}
				
				// コンテンツアクセス不可のときはアクセス不可メッセージを出力
				if ($showMessageDeny && !$this->_contentCreated) $this->setAppErrorMsg($messageDeny);
			} else {
				$this->setAppErrorMsg('IDにエラー値があります');
			}
		}
		// HTMLサブタイトルを設定
		if (!empty($this->headTitle)) $this->gPage->setHeadSubTitle($this->headTitle);
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function itemsLoop($index, $fetchedRow)
	{
		// コンテンツタイトルの出力設定
		if (empty($this->showTitle)) $this->tmpl->addVar('contentlist', 'type', 'hide_title');
		
		// ビューカウントを更新
		if (!$this->gEnv->isSystemAdmin()){		// システム管理者の場合はカウントしない
			$this->gAnalyze->updateContentViewCount(self::CONTENT_TYPE, $fetchedRow['cn_serial'], $this->currentDay, $this->currentHour);
		}

		// タイトルを設定
		$title = $fetchedRow['cn_name'];
		if (empty($this->headTitle)) $this->headTitle = $title;
		
		// HTMLを出力
		// 出力内容は特にエラーチェックしない
		//$contentText = $this->convertToDispString($fetchedRow['cn_html']);
		$rootUrl = $this->getUrl($this->gEnv->getRootUrl());
		$contentText = $fetchedRow['cn_html'];
		$contentText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $rootUrl, $contentText);// アプリケーションルートを変換
		
		// 登録したキーワードを変換
		$this->gTextConv->convByKeyValue($contentText, $contentText, true/*改行コーをbrタグに変換*/);
		
		$headClassStr = $this->gDesign->getDefaultContentHeadClassString();			// コンテンツヘッダ用CSSクラス

		$row = array(
			'class' => $headClassStr,		// コンテンツヘッダ用CSSクラス
			'title' => $title,
			'content' => $contentText	// コンテンツ
		);
		$this->tmpl->addVars('contentlist', $row);
		$this->tmpl->parseTemplate('contentlist', 'a');
		
		// コンテンツが取得できた
		$this->_contentCreated = true;
		return true;
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function searchItemsLoop($index, $fetchedRow)
	{
		// タイトルを設定
		$title = $fetchedRow['cn_name'];

		// 記事へのリンクを生成
		$linkUrl = $this->getUrl($this->currentPageUrl . '&contentid=' . $fetchedRow['cn_id']);
		$link = '<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >' . $title . '</a>';

		// テキストに変換
		//$contentText = strip_tags($fetchedRow['cn_html']);
		$contentText = $this->gTextConv->htmlToText($fetchedRow['cn_html']);
		
		// アプリケーションルートを変換
		$rootUrl = $this->getUrl($this->gEnv->getRootUrl());
		$contentText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $rootUrl, $contentText);
		
		// 登録したキーワードを変換
		$this->gTextConv->convByKeyValue($contentText, $contentText);
		
		// 検索結果用にテキストを詰める。改行、タブ、スペース削除。
		$contentText = str_replace(array("\r", "\n", "\t", " "), '', $contentText);
		
		// 文字列長を修正
		if (function_exists('mb_strimwidth')){
			$contentText = mb_strimwidth($contentText, 0, self::CONTENT_SIZE, '…');
		} else {
			$contentText = substr($contentText, 0, self::CONTENT_SIZE) . '...';
		}

		$headClassStr = $this->gDesign->getDefaultContentHeadClassString();			// コンテンツヘッダ用CSSクラス
		
		$row = array(
			'class' => $headClassStr,		// コンテンツヘッダ用CSSクラス
			'title' => $link,			// リンク付きタイトル
			'content' => $this->convertToDispString($contentText)	// コンテンツ
		);
		$this->tmpl->addVars('contentlist', $row);
		$this->tmpl->parseTemplate('contentlist', 'a');
		$this->isExistsViewData = true;				// 表示データがあるかどうか
		return true;
	}
}
?>
