<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: _installInitotherWidgetContainer.php 2355 2009-09-25 05:34:08Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/_installDb.php');

class _installInitotherWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	const SAMPLE_DIR = 'sample';				// サンプルSQLディレクトリ名
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new _installDB();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'initother.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		global $gPageManager;
		global $gEnvManager;
		
		$filename = '';		// 実行スクリプトファイル
		$act = $request->trimValueOf('act');
		$type = $request->trimValueOf('install_type');
		$from = $request->trimValueOf('from');
		$dbStatus = $request->trimValueOf('dbstatus');		// DBの状態
		if (empty($dbStatus)){
			if ($from == 'updatedb'){
				$dbStatus = 'update';
			} else {
				$dbStatus = 'init';
			}
		}
			
		if ($act == 'installsampledata'){		// サンプルデータインストールのとき
			$filename = $request->trimValueOf('sample_sql');
			$scriptPath = $gEnvManager->getSqlPath() . '/' . self::SAMPLE_DIR . '/' . $filename;
			
			// スクリプト実行
			if ($this->gInstance->getDbManager()->execScriptWithConvert($scriptPath, $errors)){// 正常終了の場合
				$this->setMsg(self::MSG_GUIDANCE, 'データインストール完了しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, "データインストールに失敗しました");
			}
			if (!empty($errors)){
				foreach ($errors as $error) {
					$this->setMsg(self::MSG_APP_ERR, $error);
				}
			}
			// 現在の設定しているテンプレートを解除
			$request->unsetSessionValue(M3_SESSION_CURRENT_TEMPLATE);
		} else if ($act == 'selectfile'){		// スクリプトファイルを選択
			$filename = $request->trimValueOf('sample_sql');
		} else {
			$this->tmpl->setAttribute('install_msg', 'visibility', 'visible');// テーブル構築完了のメッセージ
		}
		// サンプルSQLスクリプトディレクトリのチェック
		$searchPath = $gEnvManager->getSqlPath() . '/' . self::SAMPLE_DIR;
		if (is_dir($searchPath)){
			$dir = dir($searchPath);
			while (($file = $dir->read()) !== false){
				$filePath = $searchPath . '/' . $file;
				// ファイルかどうかチェック
				if (strncmp($file, '.', 1) != 0 && $file != '..' && is_file($filePath)
					&& strncmp($file, '_', 1) != 0){	// 「_」で始まる名前のファイルは読み込まない
					
					// デフォルトのファイル名を決定
					if (empty($filename)) $filename = $file;
					
					$selected = '';
					if ($file == $filename){
						$selected = 'selected';
					}
					$row = array(
						'value'    => $file,			// ファイル名
						'name'     => $file,			// ファイル名
						'selected' => $selected														// 選択中かどうか
					);
					$this->tmpl->addVars('sample__sql_list', $row);
					$this->tmpl->parseTemplate('sample__sql_list', 'a');
				}
			}
			$dir->close();
		}
		// 実行スクリプトファイルのヘッダを取得
		if (!empty($filename)){
			$filePath = $searchPath . '/' . $filename;
			
			// ファイルの読み込み
			$fileHead = '';
			$fp = fopen($filePath, 'r');
			while (!feof($fp)){
			    $line = fgets($fp, 1024);
				$line = trim($line);
				
				// 空行が来たら終了
				if (empty($line)){
					break;
				} else if (strncmp($line, '--', strlen('--')) != 0){		// コメント以外の場合も終了
					break;
				}
				if (strncmp($line, '-- *', strlen('-- *')) != 0){		// ヘッダ部読み飛ばし
					// コメント記号を削除
					$line = trim(substr($line, strlen('--')));
					$fileHead .= $line . '<br>' . M3_NL;
				}
			}
			fclose($fp);
			
			// スクリプトヘッダ表示
			$this->tmpl->addVar("datainstall_msg", "header", $fileHead);
		}
		// 画面のヘッダ、タイトルを設定
		if ($dbStatus == 'update'){
			$this->tmpl->addVar("_widget", "title", 'ＤＢバージョンアップ完了');
			$this->tmpl->addVar("install_msg", "message", 'ＤＢバージョンアップが完了しました');
		} else {
			$this->tmpl->addVar("_widget", "title", 'ＤＢ構築完了');
			$this->tmpl->addVar("install_msg", "message", 'ＤＢの構築が完了しました');
			
			$this->tmpl->setAttribute('datainstall_msg', 'visibility', 'visible');// サンプルデータインストール用領域表示
		}
		$this->tmpl->addVar("_widget", "db_status", $dbStatus);
	}
}
?>
