<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainLoginstatusWidgetContainer.php 2235 2009-08-19 02:00:26Z fishbone $
 * @link       http://www.magic3.org
 */
//require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/admin_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');
require_once($gEnvManager->getIncludePath() . '/common/userInfo.php');		// ユーザ情報クラス

class admin_mainLoginstatusWidgetContainer extends admin_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	const DEFAULT_LIST_COUNT = 30;			// 最大リスト表示数
//	const THIS_WIDGET_ID = '';			// ウィジェットID
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
		$this->sysDb = $this->gInstance->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'loginstatus.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$act = $request->trimValueOf('act');
		
		$maxListCount = self::DEFAULT_LIST_COUNT;				// 表示項目数
		/*
		$serializedParam = $this->sysDb->getWidgetParam(self::THIS_WIDGET_ID);
		if (!empty($serializedParam)){
			$dispInfo = unserialize($serializedParam);
			$maxListCount = $dispInfo->listCountByAdmin;		// 一覧表示数
		}*/
		$pageNo = $request->trimValueOf('page');				// ページ番号
		if (empty($pageNo)) $pageNo = 1;
		
		// 総数を取得
		$totalCount = $this->db->getUserLoginStatusListCount();

		// 表示するページ番号の修正
		$pageCount = (int)(($totalCount -1) / $maxListCount) + 1;		// 総ページ数
		if ($pageNo < 1) $pageNo = 1;
		if ($pageNo > $pageCount) $pageNo = $pageCount;
		$this->firstNo = ($pageNo -1) * $maxListCount + 1;		// 先頭番号
		
		// ページング用リンク作成
		$pageLink = '';
		if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
			for ($i = 1; $i <= $pageCount; $i++){
				if ($i == $pageNo){
					$link = '&nbsp;' . $i;
				} else {
					$link = '&nbsp;<a href="#" onclick="selpage(\'' . $i . '\');return false;">' . $i . '</a>';
				}
				$pageLink .= $link;
			}
		}
		$this->tmpl->addVar("_widget", "page_link", $pageLink);
		$this->tmpl->addVar("_widget", "total_count", $totalCount);
		$this->tmpl->addVar("_widget", "page", $pageNo);	// ページ番号
		
		// ログイン状況を取得
		$this->db->getUserLoginStatusList($maxListCount, $pageNo, array($this, 'userListLoop'));
	}
	/**
	 * ユーザリスト、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function userListLoop($index, $fetchedRow, $param)
	{
		// 行カラーの設定
/*		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}*/
		// ユーザ種別
		switch ($fetchedRow['lu_user_type']){
			case UserInfo::USER_TYPE_TMP:
				$userType = '<font color="orange">仮登録</font>';
				break;
			case UserInfo::USER_TYPE_NORMAL:
				$userType = '<font color="green">通常ユーザ</font>';
				break;
			case UserInfo::USER_TYPE_SYS_ADMIN:
				$userType = '<font color="red">管理者</font>';
				break;
			default:
				$userType = '該当なし';
				break;
		}
		// ログイン回数
		$count = $fetchedRow['ll_login_count'];
		if (empty($count)) $count = '0';
		$row = array(
//			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['lu_serial']),			// シリアル番号
			'id' => $this->convertToDispString($fetchedRow['lu_id']),			// ID
			'name' => $this->convertToDispString($fetchedRow['lu_name']),		// 名前
			'account' => $this->convertToDispString($fetchedRow['lu_account']),		// アカウント
			'user_type' => $userType,		// ユーザ種別
			'count' => $count,		// ログイン回数
			'login_dt' => $this->convertToDispDateTime($fetchedRow['ll_last_login_dt']),	// 最終ログイン日時
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('userlist', $row);
		$this->tmpl->parseTemplate('userlist', 'a');
		return true;
	}
}
?>
