<?php
/**
 * DBクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    ポータル用コンテンツ更新情報
 * @author     株式会社 毎日メディアサービス
 * @copyright  Copyright 2009 株式会社 毎日メディアサービス.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: portal_updateinfoDb.php 2695 2009-12-15 11:04:28Z fishbone $
 * @link       http://www.m-media.co.jp
 */
require_once($gEnvManager->getDbPath() . '/baseDb.php');

class portal_updateinfoDb extends BaseDb
{
	/**
	 * 最近の登録順にコンテンツ更新情報リストを取得
	 *
	 * @param string   $typeId		コンテンツタイプ
	 * @param function $callback	コールバック関数
	 * @return						なし
	 */
	function getUpdateInfoList($typeId, $limit, $callback)
	{
		$params = array();
		$queryStr  = 'SELECT * FROM news ';
		$queryStr .=   'WHERE nw_deleted = false ';
		$queryStr .=   'ORDER BY nw_regist_dt DESC ';
		$queryStr .=    'LIMIT ' . $limit;
		$this->selectLoop($queryStr, $params, $callback);
	}
}
?>
