<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    ユーザ作成コンテンツ
 * @author     株式会社 毎日メディアサービス
 * @copyright  Copyright 2010 株式会社 毎日メディアサービス.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: user_contentBaseWidgetContainer.php 2940 2010-03-17 14:26:14Z fishbone $
 * @link       http://www.m-media.co.jp
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/user_contentDb.php');

class user_contentBaseWidgetContainer extends BaseWidgetContainer
{
	protected $_db;			// DB接続オブジェクト
	private $_headCss;		// ヘッダに設定するCSS
	
	// 画面
	const TASK_TOP = 'top';			// トップ画面
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->_db = new user_contentDb();
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _postAssign($request, &$param)
	{
		// タブ用CSSを取得
		$paramObj = $this->getWidgetParamObj();
		if (!empty($paramObj)){
			$this->_headCss = $paramObj->css;					// タブ用CSS
		}
			
		/*$cssId = $this->gEnv->getCurrentWidgetId() . '_0';
		$this->_headCss .= '#' . $cssId . ' a {text-decoration:underline;}' . M3_NL;
		$this->_headCss .= '#' . $cssId . ' a:link {color:' . $this->_configArray[self::CF_LINK_COLOR] . ';}' . M3_NL;
		$this->_headCss .= '#' . $cssId . ' a:active {color:' . $this->_configArray[self::CF_ALINK_COLOR] . ';}' . M3_NL;
		//$this->_headCss .= '#' . $cssId . ' a:hover {color:' . $this->_configArray[self::CF_VLINK_COLOR] . ';}' . M3_NL;
		$this->_headCss .= '#' . $cssId . ' a:visited {color:' . $this->_configArray[self::CF_VLINK_COLOR] . ';}' . M3_NL;
		$this->tmpl->addVar("_widget", "css_id",	$cssId);	// CSS用ID
		*/
		
		// 遷移先を設定
		//$this->tmpl->addVar("_widget", "bbs_url", $this->convertUrlToHtmlEntity($this->getUrl($this->gEnv->createCurrentPageUrl(), true)));
		//$this->tmpl->addVar("_widget", "subject_url",	$this->convertUrlToHtmlEntity($this->getUrl($this->gEnv->createCurrentPageUrl() . '&task=' . self::TASK_SUBJECT, true)));	// スレッド件名
		//$this->tmpl->addVar("_widget", "newthread_url",	$this->convertUrlToHtmlEntity($this->getUrl($this->gEnv->createCurrentPageUrl() . '&task=' . self::TASK_NEW_THREAD, true)));	// 新規スレッド作成
	}
	/**
	 * CSSデータをHTMLヘッダ部に設定
	 *
	 * CSSデータをHTMLのheadタグ内に追加出力する。
	 * _assign()よりも後に実行される。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。
	 * @return string 						CSS文字列。出力しない場合は空文字列を設定。
	 */
	function _addCssToHead($request, &$param)
	{
		return $this->_headCss;
	}
	/**
	 * BBS定義値をDBから取得
	 *
	 * @return bool			true=取得成功、false=取得失敗
	 */
	function _loadConfig()
	{
		$this->_configArray = array();

		// BBS定義を読み込み
		$ret = $this->_db->getAllConfig($rows);
		if ($ret){
			// 取得データを連想配列にする
			$configCount = count($rows);
			for ($i = 0; $i < $configCount; $i++){
				$key = $rows[$i]['tg_id'];
				$value = $rows[$i]['tg_value'];
				$this->_configArray[$key] = $value;
			}
		}
		return $ret;
	}
}
?>
