<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    ユーザ作成コンテンツ
 * @author     株式会社 毎日メディアサービス
 * @copyright  Copyright 2010 株式会社 毎日メディアサービス.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: user_contentTopWidgetContainer.php 2949 2010-03-19 04:49:22Z fishbone $
 * @link       http://www.m-media.co.jp
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/user_contentBaseWidgetContainer.php');

class user_contentTopWidgetContainer extends user_contentBaseWidgetContainer
{
	private $langId;		// 言語ID
	private $isTabCreated;	// タブが作成されたかどうか
	
	/*
	private $threadCount;	// スレッド表示数
	private $threadIdArray = array();	// 表示するスレッドID
	private $threadInfoArray = array();	// 表示中のスレッドの情報
	private $headTitle;		// METAタグタイトル
	private $headDesc;		// METAタグ要約
	private $headKeyword;	// METAタグキーワード
	private $headCss;			// ヘッダ追加CSS
	private $threadStyle;	// スレッド部表示スタイル
	private $subjectColor;	// 件名文字色
	private $nameColor;		// 登録者名文字色
	private $createEmailLink;	// Eメールのリンクを作成するかどうか
	private $isExistsMessage;	// メッセージが存在するかどうか
	const DEFAULT_MENU_NAME = 'menu';		// スレッドメニューの名前
	*/
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$act = $request->trimValueOf('act');
		return 'main.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$this->langId = $this->gEnv->getDefaultLanguage();		// デフォルト言語
		$act = $request->trimValueOf('act');
		
/*		$threadId = $request->trimValueOf(M3_REQUEST_PARAM_BBS_THREAD_ID);	// スレッドID
		$message = $request->valueOf('bbs_message');// 投稿メッセージ
		$name = $request->trimValueOf('bbs_name');// 名前
		$email = $request->trimValueOf('bbs_email');// Eメールアドレス*/
		
		// タブの作成
		$this->_db->getAllVisibleTabs($this->langId, array($this, 'itemsLoop'));
		if (!$this->isTabCreated) $this->cancelParse();
	}
	/**
	 * タブ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function itemsLoop($index, $fetchedRow)
	{
		$row = array(
			'name' => $this->convertToDispString($fetchedRow['ub_name']),		// タブタイトル
			'href' => '#' . $fetchedRow['ub_id']		// タブ参照先
		);
		$this->tmpl->addVars('tablist', $row);
		$this->tmpl->parseTemplate('tablist', 'a');
		
		// タブ内容を作成
		$content = $fetchedRow['ub_template_html'];
		$row = array(
			'panel_id' => $fetchedRow['ub_id'],		// タブID
			'content' => $content		// タブ内容
		);
		$this->tmpl->addVars('panellist', $row);
		$this->tmpl->parseTemplate('panellist', 'a');
		
		// タブ情報が取得できた
		$this->isTabCreated = true;
		return true;
	}
}
?>
