<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    カスタム検索
 * @author     株式会社 毎日メディアサービス
 * @copyright  Copyright 2010 株式会社 毎日メディアサービス.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_custom_searchWidgetContainer.php 3043 2010-04-18 05:58:27Z fishbone $
 * @link       http://www.m-media.co.jp
 */
require_once($gEnvManager->getContainerPath() . '/baseAdminWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/custom_searchDb.php');

class admin_custom_searchWidgetContainer extends BaseAdminWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;	// DB接続オブジェクト
	private $serialNo;		// 選択中の項目のシリアル番号
	private $serialArray = array();			// 表示中のシリアル番号
	private $langId;
	private $configId;		// 定義ID
	private $paramObj;		// パラメータ保存用オブジェクト
	private $searchTextId;		// 検索用テキストフィールドのタグID
	private $searchButtonId;		// 検索用ボタンのタグID
	private $searchResetId;		// 検索エリアリセットボタンのタグID
	private $fieldInfoArray = array();			// 項目定義
	private $categoryArray;		// カテゴリ種別メニュー
	private $selTypeArray;	// 項目選択タイプメニュー
	const DEFAULT_NAME_HEAD = '名称未設定';			// デフォルトの設定名
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new custom_searchDb();
		$this->sysDb = $this->gInstance->getSytemDbObject();
		
		// 項目選択タイプ
		$this->selTypeArray = array(	array(	'name' => '単一選択',	'value' => 'single'),
										array(	'name' => '複数選択',	'value' => 'multi'));
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'list'){		// 一覧画面
			return 'admin_list.tmpl.html';
		} else {			// 一覧画面
			return 'admin.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'list'){		// 一覧画面
			return $this->createList($request);
		} else {			// 詳細設定画面
			return $this->createDetail($request);
		}
	}
	/**
	 * 詳細画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		// ページ定義IDとページ定義のレコードシリアル番号を取得
		$this->startPageDefParam($defSerial, $defConfigId, $this->paramObj);
		
		$userId		= $this->gEnv->getCurrentUserId();
		$this->langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号

		// 入力値を取得
		$name	= $request->trimValueOf('item_name');			// ヘッダタイトル
		$searchTemplate = $request->valueOf('item_html');		// 検索用テンプレート
		$this->searchTextId = $request->trimValueOf('item_search_text');		// 検索用テキストフィールドのタグID
		$this->searchButtonId = $request->trimValueOf('item_search_button');		// 検索用ボタンのタグID
		$this->searchResetId = $request->trimValueOf('item_search_reset');		// 検索エリアリセットボタンのタグID
		$this->configId = $request->trimValueOf('item_id');		// 定義ID
		if (empty($this->configId)) $this->configId = $defConfigId;		// 呼び出しウィンドウから引き継いだ定義ID

		$fieldCount = intval($request->trimValueOf('fieldcount'));		// カテゴリ定義項目数
		$categoryTypes = $request->trimValueOf('item_type');					// カテゴリ種別
		$selectTypes = $request->trimValueOf('item_sel_type');			// カテゴリ選択方法
		
		// カテゴリ設定を取得
		$this->fieldInfoArray = array();
		for ($i = 0; $i < $fieldCount; $i++){
			$newInfoObj = new stdClass;
			$newInfoObj->categoryType = $categoryTypes[$i];
			$newInfoObj->selectType = $selectTypes[$i];
			$this->fieldInfoArray[] = $newInfoObj;
		}
		
		// Pタグを除去
		$searchTemplate = $this->gInstance->getTextConvManager()->deleteTag($searchTemplate, 'p');

		$replaceNew = false;		// データを再取得するかどうか
		if (empty($act)){// 初期起動時
			// デフォルト値設定
			$this->configId = $defConfigId;		// 呼び出しウィンドウから引き継いだ定義ID
			$replaceNew = true;			// データ再取得
		} else if ($act == 'add'){// 新規追加
			// 入力チェック
			$this->checkInput($name, '名前');
			
			// 設定名の重複チェック
			for ($i = 0; $i < count($this->paramObj); $i++){
				$targetObj = $this->paramObj[$i]->object;
				if ($name == $targetObj->name){		// 定義名
					$this->setUserErrorMsg('名前が重複しています');
					break;
				}
			}
			
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				// 追加オブジェクト作成
				$newObj = new stdClass;
				$newObj->name	= $name;// 表示名
				$newObj->searchTemplate = $searchTemplate;		// 検索用テンプレート
				$newObj->searchTextId = $this->searchTextId;		// 検索用テキストフィールドのタグID
				$newObj->searchButtonId = $this->searchButtonId;		// 検索用ボタンのタグID
				$newObj->searchResetId = $this->searchResetId;		// 検索エリアリセットボタンのタグID
				$newObj->fieldInfo = $this->fieldInfoArray;			// カテゴリ定義
				
				$ret = $this->addPageDefParam($defSerial, $defConfigId, $this->paramObj, $newObj);
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					
					$this->configId = $defConfigId;		// 定義定義IDを更新
					$replaceNew = true;			// データ再取得
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
			}
		} else if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			
			if ($this->getMsgCount() == 0){			// エラーのないとき
				// 現在の設定値を取得
				$ret = $this->getPageDefParam($defSerial, $defConfigId, $this->paramObj, $this->configId, $targetObj);
				if ($ret){
					// ウィジェットオブジェクト更新
					$targetObj->searchTemplate	= $searchTemplate;		// 検索用テンプレート
					$targetObj->searchTextId = $this->searchTextId;		// 検索用テキストフィールドのタグID
					$targetObj->searchButtonId = $this->searchButtonId;		// 検索用ボタンのタグID
					$targetObj->searchResetId = $this->searchResetId;		// 検索エリアリセットボタンのタグID
					$targetObj->fieldInfo = $this->fieldInfoArray;			// カテゴリ定義
				}
				
				// 設定値を更新
				if ($ret) $ret = $this->updatePageDefParam($defSerial, $defConfigId, $this->paramObj, $this->configId, $targetObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					
					$replaceNew = true;			// データ再取得
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
		} else if ($act == 'select'){	// 定義IDを変更
			$replaceNew = true;			// データ再取得
		}
		
		// 設定項目選択メニュー作成
		$this->createItemMenu();
		
		// 表示用データを取得
		if (empty($this->configId)){		// 新規登録の場合
			$this->tmpl->setAttribute('item_name_visible', 'visibility', 'visible');// 名前入力フィールド表示
			if ($replaceNew){		// データ再取得時
				$name = $this->createDefaultName();			// デフォルト登録項目名
				$this->fieldInfoArray = array();			// 項目定義
				
				// デフォルトの検索テンプレート作成
				$tagHead = $this->createTagIdHead();
				$this->searchTextId = $tagHead . '_text';		// 検索用テキストフィールドのタグID
				$this->searchButtonId = $tagHead . '_button';		// 検索用ボタンのタグID
				$this->searchResetId = $tagHead . '_reset';		// 検索エリアリセットボタンのタグID
				$searchTemplate = $this->getParsedTemplateData('default.tmpl.html', array($this, 'makeSearcheTemplate'));// デフォルト用の検索テンプレート
			} else {// 画面から入力されたデータを取得
				/*$this->fieldInfoArray = array();
				for ($i = 0; $i < $fieldCount; $i++){
					$newInfoObj = new stdClass;
					$newInfoObj->title	= $titles[$i];
					$newInfoObj->desc	= $descs[$i];
					$newInfoObj->type	= $types[$i];
					$newInfoObj->def	= $defs[$i];
					$newInfoObj->required	= $requireds[$i];
					$newInfoObj->titleVisible	= $titleVisibles[$i];
					$this->fieldInfoArray[] = $newInfoObj;
				}*/
			}
			$this->serialNo = 0;
		} else {		// 更新の場合
			if ($replaceNew){
				$ret = $this->getPageDefParam($defSerial, $defConfigId, $this->paramObj, $this->configId, $targetObj);
				if ($ret){
					$name = $targetObj->name;// 名前
					$this->searchTextId = $targetObj->searchTextId;		// 検索用テキストフィールドのタグID
					$this->searchButtonId = $targetObj->searchButtonId;		// 検索用ボタンのタグID
					$this->searchResetId = $targetObj->searchResetId;		// 検索エリアリセットボタンのタグID
					$searchTemplate = $targetObj->searchTemplate;		// 検索用テンプレート
					if (!empty($targetObj->fieldInfo)) $this->fieldInfoArray = $targetObj->fieldInfo;			// 項目定義
				}
			} else {		// 画面から入力されたデータを取得
				/*$this->fieldInfoArray = array();
				for ($i = 0; $i < $fieldCount; $i++){
					$newInfoObj = new stdClass;
					$newInfoObj->title	= $titles[$i];
					$newInfoObj->desc	= $descs[$i];
					$newInfoObj->type	= $types[$i];
					$newInfoObj->def	= $defs[$i];
					$newInfoObj->required	= $requireds[$i];
					$newInfoObj->titleVisible	= $titleVisibles[$i];
					$this->fieldInfoArray[] = $newInfoObj;
				}*/
			}
			$this->serialNo = $this->configId;
				
			// 新規作成でないときは、メニューを変更不可にする(画面作成から呼ばれている場合のみ)
			if (!empty($defConfigId) && !empty($defSerial)) $this->tmpl->addVar("_widget", "id_disabled", 'disabled');
		}
		// カテゴリ情報取得
		$this->categoryArray = array();		// カテゴリ種別メニュー
		$ret = $this->db->getAllCategory($this->langId, $rows);
		if ($ret){
			for ($i = 0; $i < count($rows); $i++){
				$line = array();
				$line['name'] = $rows[$i]['ua_name'];
				$line['value'] = $rows[$i]['ua_id'];
				$this->categoryArray[] = $line;
			}
		}
		
		// メニュー作成
		$this->createCategoryMenu();
		$this->createSelTypeMenu();
		
		// 項目定義一覧を作成
		$this->createFieldList();
		if (empty($this->fieldInfoArray)) $this->tmpl->setAttribute('field_list', 'visibility', 'hidden');// 項目定義一覧を隠す
		
		// 画面にデータを埋め込む
		$this->tmpl->addVar("item_name_visible", "name", $name);		// 名前
		$this->tmpl->addVar("_widget", "html",	$searchTemplate);
		$this->tmpl->addVar("_widget", "search_text",	$this->searchTextId);		// 検索用テキストフィールドのタグID
		$this->tmpl->addVar("_widget", "search_button",	$this->searchButtonId);		// 検索用ボタンのタグID
		$this->tmpl->addVar("_widget", "search_reset",	$this->searchResetId);		// 検索エリアリセットボタンのタグID
		$tagStr = $this->searchTextId . '(入力フィールドのID), ' . $this->searchButtonId . '(検索実行ボタンのID), ' . $this->searchResetId . '(検索リセットボタンのID)';
		$this->tmpl->addVar("_widget", "tag_id_str", $tagStr);// タグIDの表示
		$this->tmpl->addVar('_widget', 'tag_start', M3_TAG_START . M3_TAG_MACRO_ITEM_KEY);		// 置換タグ(前)
		$this->tmpl->addVar('_widget', 'tag_end', M3_TAG_END);		// 置換タグ(後)
		
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);// 選択中のシリアル番号、IDを設定
		
		// ボタンの表示制御
		if (empty($this->serialNo)){		// 新規追加項目を選択しているとき
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
		} else {
			$this->tmpl->setAttribute('update_button', 'visibility', 'visible');// 「更新」ボタン
		}
		// ページ定義IDとページ定義のレコードシリアル番号を更新
		$this->endPageDefParam($defSerial, $defConfigId, $this->paramObj);
	}
	/**
	 * 選択用メニューを作成
	 *
	 * @return なし						
	 */
	function createItemMenu()
	{
		for ($i = 0; $i < count($this->paramObj); $i++){
			$id = $this->paramObj[$i]->id;// 定義ID
			$targetObj = $this->paramObj[$i]->object;
			$name = $targetObj->name;// 定義名
			$selected = '';

			if ($this->configId == $id) $selected = 'selected';
			$row = array(
				'name' => $name,		// 名前
				'value' => $id,		// 定義ID
				'selected' => $selected	// 選択中の項目かどうか
			);
			$this->tmpl->addVars('title_list', $row);
			$this->tmpl->parseTemplate('title_list', 'a');
		}
	}
	/**
	 * デフォルトの名前を取得
	 *
	 * @return string	デフォルト名						
	 */
	function createDefaultName()
	{
		$name = self::DEFAULT_NAME_HEAD;
		for ($j = 1; $j < 100; $j++){
			$name = self::DEFAULT_NAME_HEAD . $j;
			// 設定名の重複チェック
			for ($i = 0; $i < count($this->paramObj); $i++){
				$targetObj = $this->paramObj[$i]->object;
				if ($name == $targetObj->name){		// 定義名
					break;
				}
			}
			// 重複なしのときは終了
			if ($i == count($this->paramObj)) break;
		}
		return $name;
	}
	/**
	 * 一覧画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createList($request)
	{
		// ページ定義IDとページ定義のレコードシリアル番号を取得
		$this->startPageDefParam($defSerial, $defConfigId, $this->paramObj);
		
		$userId		= $this->gEnv->getCurrentUserId();
		$langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		$act = $request->trimValueOf('act');
		
		if ($act == 'delete'){		// メニュー項目の削除
			$listedItem = explode(',', $request->trimValueOf('seriallist'));
			$delItems = array();
			for ($i = 0; $i < count($listedItem); $i++){
				// 項目がチェックされているかを取得
				$itemName = 'item' . $i . '_selected';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
				if ($itemValue){		// チェック項目
					$delItems[] = $listedItem[$i];
				}
			}
			if (count($delItems) > 0){
				$ret = $this->delPageDefParam($defSerial, $defConfigId, $this->paramObj, $delItems);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		}
		// 定義一覧作成
		$this->createItemList();
		
		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
		
		// ページ定義IDとページ定義のレコードシリアル番号を更新
		$this->endPageDefParam($defSerial, $defConfigId, $this->paramObj);
	}
	/**
	 * 定義一覧作成
	 *
	 * @return なし						
	 */
	function createItemList()
	{
		for ($i = 0; $i < count($this->paramObj); $i++){
			$id = $this->paramObj[$i]->id;// 定義ID
			$targetObj = $this->paramObj[$i]->object;
			$name = $targetObj->name;// 定義名
			
			$defCount = 0;
			if (!empty($id)){
				$defCount = $this->sysDb->getPageDefCount($this->gEnv->getCurrentWidgetId(), $id);
			}
			$operationDisagled = '';
			if ($defCount > 0) $operationDisagled = 'disabled';
			$row = array(
				'index' => $i,
				'ope_disabled' => $operationDisagled,			// 選択可能かどうか
				'name' => $this->convertToDispString($name),		// 名前
				'def_count' => $defCount							// 使用数
			);
			$this->tmpl->addVars('itemlist', $row);
			$this->tmpl->parseTemplate('itemlist', 'a');
			
			// シリアル番号を保存
			$this->serialArray[] = $id;
		}
	}
	/**
	 * 検索テンプレートデータ作成処理コールバック
	 *
	 * @param object         $tmpl			テンプレートオブジェクト
	 * @param								なし
	 */
	function makeSearcheTemplate($tmpl)
	{
		$tmpl->addVar("_tmpl", "widget_url",	$this->gEnv->getCurrentWidgetRootUrl());		// ウィジェットのURL
		$tmpl->addVar("_tmpl", "search_text_id",	$this->searchTextId);		// 検索用テキストフィールドのタグID
		$tmpl->addVar("_tmpl", "search_button_id",	$this->searchButtonId);		// 検索用ボタンのタグID
		$tmpl->addVar("_tmpl", "search_reset_id",	$this->searchResetId);		// 検索エリアリセットボタンのタグID
	}
	/**
	 * inputタグID用のヘッダ文字列を作成
	 *
	 * @return string	ID						
	 */
	function createTagIdHead()
	{
		return $this->gEnv->getCurrentWidgetId() . '_' . $this->getTempConfigId($this->paramObj);
	}
	/**
	 * 項目定義一覧を作成
	 *
	 * @return なし						
	 */
	function createFieldList()
	{
		$fieldCount = count($this->fieldInfoArray);
		for ($i = 0; $i < $fieldCount; $i++){
			$infoObj = $this->fieldInfoArray[$i];
			$categoryType = $infoObj->categoryType;// カテゴリ種別
			$selectType = $infoObj->selectType;		// 選択方法
			
			// カテゴリ種別メニュー作成
			$this->tmpl->clearTemplate('type_list2');
			
			for ($j = 0; $j < count($this->categoryArray); $j++){
				$value = $this->categoryArray[$j]['value'];
				$name = $this->categoryArray[$j]['name'];

				$selected = '';
				if ($value == $categoryType) $selected = 'selected';

				$tableLine = array(
					'value'    => $value,			// タイプ値
					'name'     => $this->convertToDispString($name),			// タイプ名
					'selected' => $selected			// 選択中かどうか
				);
				$this->tmpl->addVars('type_list2', $tableLine);
				$this->tmpl->parseTemplate('type_list2', 'a');
			}
			
			// 選択方法メニュー作成
			$this->tmpl->clearTemplate('sel_type_list2');
			
			for ($j = 0; $j < count($this->selTypeArray); $j++){
				$value = $this->selTypeArray[$j]['value'];
				$name = $this->selTypeArray[$j]['name'];

				$selected = '';
				if ($value == $selectType) $selected = 'selected';

				$tableLine = array(
					'value'    => $value,			// タイプ値
					'name'     => $this->convertToDispString($name),			// タイプ名
					'selected' => $selected			// 選択中かどうか
				);
				$this->tmpl->addVars('sel_type_list2', $tableLine);
				$this->tmpl->parseTemplate('sel_type_list2', 'a');
			}
			
			$row = array(
				'root_url' => $this->convertToDispString($this->getUrl($this->gEnv->getRootUrl()))
			);
			$this->tmpl->addVars('field_list', $row);
			$this->tmpl->parseTemplate('field_list', 'a');
		}
	}
	/**
	 * カテゴリメニュー作成
	 *
	 * @return なし
	 */
	function createCategoryMenu()
	{
		for ($i = 0; $i < count($this->categoryArray); $i++){
			$value = $this->categoryArray[$i]['value'];
			$name = $this->categoryArray[$i]['name'];
			
			$row = array(
				'value'    => $value,			// タイプ値
				'name'     => $this->convertToDispString($name),			// タイプ名
				'selected' => $selected			// 選択中かどうか
			);
			$this->tmpl->addVars('type_list', $row);
			$this->tmpl->parseTemplate('type_list', 'a');
		}
	}
	/**
	 * 項目選択タイプメニュー作成
	 *
	 * @return なし
	 */
	function createSelTypeMenu()
	{
		for ($i = 0; $i < count($this->selTypeArray); $i++){
			$value = $this->selTypeArray[$i]['value'];
			$name = $this->selTypeArray[$i]['name'];
			
			$row = array(
				'value'    => $value,			// タイプ値
				'name'     => $this->convertToDispString($name),			// タイプ名
				'selected' => $selected			// 選択中かどうか
			);
			$this->tmpl->addVars('sel_type_list', $row);
			$this->tmpl->parseTemplate('sel_type_list', 'a');
		}
	}
}
?>
