<?php
/**
 * Javascriptライブラリ情報クラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: scriptLibInfo.php 3340 2010-07-05 06:46:22Z fishbone $
 * @link       http://www.magic3.org
 */
class ScriptLibInfo
{
	// Javascriptライブラリ(DBでの設定値)
	// ベースライブラリ
	const LIB_JQUERY_UI				= 'jquery-ui';
	const LIB_JQUERY_UI_PLUS		= 'jquery-ui-plus';
	const LIB_FCKEDITOR				= 'fckeditor';
	const LIB_MD5					= 'md5';
	// jQuery
	const LIB_JQUERY_EASING			= 'jquery.easing';
	const LIB_JQUERY_JCAROUSEL		= 'jquery.jcarousel';
	const LIB_JQUERY_THICKBOX		= 'jquery.thickbox';
	const LIB_JQUERY_JSHOTKEYS		= 'jquery.jshotkeys';
	const LIB_JQUERY_CYCLE			= 'jquery.cycle';
	const LIB_JQUERY_CODEPRESS		= 'jquery.codepress';
	const LIB_JQUERY_CLUETIP		= 'jquery.cluetip';
	const LIB_JQUERY_SIMPLETREE		= 'jquery.simpletree';
	const LIB_JQUERY_BGIFRAME		= 'jquery.bgiframe';
	const LIB_JQUERY_HOVERINTENT	= 'jquery.hoverintent';
	const LIB_JQUERY_TABLEDND		= 'jquery.tablednd';
	const LIB_JQUERY_SIMPLEMODAL	= 'jquery.simplemodal';
	const LIB_JQUERY_COOKIE			= 'jquery.cookie';
	const LIB_JQUERY_FORMAT			= 'jquery.format';
	const LIB_JQUERY_FORMTIPS		= 'jquery.formtips';
	// jQuery UI
	const LIB_JQUERY_UI_WIDGETS_ACCORDION		= 'jquery-ui.accordion';		// Widgets Accordion
	const LIB_JQUERY_UI_WIDGETS_AUTOCOMPLETE	= 'jquery-ui.autocomplete';		// Widgets Autocomplete
	const LIB_JQUERY_UI_WIDGETS_BUTTON			= 'jquery-ui.button';			// Widgets Button
	const LIB_JQUERY_UI_WIDGETS_DATEPICKER		= 'jquery-ui.datepicker';		// Widgets Datepicker
	const LIB_JQUERY_UI_WIDGETS_DIALOG			= 'jquery-ui.dialog';			// Widgets Dialog
	const LIB_JQUERY_UI_WIDGETS_PROGRESSBAR		= 'jquery-ui.progressbar';		// Widgets Progressbar
	const LIB_JQUERY_UI_WIDGETS_SLIDER			= 'jquery-ui.slider';			// Widgets Slider
	const LIB_JQUERY_UI_WIDGETS_TABS			= 'jquery-ui.tabs';				// Widgets Tabs
	const LIB_JQUERY_UI_EFFECTS					= 'jquery-ui.effects';			// Effects

	// Javascriptライブラリ用のファイル
	const JQUERY_EASING_FILENAME		= 'jquery/jquery.easing.1.3.js';
	const JQUERY_JCAROUSEL_FILENAME		= 'jquery/jquery.jcarousel.0.2.4.min.js';		// jQuery1.4.2対応版
	const JQUERY_CONTEXTMENU_FILENAME	= 'jquery/jquery.contextmenu.r2.packed.js';
	const JQUERY_THICKBOX_FILENAME		= 'jquery/thickbox-compressed.js';
	const JQUERY_THICKBOX_CSS			= 'jquery/thickbox.css';
	const JQUERY_JSHOTKEYS_FILENAME		= 'jquery/jquery.hotkeys.js';
	const JQUERY_CYCLE_FILENAME			= 'jquery/jquery.cycle.all.pack.js';
	const JQUERY_CODEPRESS_FILENAME		= 'jquery/jquery.Codepress.js';
	const JQUERY_CLUETIP_FILENAME		= 'jquery/jquery.cluetip.js';
	const JQUERY_CLUETIP_CSS			= 'jquery/jquery.cluetip.css';
	const JQUERY_SIMPLETREE_FILENAME	= 'jquery/jquery.simple.tree.js';
	const JQUERY_SIMPLETREE_CSS			= 'jquery/simple.tree.css';
	const JQUERY_BGIFRAME_FILENAME		= 'jquery/jquery.bgiframe.min.js';
	const JQUERY_HOVERINTENT_FILENAME	= 'jquery/jquery.hoverIntent.min.js';
	const JQUERY_TABLEDND_FILENAME		= 'jquery/jquery.tablednd_0_5.js';
	const JQUERY_TABLEDND_CSS			= 'jquery/jquery.tablednd.css';
	const JQUERY_SIMPLEMODAL_FILENAME	= 'jquery/jquery.simplemodal-1.2.3.pack.js';
	const JQUERY_COOKIE_FILENAME		= 'jquery/jquery.cookie.js';
	const JQUERY_FORMAT_FILENAME		= 'jquery/jquery.format.1.03.js';
	const JQUERY_FORMTIPS_FILENAME		= 'jquery/jquery.formtips.1.2.packed.js';
	
	// ファイル名
	const JQUERY_FILENAME			= 'jquery-1.2.6.pack.js';					// JQuery
	const JQUERY_UI_CORE_FILENAME	= 'jquery-ui-core-1.5.2.packed.js';			// JQuery UI Core (core+Interaction)
	const JQUERY_UI_PLUS_FILENAME	= 'jquery-ui-plus-1.5.2.packed.js';			// JQuery UI Core (widgets+effects)
	const JQUERY_L_FILENAME			= 'jquery-1.4.2.min.js';					// JQuery最新版(v1.4.2)
	const JQUERY_L_UI_CORE_FILENAME	= 'jquery-ui-core-1.8.2.min.js';			// JQuery UI Core (Core)
	const JQUERY_L_UI_PLUS_FILENAME	= 'jquery-ui-plus-1.8.2.min.js';			// JQuery UI Plus (Interactions)
	const FCKEDITOR_FILENAME		= 'fckeditor2.6/fckeditor.js';				// FCKEditor
	const MD5_FILENAME				= 'md5.js';									// MD5
	// jQuery UI用ファイル
	const JQUERY_UI_WIDGETS_ACCORDION_FILENAME		= 'jquery/ui/1.8.2/jquery.ui.accordion.min.js';		// Widgets Accordion
	const JQUERY_UI_WIDGETS_AUTOCOMPLETE_FILENAME	= 'jquery/ui/1.8.2/jquery.ui.autocomplete.min.js';		// Widgets Autocomplete
	const JQUERY_UI_WIDGETS_BUTTON_FILENAME			= 'jquery/ui/1.8.2/jquery.ui.button.min.js';			// Widgets Button
	const JQUERY_UI_WIDGETS_DATEPICKER_FILENAME		= 'jquery/ui/1.8.2/jquery.ui.datepicker.min.js';		// Widgets Datepicker
	const JQUERY_UI_WIDGETS_DIALOG_FILENAME			= 'jquery/ui/1.8.2/jquery.ui.dialog.min.js';			// Widgets Dialog
	const JQUERY_UI_WIDGETS_PROGRESSBAR_FILENAME	= 'jquery/ui/1.8.2/jquery.ui.progressbar.min.js';		// Widgets Progressbar
	const JQUERY_UI_WIDGETS_SLIDER_FILENAME			= 'jquery/ui/1.8.2/jquery.ui.slider.min.js';			// Widgets Slider
	const JQUERY_UI_WIDGETS_TABS_FILENAME			= 'jquery/ui/1.8.2/jquery.ui.tabs.min.js';				// Widgets Tabs
	const JQUERY_UI_EFFECTS_FILENAME				= 'jquery/ui/1.8.2/jquery.effects.min.js';					// Effects
	
	// 設定ファイル
	//const FCKEDITOR_CONFIG			= 'm3/fckconfig.js';		// FCKEditor
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
	}
	/**
	 * ライブラリ情報取得
	 *
	 * @return array		ライブラリ情報
	 */
	function getLib()
	{
		$libs = array(self::LIB_MD5					=>	array(	'script' => array(self::MD5_FILENAME)),			// MD5
					self::LIB_FCKEDITOR				=>	array(	'script' => array(self::FCKEDITOR_FILENAME)),	// FCKEditor
					self::LIB_JQUERY_UI				=>	array(	'script' => array(self::JQUERY_UI_CORE_FILENAME)),	// jquery ui
					self::LIB_JQUERY_UI_PLUS		=>	array(	'script' => array(self::JQUERY_UI_PLUS_FILENAME)),	// jquery ui plus(追加分)
					// jQuery UI
					self::LIB_JQUERY_UI_WIDGETS_ACCORDION		=> array(	'script' => array(self::JQUERY_UI_WIDGETS_ACCORDION_FILENAME)),		// Widgets Accordion
					self::LIB_JQUERY_UI_WIDGETS_AUTOCOMPLETE	=> array(	'script' => array(self::JQUERY_UI_WIDGETS_AUTOCOMPLETE_FILENAME)),		// Widgets Autocomplete
					self::LIB_JQUERY_UI_WIDGETS_BUTTON			=> array(	'script' => array(self::JQUERY_UI_WIDGETS_BUTTON_FILENAME)),		// Widgets Button
					self::LIB_JQUERY_UI_WIDGETS_DATEPICKER		=> array(	'script' => array(self::JQUERY_UI_WIDGETS_DATEPICKER_FILENAME)),		// Widgets Datepicker
					self::LIB_JQUERY_UI_WIDGETS_DIALOG			=> array(	'script' => array(self::JQUERY_UI_WIDGETS_DIALOG_FILENAME)),		// Widgets Dialog
					self::LIB_JQUERY_UI_WIDGETS_PROGRESSBAR		=> array(	'script' => array(self::JQUERY_UI_WIDGETS_PROGRESSBAR_FILENAME)),		// Widgets Progressbar
					self::LIB_JQUERY_UI_WIDGETS_SLIDER			=> array(	'script' => array(self::JQUERY_UI_WIDGETS_SLIDER_FILENAME)),		// Widgets Slider
					self::LIB_JQUERY_UI_WIDGETS_TABS			=> array(	'script' => array(self::JQUERY_UI_WIDGETS_TABS_FILENAME)),		// Widgets Tabs
					self::LIB_JQUERY_UI_EFFECTS					=> array(	'script' => array(self::JQUERY_UI_EFFECTS_FILENAME)),		// Effects
					// jQueryライブラリ
					self::LIB_JQUERY_EASING			=>	array(	'script' => array(self::JQUERY_EASING_FILENAME)),		// jquery.easing用のファイル
					self::LIB_JQUERY_JCAROUSEL		=>	array(	'script' => array(self::JQUERY_JCAROUSEL_FILENAME)),// jquery.jcarousel用のファイル
					self::LIB_JQUERY_THICKBOX		=>	array(	'script' => array(self::JQUERY_THICKBOX_FILENAME),// jquery.thickbox用のファイル
																'css'	=> array(self::JQUERY_THICKBOX_CSS)),
					self::LIB_JQUERY_JSHOTKEYS		=>	array(	'script' => array(self::JQUERY_JSHOTKEYS_FILENAME)),	// jquery.js-hotkeys用のファイル
					self::LIB_JQUERY_CYCLE			=>	array(	'script' => array(self::JQUERY_CYCLE_FILENAME)),		// jquery.cycle用のファイル
					self::LIB_JQUERY_CODEPRESS		=>	array(	'script' => array(self::JQUERY_CODEPRESS_FILENAME)),	// jquery.codepress用のファイル
					self::LIB_JQUERY_CLUETIP		=>	array(	'script' => array(self::JQUERY_CLUETIP_FILENAME),// jquery.cluetip用のファイル
																'css'	=> array(self::JQUERY_CLUETIP_CSS)),
					self::LIB_JQUERY_SIMPLETREE		=>	array(	'script' => array(self::JQUERY_SIMPLETREE_FILENAME),// jquery.simpletree用のファイル
																'css'	=> array(self::JQUERY_SIMPLETREE_CSS)),
					self::LIB_JQUERY_BGIFRAME		=>	array(	'script' => array(self::JQUERY_BGIFRAME_FILENAME)),	// jquery.bgiframe用のファイル
					self::LIB_JQUERY_HOVERINTENT	=>	array(	'script' => array(self::JQUERY_HOVERINTENT_FILENAME)),
					self::LIB_JQUERY_TABLEDND		=>	array(	'script' => array(self::JQUERY_TABLEDND_FILENAME),	// jquery.tablednd用のファイル
																'css'	=> array(self::JQUERY_TABLEDND_CSS)),
					self::LIB_JQUERY_SIMPLEMODAL	=>	array(	'script' => array(self::JQUERY_SIMPLEMODAL_FILENAME)),// jquery.simplemodal用のファイル
					self::LIB_JQUERY_COOKIE			=>	array(	'script' => array(self::JQUERY_COOKIE_FILENAME)),
					self::LIB_JQUERY_FORMAT			=>	array(	'script' => array(self::JQUERY_FORMAT_FILENAME)),
					self::LIB_JQUERY_FORMTIPS		=>	array(	'script' => array(self::JQUERY_FORMTIPS_FILENAME)));
		return $libs;
	}
	/**
	 * jQuery UIライブラリ情報取得
	 *
	 * @return array		ライブラリ情報
	 */
	static function getJQueryUiInfo()
	{
		static $jQueryUiInfo;		// jQuery UIの情報
		
		if (!isset($jQueryUiInfo)){
			$jQueryUiInfo = array(
				self::LIB_JQUERY_UI_WIDGETS_ACCORDION		=> array(self::LIB_JQUERY_UI),		// Widgets Accordion
				self::LIB_JQUERY_UI_WIDGETS_AUTOCOMPLETE	=> array(self::LIB_JQUERY_UI),		// Widgets Autocomplete
				self::LIB_JQUERY_UI_WIDGETS_BUTTON			=> array(self::LIB_JQUERY_UI),		// Widgets Button
				self::LIB_JQUERY_UI_WIDGETS_DATEPICKER		=> array(self::LIB_JQUERY_UI),		// Widgets Datepicker
				self::LIB_JQUERY_UI_WIDGETS_DIALOG			=> array(self::LIB_JQUERY_UI,		// Widgets Dialog
																		self::LIB_JQUERY_UI_PLUS,
																		self::LIB_JQUERY_UI_WIDGETS_BUTTON),
				self::LIB_JQUERY_UI_WIDGETS_PROGRESSBAR		=> array(self::LIB_JQUERY_UI),		// Widgets Progressbar
				self::LIB_JQUERY_UI_WIDGETS_SLIDER			=> array(self::LIB_JQUERY_UI),		// Widgets Slider
				self::LIB_JQUERY_UI_WIDGETS_TABS			=> array(self::LIB_JQUERY_UI),		// Widgets Tabs
				self::LIB_JQUERY_UI_EFFECTS					=> array(self::LIB_JQUERY_UI)		// Effects
			);
		}
		return $jQueryUiInfo;
	}
}
?>
