<?php
/**
 * ヘルプリソースファイル
 * index.php
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: index.php 3411 2010-07-20 07:10:20Z fishbone $
 * @link       http://www.magic3.org
 */
// 直接アクセスの防止
defined('M3_SYSTEM') or die('Access error: Direct access denied.');

global $HELP;

// ########## 基本情報 ##########
$HELP['configsite']['title'] = 'サイト情報';
$HELP['configsite']['body'] = 'サイト運営に最小限必要な情報を設定します。';
$HELP['configsite_siteinfo']['title'] = 'サイト情報';
$HELP['configsite_siteinfo']['body'] = 'システムで必要なサイトの情報です。サイト情報は必須入力項目です。';
$HELP['configsite_sitename']['title'] = 'サイト名';
$HELP['configsite_sitename']['body'] = 'サイトの名前を設定します。';
$HELP['configsite_email']['title'] = 'メールアドレス';
$HELP['configsite_email']['body'] = 'このサイトのデフォルトのメールアドレスです。このメールアドレスは必須項目です。このサーバから発信したメールがメールアドレスを偽装したスパムメールと判断されることもあるので、サイトと同一ドメインのメールアドレスを設定するのが最適です。<br />「name@example.com」や「名前&lt; name@example.com&gt;」の設定が可能です。<br />システムからユーザへ送信する場合の送信元アドレスとして、または、このシステム上でユーザがメールを送信した場合に送信先アドレスとして使用されます。';
$HELP['configsite_copyright']['title'] = '著作権';
$HELP['configsite_copyright']['body'] = 'RSS配信データの著作権表示に使用されます。';
$HELP['configsite_pagehead']['title'] = 'ページヘッダ情報(デフォルト値)';
$HELP['configsite_pagehead']['body'] = 'HTMLのヘッダ部のmetaタグに出力する文字列を設定します。個々のページで設定されていない場合のデフォルト値です。';
$HELP['configsite_title']['title'] = 'タイトル名';
$HELP['configsite_title']['body'] = 'ヘッダ部のtitleタグに設定される文字列です。Webブラウザの画面タイトルとして表示されます。';
$HELP['configsite_description']['title'] = 'ページ要約';
$HELP['configsite_description']['body'] = 'ヘッダ部のdescriptionタグに設定される文字列です。120文字程度で記述します。';
$HELP['configsite_keywords']['title'] = '検索キーワード';
$HELP['configsite_keywords']['body'] = 'ヘッダ部のkeywordsタグに設定される文字列です。検索エンジン用のキーワードを「,」区切りで10個以下で記述します。';

// ########## システム情報 ##########
$HELP['configsys']['title'] = 'システム基本設定';
$HELP['configsys']['body'] = 'システムの動作に関する基本設定を行います。';
$HELP['configsys_ssl_url']['title'] = '共有SSLのルートURL';
$HELP['configsys_ssl_url']['body'] = '管理画面または一般画面でSSLを使用する場合にSSL専用の別のURLが設定可能です。空に設定した場合はシステムのルートURLをhttpsに変更したURLが使用されます。';
$HELP['configsys_connect_server_url']['title'] = 'ポータルサーバのURL';
$HELP['configsys_connect_server_url']['body'] = 'ポータルサーバに接続する場合の接続先URLです。Magic3がインストールされているURLを指定します。';

// ########## 言語設定 ##########
$HELP['configlang']['title'] = '言語設定';
$HELP['configlang']['body'] = '言語に関する設定を行います。';
$HELP['configlang_list']['title'] = 'アクセス可能言語';
$HELP['configlang_list']['body'] = 'アクセス可能な言語を設定します。';
$HELP['configlang_name']['title'] = '言語';
$HELP['configlang_name']['body'] = '言語名です。';
$HELP['configlang_value']['title'] = '値';
$HELP['configlang_value']['body'] = '識別用の値です。';
$HELP['configlang_accept']['title'] = '許可';
$HELP['configlang_accept']['body'] = 'アクセス可能な言語にチェックを入れます。';

// ########## ユーザ一覧 ##########
$HELP['userlist']['title'] = 'ユーザ一覧';
$HELP['userlist']['body'] = 'システムで一元管理するユーザの一覧です。';
$HELP['userlist_check']['title'] = '選択用チェックボックス';
$HELP['userlist_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['userlist_account']['title'] = 'ユーザアカウント';
$HELP['userlist_account']['body'] = 'ログイン時に使用するアカウントです。<br>メールアドレス形式のアカウントも使用できます。';
$HELP['userlist_pwd']['title'] = 'ユーザパスワード';
$HELP['userlist_pwd']['body'] = 'ログイン時に使用するパスワードです。';
$HELP['userlist_name']['title'] = '名前';
$HELP['userlist_name']['body'] = '画面上に表示されるユーザの名前です。';
$HELP['userlist_usertype']['title'] = 'ユーザ種別';
$HELP['userlist_usertype']['body'] = '管理者 - 管理機能にログインできます。<br>一般 - 管理機能以外の機能にログインできます。<br>仮登録 - 一般機能からユーザ登録を行い、まだログインしていないユーザです。一度ログインすると一般ユーザに変更されます。';
$HELP['userlist_admin']['title'] = '管理権限';
$HELP['userlist_admin']['body'] = '管理機能(管理画面)が使用可能かどうかの設定です。<br>チェックが入っていると管理機能が使用可能です。';
$HELP['userlist_login']['title'] = 'ログイン可';
$HELP['userlist_login']['body'] = 'ログインを許可するかどうかの設定です。<br>チェックが入っているとログイン可能です。';
$HELP['userlist_new_btn']['title'] = '新規ボタン';
$HELP['userlist_new_btn']['body'] = '新規ユーザを追加します。';
$HELP['userlist_edit_btn']['title'] = '編集ボタン';
$HELP['userlist_edit_btn']['body'] = '選択されているユーザを編集します。<br>ユーザを選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['userlist_del_btn']['title'] = '削除ボタン';
$HELP['userlist_del_btn']['body'] = '選択されているユーザを削除します。<br>ユーザを選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['userlist_ret_btn']['title'] = '戻るボタン';
$HELP['userlist_ret_btn']['body'] = 'ユーザ一覧へ戻ります。';

// ########## ウィジェット一覧 ##########
$HELP['widgetlist']['title'] = 'ウィジェット一覧';
$HELP['widgetlist']['body'] = 'システムで利用可能なウィジェットの一覧です。ウィジェットのインストールはこの画面の最下部の「ウィジェットアップロード」から行います。';
$HELP['widgetlist_type']['title'] = 'ウィジェットタイプ';
$HELP['widgetlist_type']['body'] = 'PC用のウィジェットか携帯用のウィジェットかを選択します。';
$HELP['widgetlist_install_dir']['title'] = 'ウィジェットインストールディレクトリ';
$HELP['widgetlist_install_dir']['body'] = 'ウィジェットのインストールディレクトリです。この配下に「ウィジェットID」のディレクトリ名で個々のウィジェットが格納されます。';
$HELP['widgetlist_id']['title'] = 'ID';
$HELP['widgetlist_id']['body'] = 'ウィジェットのIDです。ウィジェットのディレクトリ名と同一です。';
$HELP['widgetlist_name']['title'] = '名前';
$HELP['widgetlist_name']['body'] = 'ウィジェットの名前です。';
$HELP['widgetlist_available']['title'] = '配置可能';
$HELP['widgetlist_available']['body'] = 'ウィジェットを配置用の選択メニューに表示するかどうかを指定します。すでにページに配置されているウィジェットはそのまま維持されます。';
$HELP['widgetlist_active']['title'] = '実行可能';
$HELP['widgetlist_active']['body'] = 'ウィジェットの実行を許可します。特定のウィジェットを緊急停止する場合に使用します。';
$HELP['widgetlist_act']['title'] = '操作';
$HELP['widgetlist_act']['body'] = '各種操作を行います。<br />●更新<br />この一覧で変更した値を保存します。<br />●削除<br />ウィジェットをシステムから削除します。<br />●設定<br />ウィジェットの設定画面を表示します。ウィジェットの設定画面はページ作成画面やトップメニュー画面からも表示可能です。<br />●ダウンロード<br />ウィジェットをZIP圧縮形式でダウンロードします。このファイルはそのまま「ウィジェットアップロード」からシステムへインストールできる形式です。';
$HELP['widgetlist_upload']['title'] = 'ウィジェットアップロード';
$HELP['widgetlist_upload']['body'] = 'ZIP形式のウィジェットファイルをアップロードし、システムにウィジェットをインストールします。同じIDのウィジェットがすでに存在する場合はエラーになります。<br />「ウィジェットが存在する場合は置き換え」にチェックが入っている場合、既存のウィジェットを削除した後、ウィジェットをインストールします。';
$HELP['widgetlist_detail_check']['title'] = '詳細表示';
$HELP['widgetlist_detail_check']['body'] = 'チェックを入れると一覧が詳細表示できます。';
$HELP['widgetlist_reload_dir_btn']['title'] = 'ディレクトリ再読み込み';
$HELP['widgetlist_reload_dir_btn']['body'] = 'ウィジェットディレクトリを再読み込みして、一覧に表示されていないウィジェットを自動的にインストールします。';

// ########## テンプレート一覧 ##########
$HELP['templist']['title'] = 'テンプレート一覧';
$HELP['templist']['body'] = 'システムで利用可能なテンプレートの一覧です。テンプレートのインストールはこの画面の最下部の「テンプレートアップロード」から行います。';
$HELP['templist_type']['title'] = 'テンプレートタイプ';
$HELP['templist_type']['body'] = 'PC用のテンプレートか携帯用のテンプレートかを選択します。';
$HELP['templist_install_dir']['title'] = 'テンプレートインストールディレクトリ';
$HELP['templist_install_dir']['body'] = 'テンプレートのインストールディレクトリです。この配下に「テンプレートID」のディレクトリ名で個々のテンプレートが格納されます。';
$HELP['templist_id']['title'] = 'ID';
$HELP['templist_id']['body'] = 'テンプレートのIDです。テンプレートのディレクトリ名と同一です。';
$HELP['templist_name']['title'] = '名前';
$HELP['templist_name']['body'] = 'テンプレートの名前です。';
$HELP['templist_format']['title'] = '形式';
$HELP['templist_format']['body'] = 'テンプレートの形式です。<br />利用可能な形式は以下の通りです。Magic3では現在J15を標準としています。<br />●J10<br />Joomla! v1.0用テンプレート<br />●J15<br />Joomla! v1.5用テンプレート';
$HELP['templist_default']['title'] = 'デフォルト';
$HELP['templist_default']['body'] = '現在システムで選択されているデフォルトのテンプレートを示します。';
$HELP['templist_act']['title'] = '操作';
$HELP['templist_act']['body'] = '各種操作を行います。<br />●プレビュー<br />テンプレートがプレビューできます。<br />●更新<br />この一覧で変更した値を保存します。<br />●削除<br />テンプレートをシステムから削除します。<br />●ダウンロード<br />テンプレートをZIP圧縮形式でダウンロードします。このファイルはそのまま「テンプレートアップロード」からシステムへインストールできる形式です。';
$HELP['templist_upload']['title'] = 'テンプレートアップロード';
$HELP['templist_upload']['body'] = 'ZIP形式のテンプレートファイルをアップロードし、システムにテンプレートをインストールします。同じIDのテンプレートがすでに存在する場合はエラーになります。';
$HELP['templist_detail_check']['title'] = '詳細表示';
$HELP['templist_detail_check']['body'] = 'チェックを入れると一覧が詳細表示できます。';
$HELP['templist_reload_dir_btn']['title'] = 'ディレクトリ再読み込み';
$HELP['templist_reload_dir_btn']['body'] = 'テンプレートディレクトリを再読み込みして、一覧に表示されていないテンプレートを自動的にインストールします。';

// ########## 画面作成 ##########
$HELP['pagedef_page_id']['title'] = 'ページID';
$HELP['pagedef_page_id']['body'] = 'ページを定義するためのIDです。IDはURLに付加されます。非公開項目は管理権限のない一般ユーザには公開されないページです。';
$HELP['pagedef_page_sub_id']['title'] = 'ページサブID';
$HELP['pagedef_page_sub_id']['body'] = 'ページを定義するための補助IDです。IDはURLに付加されます。';
$HELP['pagedef_preview_url']['title'] = 'URL';
$HELP['pagedef_preview_url']['body'] = 'プレビューに表示しているページへのURLです。';
$HELP['pagedef_detail_btn']['title'] = '詳細ボタン';
$HELP['pagedef_detail_btn']['body'] = 'ページ定義の詳細を表示します。';
$HELP['pagedef_maximize_btn']['title'] = '最大化ボタン';
$HELP['pagedef_maximize_btn']['body'] = 'レイアウト画面を最大化します。画面を元に戻すにはESCキーを押します。ESCキーでも最大化できます。';
$HELP['pagedef_default_template']['title'] = 'デフォルトテンプレート';
$HELP['pagedef_default_template']['body'] = 'デフォルトで設定されるデザインテンプレートを指定します。';
$HELP['pagedef_change_template_btn']['title'] = 'テンプレート変更';
$HELP['pagedef_change_template_btn']['body'] = 'デフォルトのテンプレートを変更します。';
$HELP['pagedef_template_img']['title'] = 'テンプレート表示イメージ';
$HELP['pagedef_template_img']['body'] = 'テンプレートを設定した場合の画面の表示イメージです。';
$HELP['pagedef_widget']['title'] = 'ウィジェット';
$HELP['pagedef_widget']['body'] = 'レイアウトに配置可能なウィジェットです。シングルクリックで取得し、画面レイアウト領域に配置します。';
$HELP['pagedef_layout']['title'] = '画面レイアウト';
$HELP['pagedef_layout']['body'] = '(ウィジェットの配置)<br>テンプレートにウィジェットを配置し、画面を作成します。ウィジェット一覧からマウスドラッグでウィジェットを取り出します。レイアウト画面の任意のポジション位置にドロップするとウィジェットが配置できます。レイアウト画面からウィジェットを削除するには、削除するウィジェットの右上のクローズボックスをクリックします。一度ドロップしたウィジェットは、ドラッグドロップでページ上の移動が可能です。最大化ボタンまたはESCキーでレイアウト画面が最大化できます。最大化状態から元に戻るにはESCキーを押します。<br>(ウィジェットコンテキストメニュー)<br>ウィジェットをマウス右クリックするとコンテキストメニューが表示されます。ウィジェットの設定を行ったり、ウィジェットの削除を行います。「ページ共通」属性を設定したウィジェットは、ページに関わらず常に表示されます。(赤色表示)';
$HELP['pagedef_preview']['title'] = 'レイアウトとプレビューの切り替えボタン';
$HELP['pagedef_preview']['body'] = 'ウィジェットの配置を行うレイアウト画面と、実際に表示されるプレビュー画面を切り替えます。';
$HELP['pagedef_refresh']['title'] = '画面再表示';
$HELP['pagedef_refresh']['body'] = 'レイアウトまたはプレビュー画面を再表示します。';
$HELP['pagedef_preview_other']['title'] = '別画面でプレビュー';
$HELP['pagedef_preview_other']['body'] = '実際に表示される画面を別ウィンドウで表示します。';
$HELP['pagedef_position_block']['title'] = 'ポジション名';
$HELP['pagedef_position_block']['body'] = 'デザインテンプレート内でのウィジェットの配置ブロックを指定します。';
$HELP['pagedef_position_index']['title'] = '表示順';
$HELP['pagedef_position_index']['body'] = 'ポジションブロック内でのウィジェットの表示順を指定します。';
$HELP['pagedef_widget_def_id']['title'] = '定義ID';
$HELP['pagedef_widget_def_id']['body'] = '個別のウィジェットの設定IDです。設定が必要な場合のみ設定可能になります。';
$HELP['pagedef_widget_visible']['title'] = 'ウィジェット表示制御';
$HELP['pagedef_widget_visible']['body'] = 'ウィジェットの表示、非表示を制御します。';
$HELP['pagedef_widget_common']['title'] = 'ページ共通属性';
$HELP['pagedef_widget_common']['body'] = '同ページIDで、サブページIDに関わらずウィジェットを表示するかどうかを指定します。';

// ########## テーブルデータ編集 ##########
$HELP['edittable_new_btn']['title'] = '新規ボタン';
$HELP['edittable_new_btn']['body'] = '新規レコードを追加します。';
$HELP['edittable_edit_btn']['title'] = '編集ボタン';
$HELP['edittable_edit_btn']['body'] = '選択されているレコードを編集します。<br>レコードを選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['edittable_del_btn']['title'] = '削除ボタン';
$HELP['edittable_del_btn']['body'] = '選択されているレコードを削除します。<br>レコードを選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['edittable_ret_btn']['title'] = '戻るボタン';
$HELP['edittable_ret_btn']['body'] = 'レコード一覧へ戻ります。';

// ########## 管理メニュー編集編集 ##########
$HELP['editmenu_config_others_btn']['title'] = 'その他ボタン';
$HELP['editmenu_config_others_btn']['body'] = 'その他の設定を行います。';
$HELP['editmenu_ret_btn']['title'] = '戻るボタン';
$HELP['editmenu_ret_btn']['body'] = '管理メニュー編集へ戻ります。';
$HELP['editmenu_top_image']['title'] = '管理メニュー画像';
$HELP['editmenu_top_image']['body'] = '管理メニュー上に表示する画像です。[Magic3ルート]からの相対パスで指定します。';

// ########## 置換文字列 ##########
$HELP['usercustom_list']['title'] = '置換文字列一覧';
$HELP['usercustom_list']['body'] = '置換文字列一覧です。置換文字列は、コンテンツテキストに埋め込み、コンテンツ表示時に自動変換される文字列です。';
$HELP['usercustom_detail']['title'] = '置換文字列詳細';
$HELP['usercustom_detail']['body'] = '置換文字列の情報を編集します。';
$HELP['usercustom_new_btn']['title'] = '新規ボタン';
$HELP['usercustom_new_btn']['body'] = '新規に置換文字列を追加します。';
$HELP['usercustom_edit_btn']['title'] = '編集ボタン';
$HELP['usercustom_edit_btn']['body'] = '選択されている置換文字列を編集します。<br />置換文字列を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['usercustom_del_btn']['title'] = '削除ボタン';
$HELP['usercustom_del_btn']['body'] = '選択されている置換文字列を削除します。<br />置換文字列を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['usercustom_ret_btn']['title'] = '戻るボタン';
$HELP['usercustom_ret_btn']['body'] = '置換文字列一覧へ戻ります。';
$HELP['usercustom_check']['title'] = '選択用チェックボックス';
$HELP['usercustom_check']['body'] = '編集や削除を行う項目を選択します。';

$HELP['usercustom_check2']['title'] = '選択用ラジオボタン';
$HELP['usercustom_check2']['body'] = '編集を行う項目を選択します。新規追加する場合は「新規追加」項目を選択します。';
$HELP['usercustom_key']['title'] = '置換キー文字列';
$HELP['usercustom_key']['body'] = 'コンテンツテキストに埋め込むキー文字列です。コンテンツ表示時に、この文字列が「置換内容」に変換されます。';
$HELP['usercustom_name']['title'] = '置換文字列名';
$HELP['usercustom_name']['body'] = '置換文字列の管理上の名前です。';
$HELP['usercustom_value']['title'] = '置換内容';
$HELP['usercustom_value']['body'] = 'コンテンツ表示時に、コンテンツ上の置換キーから変換される文字列です。';

// ########## ページ情報 ##########
$HELP['pageinfo']['title'] = 'ページ情報';
$HELP['pageinfo']['body'] = 'サイトのアクセス単位であるページについての情報を設定します。';
$HELP['pageinfo_list']['title'] = 'ページ情報一覧';
$HELP['pageinfo_list']['body'] = 'ページはアクセスポイントである「ページID」とサブパラメータの「ページサブID」のセットで一意に決まります。<br>ページサブIDはURLのクエリーパラメータ「sub=サブページID」で指定されるIDです。';
$HELP['pageinfo_detail']['title'] = 'ページ情報詳細';
$HELP['pageinfo_detail']['body'] = 'ページ情報を編集します。';

$HELP['pageinfo_check']['title'] = '選択用チェックボックス';
$HELP['pageinfo_check']['body'] = '編集を行う項目を選択します。';
$HELP['pageinfo_pageid']['title'] = 'ページID';
$HELP['pageinfo_pageid']['body'] = 'URLで実行されるスクリプトファイルがアクセスポイントであるページIDです。';
$HELP['pageinfo_subid']['title'] = 'ページサブID';
$HELP['pageinfo_subid']['body'] = 'URLのクエリーパラメータ「sub=サブページID」で指定するIDです。';
$HELP['pageinfo_name']['title'] = '名前';
$HELP['pageinfo_name']['body'] = '選択メニュー等で表示される名前です。';
$HELP['pageinfo_attr']['title'] = 'ページ属性';
$HELP['pageinfo_attr']['body'] = 'ページに表示されるメインコンテンツのデータ種別を指定します。';
$HELP['pageinfo_public']['title'] = '公開';
$HELP['pageinfo_public']['body'] = '管理者以外のユーザがアクセス可能であるかどうかを示します。';
$HELP['pageinfo_ssl']['title'] = 'SSL';
$HELP['pageinfo_ssl']['body'] = 'SSLを使用してページを表示するかどうかを設定します。';
$HELP['pageinfo_default']['title'] = 'デフォルト';
$HELP['pageinfo_default']['body'] = 'デフォルトで選択されている項目は、ページサブIDが省略されたときに指定されるページサブIDです。';
$HELP['pageinfo_ref']['title'] = '使用';
$HELP['pageinfo_ref']['body'] = 'ページ上に存在するウィジェット数です。共通属性が設定されているウィジェットは含みません。';
$HELP['pageinfo_edit_btn']['title'] = '編集ボタン';
$HELP['pageinfo_edit_btn']['body'] = '選択されているページサブIDの情報を編集します。<br>選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['pageinfo_ret_btn']['title'] = '戻るボタン';
$HELP['pageinfo_ret_btn']['body'] = 'ページ情報一覧へ戻ります。';

// ########## ページヘッダ情報 ##########
$HELP['pagehead']['title'] = 'ページヘッダ情報';
$HELP['pagehead']['body'] = 'HTMLのヘッダ部のmetaタグに出力する文字列を設定します。';
$HELP['pagehead_list']['title'] = 'ページヘッダ情報一覧';
$HELP['pagehead_list']['body'] = 'ページはアクセスポイントである「ページID」とサブパラメータの「ページサブID」のセットで一意に決まります。<br>ページサブIDはURLのクエリーパラメータ「sub=サブページID」で指定されるIDです。';
$HELP['pagehead_detail']['title'] = 'ページヘッダ情報詳細';
$HELP['pagehead_detail']['body'] = 'ページヘッダ情報を編集します。';

$HELP['pagehead_check']['title'] = '選択用チェックボックス';
$HELP['pagehead_check']['body'] = '編集を行う項目を選択します。';
$HELP['pagehead_pageid']['title'] = 'ページID';
$HELP['pagehead_pageid']['body'] = 'URLで実行されるスクリプトファイルがアクセスポイントであるページIDです。';
$HELP['pagehead_subid']['title'] = 'ページサブID';
$HELP['pagehead_subid']['body'] = 'URLのクエリーパラメータ「sub=サブページID」で指定するIDです。';
$HELP['pagehead_name']['title'] = 'ページ名';
$HELP['pagehead_name']['body'] = 'ページの名前です。';
$HELP['pagehead_title']['title'] = 'タイトル名';
$HELP['pagehead_title']['body'] = 'ヘッダ部のtitleタグに設定される文字列です。Webブラウザの画面タイトルとして表示されます。';
$HELP['pagehead_description']['title'] = 'ページ要約';
$HELP['pagehead_description']['body'] = 'ヘッダ部のdescriptionタグに設定される文字列です。120文字程度で記述します。';
$HELP['pagehead_keywords']['title'] = '検索キーワード';
$HELP['pagehead_keywords']['body'] = 'ヘッダ部のkeywordsタグに設定される文字列です。検索エンジン用のキーワードを「,」区切りで10個以下で記述します。';
$HELP['pagehead_public']['title'] = '公開';
$HELP['pagehead_public']['body'] = '管理者以外のユーザがアクセス可能であるかどうかを示します。';
$HELP['pagehead_default']['title'] = 'デフォルト';
$HELP['pagehead_default']['body'] = 'デフォルトで選択されている項目は、ページサブIDが省略されたときに使用されるページサブIDです。';
$HELP['pagehead_edit_btn']['title'] = '編集ボタン';
$HELP['pagehead_edit_btn']['body'] = '選択されているページサブIDの情報を編集します。<br>選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['pagehead_ret_btn']['title'] = '戻るボタン';
$HELP['pagehead_ret_btn']['body'] = 'ページ情報一覧へ戻ります。';

// ########## ページID ##########
$HELP['pageid']['title'] = 'ページID';
$HELP['pageid']['body'] = 'ページID、ページサブIDの編集を行います';
$HELP['pageid_list']['title'] = 'ページID一覧';
$HELP['pageid_list']['body'] = 'ページIDの一覧です。ページIDとページサブIDを切り替えます。';
$HELP['pageid_detail']['title'] = 'ページID詳細';
$HELP['pageid_detail']['body'] = 'ページIDを編集します。';
$HELP['pageid_check']['title'] = '選択用チェックボックス';
$HELP['pageid_check']['body'] = '編集を行う項目を選択します。';
$HELP['pageid_id']['title'] = 'ページID';
$HELP['pageid_id']['body'] = 'ページIDまたはページサブIDを示します。';
$HELP['pageid_name']['title'] = '名前';
$HELP['pageid_name']['body'] = '選択メニュー等で表示される名前です。';
$HELP['pageid_desc']['title'] = '説明';
$HELP['pageid_desc']['body'] = '項目についての説明です。';
$HELP['pageid_path']['title'] = 'パス';
$HELP['pageid_path']['body'] = 'URLでのアクセスパスを示します。';
$HELP['pageid_priority']['title'] = '優先順';
$HELP['pageid_priority']['body'] = '項目の優先順を指定します。';
$HELP['pageid_active']['title'] = '公開';
$HELP['pageid_active']['body'] = 'ページIDを一般ユーザに公開するかどうかを指定します。非公開のページIDへは一般ユーザからアクセスできません。';
$HELP['pageid_new_btn']['title'] = '新規ボタン';
$HELP['pageid_new_btn']['body'] = '新規ページIDを追加します。';
$HELP['pageid_edit_btn']['title'] = '編集ボタン';
$HELP['pageid_edit_btn']['body'] = '選択されているページIDを編集します。<br>選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['pageid_del_btn']['title'] = '削除ボタン';
$HELP['pageid_del_btn']['body'] = '選択されているページIDを削除します。<br>選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['pageid_ret_btn']['title'] = '戻るボタン';
$HELP['pageid_ret_btn']['body'] = 'ページID一覧へ戻ります。';

// ########## メニューID ##########
$HELP['menuid']['title'] = 'メニューID';
$HELP['menuid']['body'] = 'メニューIDの編集を行います';
$HELP['menuid_list']['title'] = 'メニューID一覧';
$HELP['menuid_list']['body'] = 'メニューIDの一覧です。';
$HELP['menuid_detail']['title'] = 'メニューID詳細';
$HELP['menuid_detail']['body'] = 'メニューIDを編集します。';
$HELP['menuid_check']['title'] = '選択用チェックボックス';
$HELP['menuid_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['menuid_id']['title'] = 'メニューID';
$HELP['menuid_id']['body'] = 'メニューIDを示します。';
$HELP['menuid_name']['title'] = '名前';
$HELP['menuid_name']['body'] = '選択メニュー等で表示される名前です。';
$HELP['menuid_desc']['title'] = '説明';
$HELP['menuid_desc']['body'] = '項目についての説明です。';
$HELP['menuid_sort_order']['title'] = 'ソート順';
$HELP['menuid_sort_order']['body'] = '項目の並び順を指定します。';
$HELP['menuid_ref']['title'] = '使用';
$HELP['menuid_ref']['body'] = 'メニューIDを使用しているウィジェット数を示します。使用が0のメニューIDのみ削除可能です。';
$HELP['menuid_new_btn']['title'] = '新規ボタン';
$HELP['menuid_new_btn']['body'] = '新規メニューIDを追加します。';
$HELP['menuid_edit_btn']['title'] = '編集ボタン';
$HELP['menuid_edit_btn']['body'] = '選択されているメニューIDを編集します。<br>選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['menuid_del_btn']['title'] = '削除ボタン';
$HELP['menuid_del_btn']['body'] = '選択されているメニューIDを削除します。<br />メニューIDを選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['menuid_ret_btn']['title'] = '戻るボタン';
$HELP['menuid_ret_btn']['body'] = 'メニューID一覧へ戻ります。';

// ########## 運用ログ ##########
$HELP['opelog_list']['title'] = '運用ログ一覧';
$HELP['opelog_list']['body'] = '運用ログ一覧です。最新のメッセージから順にシステム運用状況のログを表示します。';
$HELP['opelog_detail']['title'] = '運用ログ詳細';
$HELP['opelog_detail']['body'] = '運用ログの情報を編集します。';
$HELP['opelog_log_level']['title'] = '表示ログ種別';
$HELP['opelog_log_level']['body'] = '一覧に表示するログをメッセージのレベルで制限します。メッセージは「要確認」または「通常」レベルのどちらかです。「要確認」レベルは確認する必要がある項目です。「通常」レベルは特に確認の必要のない項目です。';
$HELP['opelog_log_status']['title'] = '表示ログステータス';
$HELP['opelog_log_status']['body'] = '一覧に表示するログを運用ログの「確認」状況によって制限します。';
$HELP['opelog_check']['title'] = '選択用チェックボックス';
$HELP['opelog_check']['body'] = '編集を行う項目を選択します。';
$HELP['opelog_message_type']['title'] = 'メッセージ種別';
$HELP['opelog_message_type']['body'] = 'メッセージの種別を示します。メッセージの種別は、システム情報(システム運用の正常な動作を示す)、システム警告(システム運用の注意が必要な動作を示す)、システム通常エラー(システム運用の異常な動作を示す)、システム致命的エラー(システム運用の致命的に異常な動作を示す)、ユーザ操作(ユーザ操作の正常な動作を示す)、ユーザ操作エラー(ユーザ操作の異常な動作を示す)、ユーザ不正アクセス(ユーザ操作の不正なアクセスを示す)、ユーザ不正データ(ユーザ操作の不正なデータ送信を示す)があります。';
$HELP['opelog_message']['title'] = 'メッセージ';
$HELP['opelog_message']['body'] = 'ログメッセージを示します。';
$HELP['opelog_message_detail']['title'] = 'メッセージ詳細';
$HELP['opelog_message_detail']['body'] = '詳細なログメッセージを示します。';
$HELP['opelog_ip']['title'] = 'IP';
$HELP['opelog_ip']['body'] = '処理を実行したクライアントのIPを示します。';
$HELP['opelog_access_log']['title'] = 'アクセスログ番号';
$HELP['opelog_access_log']['body'] = 'アクセスログのシリアル番号を示します。';
$HELP['opelog_message_check']['title'] = 'メッセージ確認状況';
$HELP['opelog_message_check']['body'] = 'メッセージの確認状況を示します。';
$HELP['opelog_message_dt']['title'] = '日時';
$HELP['opelog_message_dt']['body'] = 'ログを出力した日時です。';
$HELP['opelog_edit_btn']['title'] = '編集ボタン';
$HELP['opelog_edit_btn']['body'] = '選択されている運用ログを編集します。<br>選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['opelog_ret_btn']['title'] = '戻るボタン';
$HELP['opelog_ret_btn']['body'] = '運用ログ一覧へ戻ります。';

// ########## アクセスログ ##########
$HELP['accesslog_list']['title'] = 'アクセスログ一覧';
$HELP['accesslog_list']['body'] = 'アクセスログ一覧です。最新のメッセージから順にシステム運用状況のログを表示します。';
$HELP['accesslog_detail']['title'] = 'アクセスログ詳細';
$HELP['accesslog_detail']['body'] = 'アクセスログの情報を編集します。';
$HELP['accesslog_check']['title'] = '選択用チェックボックス';
$HELP['accesslog_check']['body'] = '詳細表示を行う項目を選択します。';
$HELP['accesslog_no']['title'] = 'アクセスログ番号';
$HELP['accesslog_no']['body'] = 'アクセスログのシリアル番号です。';
$HELP['accesslog_uri']['title'] = 'URI';
$HELP['accesslog_uri']['body'] = 'アクセス先のURIです。';
$HELP['accesslog_country']['title'] = '国';
$HELP['accesslog_country']['body'] = 'ブラウザの使用言語から判断したユーザの所属国です。';
$HELP['accesslog_browser']['title'] = '種別';
$HELP['accesslog_browser']['body'] = 'USER_AGENTから判断したWebブラウザ、クローラ等の種別です。';
$HELP['accesslog_os']['title'] = 'OS';
$HELP['accesslog_os']['body'] = 'USER_AGENTから判断したOS種別です。';
$HELP['accesslog_referer']['title'] = 'REFERER';
$HELP['accesslog_referer']['body'] = '現在のページに遷移する前に参照していたURIです。';
$HELP['accesslog_request']['title'] = 'REQUEST';
$HELP['accesslog_request']['body'] = 'クライアントからの送信データです。';
$HELP['accesslog_agent']['title'] = 'AGENT';
$HELP['accesslog_agent']['body'] = 'リクエストヘッダの「User-Agent:」の値です。';
$HELP['accesslog_language']['title'] = 'LANGUAGE';
$HELP['accesslog_language']['body'] = 'リクエストヘッダの「Accept-Language:」の値です。';
$HELP['accesslog_method']['title'] = 'メソッド';
$HELP['accesslog_method']['body'] = '送信メソッドです。';
$HELP['accesslog_cookie']['title'] = 'クッキー値';
$HELP['accesslog_cookie']['body'] = 'ユーザ識別用のクッキー値です。';
$HELP['accesslog_ip']['title'] = 'アクセス元IP';
$HELP['accesslog_ip']['body'] = 'クライアントのIPアドレスです。';
$HELP['accesslog_user']['title'] = 'ユーザ名';
$HELP['accesslog_user']['body'] = 'クッキーからユーザが識別可能な場合はユーザ名を示します。';
$HELP['accesslog_dt']['title'] = '日時';
$HELP['accesslog_dt']['body'] = 'ログを出力した日時です。';
$HELP['accesslog_edit_btn']['title'] = '編集ボタン';
$HELP['accesslog_edit_btn']['body'] = '選択されているアクセスログの詳細を参照します。<br>選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['accesslog_ret_btn']['title'] = '戻るボタン';
$HELP['accesslog_ret_btn']['body'] = 'アクセスログ一覧へ戻ります。';

// ########## メニュー定義 ##########
$HELP['menudef_list']['title'] = 'メニュー定義一覧';
$HELP['menudef_list']['body'] = '選択したメニュー定義のメニュー項目一覧です。';
$HELP['menudef_detail']['title'] = 'メニュー項目詳細';
$HELP['menudef_detail']['body'] = 'メニュー項目の設定を編集します。';
$HELP['menudef_check']['title'] = '選択用チェックボックス';
$HELP['menudef_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['menudef_name']['title'] = '名前';
$HELP['menudef_name']['body'] = 'メニュー項目の名前です。';
$HELP['menudef_item_type']['title'] = 'メニュー項目タイプ';
$HELP['menudef_item_type']['body'] = 'メニュー項目のタイプです。<br />「リンク」-クリックすると画面遷移する通常のリンク項目です。<br />「フォルダ」-サブメニューを持つ項目です。<br />「テキスト」-画面遷移せず文字列を表示するだけの項目です。<br />「セパレータ」-区切り項目です。';
$HELP['menudef_link_url']['title'] = 'リンク先URL';
$HELP['menudef_link_url']['body'] = 'メニュー項目をクリックしたときに表示されるURLです。';
$HELP['menudef_link_type']['title'] = '表示方法';
$HELP['menudef_link_type']['body'] = 'メニュー項目をクリックしたときにリンク先が同じウィンドウで表示するか、別ウィンドウで表示するかを指定します。';
$HELP['menudef_visible']['title'] = '表示制御';
$HELP['menudef_visible']['body'] = 'メニュー項目をユーザに公開するかどうかを制御します。非公開に設定の場合はユーザから参照することはできません。<br />「リンク先のコンテンツに連動」にチェックを入れるとリンク先のコンテンツの表示状態に連動してメニュー項目を自動表示制御します。';
$HELP['menudef_act']['title'] = '操作';
$HELP['menudef_act']['body'] = '各種操作を行います。<br />●コンテンツを編集<br />メニュー項目のリンク先がコンテンツ表示の場合、表示されるコンテンツの編集を行います。';
$HELP['menudef_sel_link']['title'] = 'リンク先を選択';
$HELP['menudef_sel_link']['body'] = 'リンク先を選択します。「コンテンツ」を選択した場合は、表示するコンテンツを指定します。[任意設定]を選択した場合は、任意のURLにリンク先を設定できます。';
$HELP['menudef_desc']['title'] = 'メニュー項目説明';
$HELP['menudef_desc']['body'] = 'メニュー項目についての説明です。';
$HELP['menudef_new_btn']['title'] = '新規ボタン';
$HELP['menudef_new_btn']['body'] = '新規メニュー項目を追加します。';
$HELP['menudef_edit_btn']['title'] = '編集ボタン';
$HELP['menudef_edit_btn']['body'] = '選択されているメニュー項目を編集します。<br />メニュー項目を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['menudef_del_btn']['title'] = '削除ボタン';
$HELP['menudef_del_btn']['body'] = '選択されているメニュー項目を削除します。<br />メニュー項目を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['menudef_ret_btn']['title'] = '戻るボタン';
$HELP['menudef_ret_btn']['body'] = 'メニュー項目一覧へ戻ります。';

// ########## ウィジェット表示調整 ##########
$HELP['adjustwidget']['title'] = 'ウィジェットタイトル、位置調整';
$HELP['adjustwidget']['body'] = 'ウィジェットのタイトルやウィジェットの表示内容の位置調整を行います。';
$HELP['adjustwidget_title']['title'] = 'タイトル名';
$HELP['adjustwidget_title']['body'] = 'ウィジェットの上部に表示されるタイトル名を設定します。空に設定した場合はデフォルトのタイトル名が表示されます。「表示」チェックボックスでタイトルの表示、非表示の制御を行います。ここでの設定は他のすべての設定に優先します。';
$HELP['adjustwidget_align']['title'] = '表示位置';
$HELP['adjustwidget_align']['body'] = 'ウィジェットの表示内容の位置を設定します。';
$HELP['adjustwidget_margin']['title'] = 'マージン';
$HELP['adjustwidget_margin']['body'] = 'ウィジェットの表示内容のマージンを設定します。空に設定したフィールドは指定なしになります。';

// ########## リソースブラウズ ##########
$HELP['resbrowse']['title'] = 'リソースブラウズ';
$HELP['resbrowse']['body'] = 'サムネール画像を見ながら画像ファイルの処理が行えます。';

// ########## ファイルブラウズ ##########
$HELP['filebrowse']['title'] = 'ファイルアップロード';
$HELP['filebrowse']['body'] = '複数のファイルを一度にアップロードできます。';
$HELP['filebrowse_path']['title'] = 'パス';
$HELP['filebrowse_path']['body'] = '現在のディレクトリパスを示します。';
$HELP['filebrowse_filename']['title'] = 'ファイル名';
$HELP['filebrowse_filename']['body'] = 'ファイル名、ディレクトリ名を示します。';
$HELP['filebrowse_size']['title'] = 'サイズ';
$HELP['filebrowse_size']['body'] = 'ファイルのサイズを示します。';
$HELP['filebrowse_permission']['title'] = 'パーミッション';
$HELP['filebrowse_permission']['body'] = 'ファイル、ディレクトリのパーミッションを示します。';
$HELP['filebrowse_owner']['title'] = '所有者';
$HELP['filebrowse_owner']['body'] = 'ファイル、ディレクトリの所有者を示します。';
$HELP['filebrowse_group']['title'] = 'グループ';
$HELP['filebrowse_group']['body'] = 'ファイル、ディレクトリのグループ所有者を示します。';
$HELP['filebrowse_date']['title'] = '更新日時';
$HELP['filebrowse_date']['body'] = 'ファイル、ディレクトリの更新日時を示します。';
$HELP['filebrowse_upload_status']['title'] = 'ファイルアップロード状況';
$HELP['filebrowse_upload_status']['body'] = 'ファイルのアップロードはここから行います。ファイルアップロード時はアップロード状況が表示されます。';
$HELP['filebrowse_del_btn']['title'] = '削除ボタン';
$HELP['filebrowse_del_btn']['body'] = '選択されているメニュー項目を削除します。<br />メニュー項目を選択するには、一覧の左端のチェックボックスにチェックを入れます。<br />「resource」ディレクトリ以下のファイルのみ削除可能です。';

// ########## テナントサーバ管理 ##########
$HELP['tenantserver']['title'] = 'テナントサーバ管理';
$HELP['tenantserver']['body'] = 'テナントサーバの管理を行います';
$HELP['tenantserver_list']['title'] = 'テナントサーバ一覧';
$HELP['tenantserver_list']['body'] = 'テナントサーバの一覧です。';
$HELP['tenantserver_detail']['title'] = 'テナントサーバ詳細';
$HELP['tenantserver_detail']['body'] = 'テナントサーバの情報を編集します。';
$HELP['tenantserver_check']['title'] = '選択用チェックボックス';
$HELP['tenantserver_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['tenantserver_name']['title'] = '名前';
$HELP['tenantserver_name']['body'] = 'サーバ識別用の名前です。任意に設定します。';
$HELP['tenantserver_server_id']['title'] = 'サーバID';
$HELP['tenantserver_server_id']['body'] = 'サーバ識別用のIDです。システム情報の「サーバID」の値です。';
$HELP['tenantserver_ip']['title'] = 'IPアドレス';
$HELP['tenantserver_ip']['body'] = 'サーバのIPアドレスです。';
$HELP['tenantserver_url']['title'] = 'URL';
$HELP['tenantserver_url']['body'] = 'サーバのURLです。';
$HELP['tenantserver_access']['title'] = 'ポータル接続可';
$HELP['tenantserver_access']['body'] = 'ポータルサーバに接続可能かどうかを設定します。一時的に接続不可にする場合等に使用します。';
$HELP['tenantserver_update_dt']['title'] = '更新日時';
$HELP['tenantserver_update_dt']['body'] = 'サーバ情報の更新日時です。';
$HELP['tenantserver_db_info']['title'] = 'DB接続情報';
$HELP['tenantserver_db_info']['body'] = 'サーバが使用しているDBの情報を設定します。DBに接続しない場合は空欄にします。';
$HELP['tenantserver_db_user']['title'] = 'DB接続ユーザ';
$HELP['tenantserver_db_user']['body'] = 'DB接続用のユーザ/パスワードを設定します。';
$HELP['tenantserver_test_db']['title'] = 'DB接続テスト';
$HELP['tenantserver_test_db']['body'] = 'DB接続情報でDB接続をテストします。';
$HELP['tenantserver_new_btn']['title'] = '新規ボタン';
$HELP['tenantserver_new_btn']['body'] = '新規にサーバ情報を追加します。';
$HELP['tenantserver_edit_btn']['title'] = '編集ボタン';
$HELP['tenantserver_edit_btn']['body'] = '選択されているサーバ情報を編集します。<br>選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['tenantserver_del_btn']['title'] = '削除ボタン';
$HELP['tenantserver_del_btn']['body'] = '選択されているサーバ情報を削除します。<br />サーバ情報を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['tenantserver_ret_btn']['title'] = '戻るボタン';
$HELP['tenantserver_ret_btn']['body'] = 'テナントサーバ一覧へ戻ります。';
?>
