<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_menu3WidgetContainer.php 3438 2010-07-29 08:37:59Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseAdminWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_menuDb.php');

class admin_menu3WidgetContainer extends BaseAdminWidgetContainer
{
	protected $db;	// DB接続オブジェクト
	protected $sysDb;	// DB接続オブジェクト
	protected $cssFilePath;			// CSSファイル
	protected $themeFilePath;		// テーマファイル
	const DEFAULT_SITE_NAME = 'サイト名未設定';
	const DEFAULT_CSS_FILE = '/default.css';		// CSSファイル
	const THEME_CSS_FILE = '/ui/themes/sunny/jquery-ui-1.8.2.custom.css';		// テーマファイル

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new admin_menuDB();
		$this->sysDb = $this->gInstance->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		// システム制御画面のときはメニューを作成しないで終了
		if ($this->gPage->getSystemHandleMode() > 0){
			return;
		}
		
		if (!$this->gEnv->isSystemAdmin()) return;	// システム管理者以外の場合は終了
		
		$menu = $request->trimValueOf('menu');
		$openBy = $request->trimValueOf(M3_REQUEST_PARAM_OPEN_BY);		// ウィンドウオープンタイプ
		
		// ページIDを取得
		$pageSubId = $request->trimValueOf(M3_REQUEST_PARAM_PAGE_SUB_ID);
		
		// メニューの表示制御
		$menuStatus = $request->trimValueOf('showmenu');
		if (!empty($menuStatus)){
			if ($menuStatus == 'false'){
				$paramObj->showMenu = 0;	// メニューを表示するかどうか
			} else if ($menuStatus == 'true'){
				$paramObj->showMenu = 1;	// メニューを表示するかどうか
			}
			$ret = $this->updateWidgetParamObj($paramObj);
		}
		
		// タスクを取得
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		$selectedItemId = 0;			// 選択中の項目ID
		$selectedParemtItemId = 0;		// 選択中の項目の親項目ID
		if (!empty($task) && $this->db->getNavItemsByTask('admin_menu', $task, $row)){
			$selectedItemId = $row['ni_id'];
			$selectedParemtItemId = $row['ni_parent_id'];
		}
		
		// メニューを作成
		$menuInner = '';
		$subItemId = 'sb';
		
		// 「トップ」作成
		$menuInner .= '<li>';
		$menuInner .= '<a href="' . $this->getUrl($this->gEnv->getDefaultAdminUrl()) .'">トップ</a>&nbsp;&nbsp;|' . M3_NL;
		$menuInner .= str_repeat(' ', 4);
		$menuInner .= '<ul>' . M3_NL;
		$menuInner .= str_repeat(' ', 4);
		$menuInner .= '</ul>' . M3_NL;
		$menuInner .= '</li>' . M3_NL;
				
		// トップレベル項目を取得
		if ($this->db->getNavItems('admin_menu', 0, $rows)){
			$topMenuCount = count($rows);
			for ($i = 0; $i < $topMenuCount; $i++){
				if ($rows[$i]['ni_view_control'] == 0){		// 改行以外のとき
					$topId = $rows[$i]['ni_id'];
				
					// サブレベル取得
					$this->db->getNavItems('admin_menu', $topId, $subRows);
					// 初期表示画面
					if (count($subRows) > 0) $firstTask = $this->getUrl($this->gEnv->getDefaultAdminUrl() . '?task=' . $subRows[0]['ni_task_id']);
				
					// 「li」タグ
					$menuInner .= '<li>';
				
					// 「a」タグ
					// リンク先を作成。「_」で始まるタスクはリンクを作成しない
					$topLink = '#';
					$linkTask = $rows[$i]['ni_task_id'];
					if (strncmp($linkTask, '_', strlen('_')) != 0) $topLink = $this->getUrl($this->gEnv->getDefaultAdminUrl() . '?task=' . $linkTask);	// 起動タスクパラメータを設定
					$menuInner .= str_repeat(' ', 4);
					$menuInner .= '<a href="' . $topLink . '">' . $this->convertToDispString($rows[$i]['ni_name']) . '</a>&nbsp;&nbsp;|' . M3_NL;
				
					// 「ul」タグ
					$menuInner .= str_repeat(' ', 4);
					$menuInner .= '<ul>' . M3_NL;
				
					// 「li」タグ
					if (count($subRows) > 0){
						for ($l = 0; $l < count($subRows); $l++){
							$menuInner .= str_repeat(' ', 8);
							$menuInner .= '<li ';
							$menuInner .= '><a href="';
							$menuInner .= $this->getUrl($this->gEnv->getDefaultAdminUrl() . '?task=' . $subRows[$l]['ni_task_id']);	// 起動タスクパラメータを設定
							if (!empty($subRows[$l]['ni_param'])){		// パラメータが存在するときはパラメータを追加
								$menuInner .= '&' . M3_REQUEST_PARAM_OPERATION_TODO . '=' . urlencode($subRows[$l]['ni_param']);
							}
							$menuInner .= '" >' . $this->convertToDispString($subRows[$l]['ni_name']) . '</a></li>' . M3_NL;
						}
					}
					$menuInner .= str_repeat(' ', 4);
					$menuInner .= '</ul>' . M3_NL;
					$menuInner .= '</li>' . M3_NL;
				}
			}
		}
		$this->tmpl->addVar("menu", "menu_inner", $menuInner);
		$this->tmpl->addVar("menu", "widget_url", $this->getUrl($this->gEnv->getCurrentWidgetRootUrl()));	// ウィジェットのルートディレクトリ
		
		// メニューを表示
		//$showMenu = true;
		if ($menu == 'off'){	// メニュー非表示指定のとき
		} else if (!empty($openBy)){	// 別ウィンドウで表示のときは閉じるボタン表示
			$this->tmpl->setAttribute('closebutton', 'visibility', 'visible');
			
			// サーバ指定されている場合はサーバ名を設定
			$server = $request->trimValueOf(M3_REQUEST_PARAM_SERVER);
			if (!empty($server)){
				// 設定データを取得
				$ret = $this->sysDb->getServerById($server, $row);
				if ($ret){
					$serverName = 'サーバ名：' . $row['ts_name'];// サーバ名
					$this->tmpl->setAttribute('servername', 'visibility', 'visible');
					$this->tmpl->addVar("servername", "server_name", $this->convertToDispString($serverName));
				}
			}
		} else {	// メニュー表示のとき
			$showMenu = 0;		// メニューを表示するかどうか
			$paramObj = $this->getWidgetParamObj();
			if (!empty($paramObj)){
				$showMenu = $paramObj->showMenu;			// メニューを表示するかどうか
			}
		
			if (empty($task) && empty($pageSubId)){	// トップ画面のとき
				$this->tmpl->setAttribute('menuvisiblebutton', 'visibility', 'visible');
				if ($showMenu == 0){		// メニュー非表示のとき
					$this->tmpl->addVar("menuvisiblebutton", "url", $this->getUrl($this->gEnv->getDefaultAdminUrl() . '?showmenu=true'));
					$this->tmpl->addVar("menuvisiblebutton", "label", 'メニューバーを表示');
				} else {
					$this->tmpl->addVar("menuvisiblebutton", "url", $this->getUrl($this->gEnv->getDefaultAdminUrl() . '?showmenu=false'));
					$this->tmpl->addVar("menuvisiblebutton", "label", 'メニューバーを隠す');
				}
				$this->tmpl->addVar("menuvisiblebutton", "top_url", $this->getUrl($this->gEnv->getDefaultAdminUrl()));		// トップメニュー画面URL
				
				// 一般画面切り替えボタン
				$this->tmpl->addVar("menuvisiblebutton", "pc_url", $this->gEnv->getDefaultUrl());
				
				// サイト表示
				$siteName = $this->gEnv->getSiteName();
				if (empty($siteName)) $siteName = self::DEFAULT_SITE_NAME;
				$siteUrl = $this->gEnv->getRootUrl();
				$this->tmpl->addVar("menuvisiblebutton", "site_name", $siteName);
				$this->tmpl->addVar("menuvisiblebutton", "site", '<label><a href="#" onclick="previewSite(\'' . $siteUrl . '\');">' . $siteUrl . '</a></label>');
				
				// システムバージョン
				$this->tmpl->addVar("menuvisiblebutton", "system", '<label><a href="http://www.magic3.org">Magic3 ' . M3_SYSTEM_VERSION . '</a></label>');
			}
			if ($showMenu){
				$this->tmpl->setAttribute('menu', 'visibility', 'visible');
				
				$this->tmpl->addVar("menu", "top_url", $this->getUrl($this->gEnv->getDefaultAdminUrl()));		// トップメニュー画面URL
				$this->cssFilePath = $this->getUrl($this->gEnv->getCurrentWidgetCssUrl() . self::DEFAULT_CSS_FILE);		// CSSファイル
				$this->themeFilePath = $this->getUrl($this->gEnv->getRootUrl() . self::THEME_CSS_FILE);
			}
			
			// トップ画面に遷移するボタンを表示
			$this->tmpl->addVar("backbutton", "top_url", $this->getUrl($this->gEnv->getDefaultAdminUrl()));		// トップメニュー画面URL
			if ((!empty($task) || !empty($pageSubId)) && $showMenu == 0){
				$this->tmpl->setAttribute('backbutton', 'visibility', 'visible');
			}
		}
	}
	/**
	 * メニューを常時表示するかどうか
	 *
	 * @return bool		true=常時表示、false=表示しない
	 */
	function menubarAlwaysVisible()
	{
		return $this->db->menubarAlwaysVisible();
	}
	/**
	 * CSSファイルをHTMLヘッダ部に設定
	 *
	 * CSSファイルをHTMLのheadタグ内に追加出力する。
	 * _assign()よりも後に実行される。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。
	 * @return string 						CSS文字列。出力しない場合は空文字列を設定。
	 */
	function _addCssFileToHead($request, &$param)
	{
		if (empty($this->cssFilePath)){
			return array();
		} else {
			return array($this->cssFilePath, $this->themeFilePath);
		}
	}
}
?>
