<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: blog_mainWidgetContainer.php 3579 2010-09-10 08:54:51Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/blog_mainDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/blog_categoryDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/blog_commentDb.php');
require_once($gEnvManager->getCommonPath() . '/valueCheck.php');

class blog_mainWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $categoryDb;	// DB接続オブジェクト
	private $commentDb;			// DB接続オブジェクト
	private $currentDay;		// 現在日
	private $currentHour;		// 現在時間
	private $currentPageUrl;			// 現在のページURL
	private $langId;		// 言語
	private $isOutputComment;		// コメントを出力するかどうか
	private $isExistsViewData;				// 表示データがあるかどうか
	private $viewExtEntry;			// 続きを表示するかどうか
	private $isSystemManageUser;	// システム運用可能ユーザかどうか
	private $pageTitle;				// 画面タイトル、パンくずリスト用タイトル
	const CONTENT_TYPE = 'bg';
	const RECEIVE_COMMENT		= 'receive_comment';		// コメントを受け付けるかどうか
	const RECEIVE_TRACKBACK		= 'receive_trackback';		// トラックバックを受け付けるかどうか
	const ENTRY_VIEW_COUNT		= 'entry_view_count';			// 記事表示数
	const ENTRY_VIEW_ORDER		= 'entry_view_order';			// 記事表示方向
	const LINK_PAGE_COUNT		= 5;			// リンクページ数
	const MESSAGE_NO_ENTRY_TITLE = 'ブログ記事未登録';
	const MESSAGE_NO_ENTRY		= 'ブログ記事は登録されていません';				// ブログ記事が登録されていないメッセージ
	const MESSAGE_FIND_NO_ENTRY	= 'ブログ記事が見つかりません';
	const MESSAGE_EXT_ENTRY		= '続きを読む';					// 投稿記事に続きがある場合の表示
	const MESSAGE_EXT_ENTRY_PRE	= '…&nbsp;';							// 投稿記事に続きがある場合の表示
	const DEFAULT_VIEW_COUNT	= 10;				// デフォルトの表示記事数
	const ICON_SIZE = 16;		// アイコンのサイズ
	const EDIT_ICON_FILE = '/images/system/page_edit.png';		// 編集アイコン
	const NEW_ICON_FILE = '/images/system/page_add.png';		// 新規アイコン
	const CONFIG_ICON_FILE = '/images/system/config.png';		// 設定画面アイコン
	const DEFAULT_TITLE_SEARCH = '検索';		// 検索時のデフォルトタイトル
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new blog_mainDb();
		$this->categoryDb = new blog_categoryDb();
		$this->commentDb = new blog_commentDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$act = $request->trimValueOf('act');
		if ($act == 'search'){
			return 'search.tmpl.html';
		} else {
			return 'main.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		// 初期設定値
		$now = date("Y/m/d H:i:s");	// 現在日時
		$this->currentDay = date("Y/m/d");		// 日
		$this->currentHour = (int)date("H");		// 時間
		$this->currentPageUrl = $this->gEnv->createCurrentPageUrl();// 現在のページURL
		$this->langId = $this->gEnv->getCurrentLanguage();
		$sendButtonLabel = 'コメントを投稿';		// 送信ボタンラベル
		$sendStatus = 0;		// 送信状況
		$regUserId		= $this->gEnv->getCurrentUserId();			// 記事投稿ユーザ
		$regDt			= date("Y/m/d H:i:s");						// 投稿日時
		$this->isOutputComment = false;// コメントを出力するかどうか
		$title = '';		// 表示タイトル
		$message = '';			// ユーザ向けメッセージ
		$this->isSystemManageUser = $this->gEnv->isSystemManageUser();	// システム運用可能ユーザかどうか
		$this->pageTitle = '';		// 画面タイトル、パンくずリスト用タイトル
		
		// 定義値取得
		$entryViewCount	= $this->db->getConfig(self::ENTRY_VIEW_COUNT);// 記事表示数
		if (empty($entryViewCount)) $entryViewCount = self::DEFAULT_VIEW_COUNT;
		$entryViewOrder	= $this->db->getConfig(self::ENTRY_VIEW_ORDER);// 記事表示順
		$receiveComment = $this->db->getConfig(self::RECEIVE_COMMENT);		// コメントを受け付けるかどうか
		
		$act = $request->trimValueOf('act');
		$entryId = $request->trimValueOf('entryid');
		$startDt = $request->trimValueOf('start');
		$endDt = $request->trimValueOf('end');
		$year = $request->trimValueOf('year');		// 年指定
		$month = $request->trimValueOf('month');		// 月指定
		$day = $request->trimValueOf('day');		// 日指定
		$keyword = $request->trimValueOf('keyword');// 検索キーワード
		$category = $request->trimValueOf('category');		// カテゴリー
		// コメントの入力
		$title = $request->trimValueOf('title');
		$name = $request->trimValueOf('name');
		$email = $request->trimValueOf('email');
		$url = $request->trimValueOf('url');
		$body = $request->trimValueOf('body');
		// ページ番号
		$pageNo = $request->trimIntValueOf('page', '1');				// ページ番号
		
		$showDefault = false;			// デフォルト状態での表示
		$this->viewExtEntry = false;			// 続きを表示するかどうか
		if ($act == 'search'){			// 検索
			// キーワード検索のとき
			if (empty($keyword)){
				$message = '検索キーワードが入力されていません';
			} else {
				// 検索キーワードを記録
				$this->gInstance->getAnalyzeManager()->logSearchWord($this->gEnv->getCurrentWidgetId(), $keyword);
				
				// 総数を取得
				$totalCount = $this->db->searchEntryItemsCountByKeyword($now, $keyword, $this->langId);

				// リンク文字列作成、ページ番号調整
				$pageLink = $this->createPageLink($pageNo, $totalCount, $entryViewCount, $this->currentPageUrl . '&act=search&keyword=' . urlencode($keyword));
				
				// 記事一覧を表示
				$this->db->searchEntryItemsByKeyword($entryViewCount, $pageNo, $now, $keyword, $this->langId, array($this, 'searchItemsLoop'));
				
				if ($this->isExistsViewData){
					// ページリンクを埋め込む
					if (!empty($pageLink)){
						$this->tmpl->setAttribute('page_link', 'visibility', 'visible');		// リンク表示
						$this->tmpl->addVar("page_link", "page_link", $pageLink);
					}
					$message = '検索キーワード：' . $keyword;
				} else {	// 検索結果なしの場合
					$this->tmpl->setAttribute('entrylist', 'visibility', 'hidden');
					$message = self::MESSAGE_FIND_NO_ENTRY;
				}
			}
			$this->pageTitle = self::DEFAULT_TITLE_SEARCH;		// 画面タイトル、パンくずリスト用タイトル
		} else if ($act == 'view'){			// 記事を表示のとき
			// コメントを受け付けるときは、コメント入力欄を表示
			// ***** 記事を表示する前に呼び出す必要あり *****
			if (!empty($receiveComment)){
				$this->tmpl->setAttribute('entry_footer', 'visibility', 'visible');		// コメントへのリンク
			}
			if (!empty($category)){				// カテゴリー指定のとき
				// 総数を取得
				$totalCount = $this->db->getEntryItemsCountByCategory($now, $category, $this->langId);

				// リンク文字列作成、ページ番号調整
				$pageLink = $this->createPageLink($pageNo, $totalCount, $entryViewCount, $this->currentPageUrl . '&act=view&category=' . $category);
				
				// 記事一覧を表示
				$this->db->getEntryItemsByCategory($entryViewCount, $pageNo, $now, $category, $this->langId, $entryViewOrder, array($this, 'itemsLoop'));

				// タイトルの設定
				$ret = $this->categoryDb->getCategoryByCategoryId($category, $this->gEnv->getDefaultLanguage(), $row);
				if ($ret) $title = $row['bc_name'];
				
				// ブログ記事データがないときはデータなしメッセージ追加
				if ($this->isExistsViewData){
					// ページリンクを埋め込む
					if (!empty($pageLink)){
						$this->tmpl->setAttribute('page_link', 'visibility', 'visible');		// リンク表示
						$this->tmpl->addVar("page_link", "page_link", $pageLink);
					}
				} else {
					$title = self::MESSAGE_NO_ENTRY_TITLE;
					$message = self::MESSAGE_NO_ENTRY;			// ユーザ向けメッセージ
				}
			} else if (!empty($year) && !empty($month)){
				if (empty($day)){		// 月指定のとき
					$startDt = $year . '/' . $month . '/1';
					$endDt = $this->getNextMonth($year . '/' . $month) . '/1';
					
					// 総数を取得
					$totalCount = $this->db->getEntryItemsCount($now, $startDt, $endDt, $this->langId);

					// リンク文字列作成、ページ番号調整
					$pageLink = $this->createPageLink($pageNo, $totalCount, $entryViewCount, $this->currentPageUrl . '&act=view&year=' . $year . '&month=' . $month);
				
					// 記事一覧作成
					$this->db->getEntryItems($entryViewCount, $pageNo, $now, $entryId, $startDt/*期間開始*/, $endDt/*期間終了*/, $this->langId, $entryViewOrder, array($this, 'itemsLoop'));

					if ($this->isExistsViewData){
						// ページリンクを埋め込む
						if (!empty($pageLink)){
							$this->tmpl->setAttribute('page_link', 'visibility', 'visible');		// リンク表示
							$this->tmpl->addVar("page_link", "page_link", $pageLink);
						}
					}
					// 年月の表示
					$title = $year . '年 ' . $month . '月';
					
					// ブログ記事データがないときはデータなしメッセージ追加
					if (!$this->isExistsViewData){
						$message = self::MESSAGE_NO_ENTRY;			// ユーザ向けメッセージ
					}
				} else {
					$startDt = $year . '/' . $month . '/' . $day;
					$endDt = $this->getNextDay($year . '/' . $month . '/' . $day);
					
					// 総数を取得
					$totalCount = $this->db->getEntryItemsCount($now, $startDt, $endDt, $this->langId);

					// リンク文字列作成、ページ番号調整
					$pageLink = $this->createPageLink($pageNo, $totalCount, $entryViewCount, $this->currentPageUrl . '&act=view&year=' . $year . '&month=' . $month . '&day=' . $day);
					
					// 記事一覧作成
					$this->db->getEntryItems($entryViewCount, $pageNo, $now, $entryId, $startDt/*期間開始*/, $endDt/*期間終了*/, $this->langId, $entryViewOrder, array($this, 'itemsLoop'));
					
					if ($this->isExistsViewData){
						// ページリンクを埋め込む
						if (!empty($pageLink)){
							$this->tmpl->setAttribute('page_link', 'visibility', 'visible');		// リンク表示
							$this->tmpl->addVar("page_link", "page_link", $pageLink);
						}
					}
					
					// 年月日の表示
					$title = $year . '年 ' . $month . '月 ' . $day . '日';
					
					// ブログ記事データがないときはデータなしメッセージ追加
					if (!$this->isExistsViewData){
						$message = self::MESSAGE_NO_ENTRY;			// ユーザ向けメッセージ
					}
				}
			}
			$this->pageTitle = $title;		// カテゴリー名を画面タイトルにする
		} else if ($act == 'checkcomment'){		// コメント確認のとき
			// 入力チェック
			$this->checkInput($body, 'コメント内容');
			$this->checkMailAddress($email, 'Eメール', true);

			// エラーなしの場合は確認画面表示
			if ($this->getMsgCount() == 0){
				// ハッシュキー作成
				$postTicket = md5(time() . $this->gAccess->getAccessLogSerialNo());
				$request->setSessionValue(M3_SESSION_POST_TICKET, $postTicket);		// セッションに保存
				$this->tmpl->addVar("_widget", "ticket", $postTicket);				// 画面に書き出し
				
				$this->setGuidanceMsg('この内容でコメントを投稿しますか?');
				
				// 入力の変更不可
				$sendButtonLabel = 'コメントを投稿';		// 送信ボタンラベル
				$sendStatus = 1;// 送信状況を「確定」に変更
				$this->tmpl->addVar("add_comment", "title_disabled", 'readonly');
				$this->tmpl->addVar("add_comment", "name_disabled", 'readonly');
				$this->tmpl->addVar("add_comment", "email_disabled", 'readonly');
				$this->tmpl->addVar("add_comment", "url_disabled", 'readonly');
				$this->tmpl->addVar("add_comment", "body_disabled", 'readonly');
				$this->tmpl->setAttribute('cancel_button', 'visibility', 'visible');		// キャンセルボタン表示
				
				// ### コメント入力欄の表示 ###
				$this->tmpl->setAttribute('add_comment', 'visibility', 'visible');// コメント入力欄表示
				$this->tmpl->addVar("add_comment", "send_button_label", $sendButtonLabel);// 送信ボタンラベル
				$this->tmpl->addVar("add_comment", "send_status", $sendStatus);// 送信状況
				$this->tmpl->setAttribute('entrylist', 'visibility', 'hidden');// 記事表示停止
			} else {
				$showDefault = true;			// デフォルト状態での表示
			}
			
			// 入力値を戻す
			$this->tmpl->addVar("add_comment", "title", $this->convertToDispString($title));
			$this->tmpl->addVar("add_comment", "name", $this->convertToDispString($name));
			$this->tmpl->addVar("add_comment", "email", $this->convertToDispString($email));
			$this->tmpl->addVar("add_comment", "url", $this->convertToDispString($url));
			$this->tmpl->addVar("add_comment", "body", $this->convertToDispString($body));
			$this->tmpl->addVar("_widget", "entry_id", $this->convertToDispString($entryId));		// 記事ID
		} else if ($act == 'sendcomment'){	// コメント受信のとき
			$postTicket = $request->trimValueOf('ticket');		// POST確認用
			$ret = false;
			if (!empty($entryId) && !empty($body) &&
				!empty($postTicket) && $postTicket == $request->getSessionValue(M3_SESSION_POST_TICKET)){		// 正常なPOST値のとき
				// コメントを保存
				$ret = $this->commentDb->addCommentItem($entryId, $this->langId, $title, $body, $url, $name, $email, $regUserId, $regDt, $newSerial);
			}
			if ($ret){
				$this->setGuidanceMsg('コメントを投稿しました');
			} else {
				$this->setUserErrorMsg('コメントの投稿に失敗しました');
			}
			$showDefault = true;			// デフォルト状態での表示
			$request->unsetSessionValue(M3_SESSION_POST_TICKET);		// セッション値をクリア
		} else if ($act == 'sendcancel'){	// コメントキャンセルのとき
			$showDefault = true;			// デフォルト状態での表示
		} else {
			$showDefault = true;			// デフォルト状態での表示
		}
		// ##### デフォルトの表示では、最新のn件の記事を表示または、記事ID指定で1つの記事を表示
		if ($showDefault){
			// コメントを受け付けるときは、コメント入力欄を表示
			if (!empty($receiveComment)){
				if (empty($entryId)){		
					$this->tmpl->setAttribute('entry_footer', 'visibility', 'visible');		// コメントへのリンク
				} else {		// 記事ID指定の場合のみコメント入力可能
					$this->isOutputComment = true;// コメントを出力するかどうか
					
					$this->tmpl->setAttribute('show_comment', 'visibility', 'visible');		// 既存コメントを表示
					$this->tmpl->addVar("_widget", "entry_id", $entryId);		// 記事を指定
					
					// ### コメント入力欄の表示 ###
					$ret = $this->db->getEntryItem($entryId, $this->langId, $row);
					if ($ret && !empty($row['be_receive_comment'])){		// コメントを受け付ける場合のみ表示
						$this->tmpl->setAttribute('add_comment', 'visibility', 'visible');
						$this->tmpl->addVar("add_comment", "send_button_label", $sendButtonLabel);// 送信ボタンラベル
						$this->tmpl->addVar("add_comment", "send_status", $sendStatus);// 送信状況
					}
				}
			}
			if (empty($entryId)){
				// 総数を取得
				$totalCount = $this->db->getEntryItemsCount($now, $startDt, $endDt, $this->langId);

				// リンク文字列作成、ページ番号調整
				$pageLink = $this->createPageLink($pageNo, $totalCount, $entryViewCount, $this->currentPageUrl);
				
				// 記事一覧作成
				$this->db->getEntryItems($entryViewCount, $pageNo, $now, 0/* 期間で指定 */, $startDt/*期間開始*/, $endDt/*期間終了*/, $this->langId, $entryViewOrder, array($this, 'itemsLoop'));
				
				if ($this->isExistsViewData){
					// ページリンクを埋め込む
					if (!empty($pageLink)){
						$this->tmpl->setAttribute('page_link', 'visibility', 'visible');		// リンク表示
						$this->tmpl->addVar("page_link", "page_link", $pageLink);
					}
				}
			} else {
				$this->viewExtEntry = true;			// 記事ID指定のときは続き(全文)を表示
				$this->db->getEntryItems($entryViewCount, $pageNo, $now, $entryId, $startDt/*期間開始*/, $endDt/*期間終了*/, $this->langId, $entryViewOrder, array($this, 'itemsLoop'));
				
				// 記事がないときはコメントを隠す
				if (!$this->isExistsViewData){
					$this->tmpl->setAttribute('entrylist', 'visibility', 'hidden');
					$this->tmpl->setAttribute('add_comment', 'visibility', 'hidden');
				}
			}
			
			// 年月日の表示
			// ブログ記事データがないときはデータなしメッセージ追加
			if (!$this->isExistsViewData){
				$title = self::MESSAGE_NO_ENTRY_TITLE;
				$message = self::MESSAGE_NO_ENTRY;			// ユーザ向けメッセージ
			}
		}
		// HTMLサブタイトルを設定
		$this->gPage->setHeadSubTitle($this->pageTitle);
		
		// タイトルの設定
		if (!empty($title)){
			$this->tmpl->setAttribute('show_title', 'visibility', 'visible');		// 年月表示
			$this->tmpl->addVar("show_title", "title", $this->convertToDispString($title));
		}
		
		// メッセージを表示
		if (!empty($message)){
			$this->tmpl->setAttribute('message', 'visibility', 'visible');
			$this->tmpl->addVar("message", "message", $this->convertToDispString($message));
		}
		
		// 運用可能ユーザの場合は編集用ボタンを表示
		if ($this->isSystemManageUser && $act != 'search'){		// 検索画面以外
			// 共通ボタン作成
			$buttonList = '';
			
			// 新規作成ボタン
			$iconUrl = $this->gEnv->getRootUrl() . self::NEW_ICON_FILE;		// 新規アイコン
			$iconTitle = '新規';
			$editImg = '<img src="' . $this->getUrl($iconUrl) . '" width="' . self::ICON_SIZE . '" height="' . self::ICON_SIZE . '" border="0" alt="' . $iconTitle . '" title="' . $iconTitle . '" />';
			$buttonList .= '<span style="line-height:0;"><a href="javascript:void(0);" onclick="editEntry(0);">' . $editImg . '</a></span>';
			
			// 設定画面表示ボタン
			/*
			$iconUrl = $this->gEnv->getRootUrl() . self::CONFIG_ICON_FILE;		// 設定アイコン
			$iconTitle = 'ブログ設定';
			$editImg = '<img src="' . $this->getUrl($iconUrl) . '" width="' . self::ICON_SIZE . '" height="' . self::ICON_SIZE . '" border="0" alt="' . $iconTitle . '" title="' . $iconTitle . '" />';
			$buttonList .= '<span style="line-height:0;"><a href="javascript:void(0);" onclick="showConfig();">' . $editImg . '</a></span>';
			*/
			
			$this->tmpl->setAttribute('button_list', 'visibility', 'visible');
			$this->tmpl->addVar("button_list", "button_list", $buttonList);
			
			// 設定画面表示用のスクリプトを埋め込む
			$editUrl = $this->getConfigAdminUrl('openby=simple&task=entry_detail');
			$configUrl = $this->getConfigAdminUrl('openby=other');
			$this->tmpl->setAttribute('admin_script', 'visibility', 'visible');
			$this->tmpl->addVar("admin_script", "edit_url", $editUrl);
			$this->tmpl->addVar("admin_script", "config_url", $configUrl);
		}
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function itemsLoop($index, $fetchedRow)
	{
		// 参照ビューカウントを更新
		if (!$this->gEnv->isSystemManageUser()){		// システム運用者以上の場合はカウントしない
			$this->gInstance->getAnalyzeManager()->updateContentViewCount(self::CONTENT_TYPE, $fetchedRow['be_serial'], $this->currentDay, $this->currentHour);
		}

		$entryId = $fetchedRow['be_id'];// 記事ID
		$title = $fetchedRow['be_name'];// タイトル
		$date = $fetchedRow['be_regist_dt'];// 日付
		$showComment = $fetchedRow['be_show_comment'];				// コメントを表示するかどうか

		// ページタイトルの設定
		if (empty($this->pageTitle)) $this->pageTitle = $title;		// 画面タイトル、パンくずリスト用タイトル
		
		// コメントを取得
		$commentCount = $this->commentDb->getCommentCountByEntryId($entryId, $this->langId);	// コメント総数
		if ($this->isOutputComment){// コメントを出力のとき
			// コメントの内容を取得
			$ret = $this->commentDb->getCommentByEntryId($entryId, $this->langId, $row);
			if ($ret){
				$this->tmpl->clearTemplate('commentlist');
				for ($i = 0; $i < count($row); $i++){
					$userName = $this->convertToDispString($row[$i]['bo_user_name']);	// 投稿ユーザは入力値を使用
					$url = $this->convertToDispString($row[$i]['bo_url']);
					$commentInfo = $this->convertToDispString($row[$i]['bo_regist_dt']) . '&nbsp;&nbsp;' . $userName;
					if (!empty($url)) $commentInfo .= '<br />' . $url;
					$comment = $this->convertToPreviewText($this->convertToDispString($row[$i]['bo_html']));		// 改行コードをbrタグに変換
					$commentRow = array(
						'comment_title'		=> $this->convertToDispString($row[$i]['bo_name']),			// コメントタイトル
						'comment'		=> $comment,			// コメント内容
						'user_name'		=> $userName,			// 投稿ユーザ名
						'comment_info'	=> $commentInfo						// コメント情報
					);
					$this->tmpl->addVars('commentlist', $commentRow);
					$this->tmpl->parseTemplate('commentlist', 'a');
				}
			} else {	// コメントなしのとき
				$this->tmpl->clearTemplate('commentlist');
				$commentRow = array(
					'comment'		=> 'コメントはありません',			// コメント内容
					'comment_info'	=> ''						// コメント情報
				);
				$this->tmpl->addVars('commentlist', $commentRow);
				$this->tmpl->parseTemplate('commentlist', 'a');
			}
		}
		
		// 記事へのリンクを生成
		$linkUrl = $this->getUrl($this->gEnv->getDefaultUrl() . '?'. M3_REQUEST_PARAM_BLOG_ENTRY_ID . '=' . $entryId, true/*リンク用*/);
		$link = '<div><a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >コメント(' . $commentCount . ')</a></div>';
		
		// HTMLを出力(出力内容は特にエラーチェックしない)
		$entryText = $fetchedRow['be_html'];
		if ($this->viewExtEntry){			// 続きを表示するかどうか
			if (!empty($fetchedRow['be_html_ext'])) $entryText = $fetchedRow['be_html_ext'];// 続きがある場合は続きを出力
			$entryText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->getUrl($this->gEnv->getRootUrl()), $entryText);// アプリケーションルートを変換
		} else {
			// 続きがある場合はリンクを付加
			$entryText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->getUrl($this->gEnv->getRootUrl()), $entryText);// アプリケーションルートを変換
			if (!empty($fetchedRow['be_html_ext'])){
				$entryText .= self::MESSAGE_EXT_ENTRY_PRE . '<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >' . self::MESSAGE_EXT_ENTRY . '</a>';
			}
		}

		// ##### 記事のフッター部 #####
		// コメントを表示しないときはリンクを表示しない
		if (empty($showComment)) $link = '';
		$this->tmpl->clearTemplate('entry_footer');
		$row = array(
//			'permalink' => $this->convertUrlToHtmlEntity($linkUrl),	// パーマリンク
			'link' => $link		// コメントへのリンク
		);
		$this->tmpl->addVars('entry_footer', $row);
		$this->tmpl->parseTemplate('entry_footer', 'a');
		
		// コンテンツ編集権限がある場合はボタンを表示
		$buttonList = '';
		if ($this->isSystemManageUser){
			$iconUrl = $this->gEnv->getRootUrl() . self::EDIT_ICON_FILE;		// 編集アイコン
			$iconTitle = '編集';
			$editImg = '<img src="' . $this->getUrl($iconUrl) . '" width="' . self::ICON_SIZE . '" height="' . self::ICON_SIZE . '" border="0" alt="' . $iconTitle . '" title="' . $iconTitle . '" />';
			$buttonList = '<span style="line-height:0;"><a href="javascript:void(0);" onclick="editEntry(' . $fetchedRow['be_serial'] . ');">' . $editImg . '</a></span><br />';
			//$buttonList = '<span style="line-height:0;"><a onclick="editEntry(' . $fetchedRow['be_serial'] . ');">' . $editImg . '</a></span><br />';
		}

		$row = array(
			'permalink' => $this->convertUrlToHtmlEntity($linkUrl),	// パーマリンク
			'title' => $title,
			'date' => $date,			// 日付
			'entry' => $entryText,	// 投稿記事
			'button_list' => $buttonList	// 記事編集ボタン
		);
		$this->tmpl->addVars('entrylist', $row);
		$this->tmpl->parseTemplate('entrylist', 'a');
		$this->isExistsViewData = true;				// 表示データがあるかどうか
		return true;
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function searchItemsLoop($index, $fetchedRow)
	{
		// タイトルを設定
		$title = $fetchedRow['be_name'];
		
		// 記事へのリンクを生成
		//$linkUrl = $this->currentPageUrl . '&entryid=' . $fetchedRow['be_id'];
		$linkUrl = $this->getUrl($this->gEnv->getDefaultUrl() . '?'. M3_REQUEST_PARAM_BLOG_ENTRY_ID . '=' . $fetchedRow['be_id'], true/*リンク用*/);
		$link = '<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >' . $title . '</a>';
		
		// 日付
		$date = $fetchedRow['be_regist_dt'];

		// HTMLを出力(出力内容は特にエラーチェックしない)
		// 続きがある場合はリンクを付加
		$entryText = $fetchedRow['be_html'];
		$entryText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->getUrl($this->gEnv->getRootUrl()), $entryText);// アプリケーションルートを変換
		if (!empty($fetchedRow['be_html_ext'])){
			$entryText .= self::MESSAGE_EXT_ENTRY_PRE . '<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >' . self::MESSAGE_EXT_ENTRY . '</a>';
		}

		$row = array(
			'title' => $link,			// リンク付きタイトル
			'date' => $date,			// 日付
			'entry' => $entryText	// 投稿記事
		);
		$this->tmpl->addVars('entrylist', $row);
		$this->tmpl->parseTemplate('entrylist', 'a');
		$this->isExistsViewData = true;				// 表示データがあるかどうか
		return true;
	}
	/**
	 * ページリンク作成
	 *
	 * @param int $pageNo			ページ番号(1～)。ページ番号が範囲外にある場合は自動的に調整
	 * @param int $totalCount		総項目数
	 * @param int $viewItemCount	1ページあたりの項目数
	 * @param string $baseUrl		リンク用のベースURL
	 * @return string				リンクHTML
	 */
	function createPageLink(&$pageNo, $totalCount, $viewItemCount, $baseUrl)
	{
		// 表示するページ番号の修正
		$pageCount = (int)(($totalCount -1) / $viewItemCount) + 1;		// 総ページ数
		if ($pageNo < 1) $pageNo = 1;
		if ($pageNo > $pageCount) $pageNo = $pageCount;

		// ページング用リンク作成
		$pageLink = '';
		if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
			//for ($i = 1; $i <= $pageCount; $i++){
			// ページ数1から「LINK_PAGE_COUNT」までのリンクを作成
			$maxPageCount = $pageCount < self::LINK_PAGE_COUNT ? $pageCount : self::LINK_PAGE_COUNT;
			for ($i = 1; $i <= $maxPageCount; $i++){
				if ($i == $pageNo){
					$link = '&nbsp;' . $i;
				} else {
					$linkUrl = $this->getUrl($baseUrl . '&page=' . $i, true/*リンク用*/);
					$link = '&nbsp;<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >' . $i . '</a>';
				}
				$pageLink .= $link;
			}
			// 残りは「...」表示
			if ($pageCount > self::LINK_PAGE_COUNT) $pageLink .= '&nbsp;...';
		}
		if ($pageNo > 1){		// 前ページがあるとき
			$linkUrl = $this->getUrl($baseUrl . '&page=' . ($pageNo -1), true/*リンク用*/);
			$link = '<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >前へ</a>';
			$pageLink = $link . $pageLink;
		}
		if ($pageNo < $pageCount){		// 次ページがあるとき
			$linkUrl = $this->getUrl($baseUrl . '&page=' . ($pageNo +1), true/*リンク用*/);
			$link = '&nbsp;<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >次へ</a>';
			$pageLink .= $link;
		}
		return $pageLink;
	}
}
?>
