<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: m_googlemapsWidgetContainer.php 3734 2010-10-26 02:47:54Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class m_googlemapsWidgetContainer extends BaseWidgetContainer
{
	private $langId;		// 現在の言語
	const DEFAULT_CONFIG_ID = 0;
	const DEFAULT_TITLE = 'Googleマップ';			// デフォルトのウィジェットタイトル
	const MIN_ZOOM_LEVEL = 1;			// ズーム値最小
	const MAX_ZOOM_LEVEL = 21;			// ズーム値最大
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		$this->langId = $this->gEnv->getCurrentLanguage();
		
		// 定義ID取得
		$configId = $this->gEnv->getCurrentWidgetConfigId();
		if (empty($configId)) $configId = self::DEFAULT_CONFIG_ID;
		
		// パラメータオブジェクトを取得
		$targetObj = $this->getWidgetParamObjByConfigId($configId);
		if (empty($targetObj)){ 		// 定義データが取得できないとき
			$this->cancelParse();// 出力しない
			return;
		}
		
		// 初期値取得
		$name = $targetObj->name;// 定義名
		$width	= $targetObj->width;		// 幅
		$height	= $targetObj->height;		// 高さ
		$lat	= $targetObj->lat;		// 緯度
		$lng	= $targetObj->lng;		// 経度
		$markerLat	= $targetObj->markerLat;		// マーカー緯度
		$markerLng	= $targetObj->markerLng;		// マーカー経度
		$zoom	= intval($targetObj->zoom);		// ズームレベル
		$showMarker = $targetObj->showMarker;		// マーカーを表示するかどうか
		$alt	= $targetObj->alt;		// 代替テキスト
		
		// 共通データ取得
		$paramObj = $this->getWidgetParamObj();
		if (!empty($paramObj)){
			$key	= $paramObj->key;		// Googleマップ利用キー
		}
		// URLからパラメータを取得
		$value	= $request->trimValueOf('zoom');		// ズームレベル
		if (!empty($value)) $zoom = intval($value);
		
		// 値の修正
		if ($zoom < self::MIN_ZOOM_LEVEL) $zoom = self::MIN_ZOOM_LEVEL;
		if ($zoom > self::MAX_ZOOM_LEVEL) $zoom = self::MAX_ZOOM_LEVEL;
		
		// 画像URL作成
		$url = 'http://maps.google.com/staticmap?center=' . $lat . ',' . $lng . '&zoom=' . $zoom . '&size=' . $width . 'x' . $height . '&key=' . $key;
		if ($showMarker){// マーカー表示
			$url .= '&markers=' . $markerLat . ',' . $markerLng;
		}
		$option = 'width="' . $width . '" height="' . $height . '" ';
		if (!empty($alt)) $option .= 'alt="' . $this->convertToDispString($alt) . '" ';
		
		// 地図操作用URL作成
		$zoomSmall = $zoom -1;
		if ($zoomSmall < self::MIN_ZOOM_LEVEL) $zoomSmall = self::MIN_ZOOM_LEVEL;
		$smallUrlLink = $this->convertUrlToHtmlEntity($this->getUrl($this->gEnv->createCurrentPageUrlForMobile('zoom=' . $zoomSmall)));
		$zoomLarge = $zoom +1;
		if ($zoomLarge > self::MAX_ZOOM_LEVEL) $zoomLarge = self::MAX_ZOOM_LEVEL;
		$largeUrlLink = $this->convertUrlToHtmlEntity($this->getUrl($this->gEnv->createCurrentPageUrlForMobile('zoom=' . $zoomLarge)));
		
		// 表示データ埋め込み
		$this->tmpl->addVar("_widget", "url",	$url);
		$this->tmpl->addVar("_widget", "option",	$option);
		$this->tmpl->addVar("_widget", "url_small",	$smallUrlLink);
		$this->tmpl->addVar("_widget", "url_large",	$largeUrlLink);
	}
	/**
	 * ウィジェットのタイトルを設定
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						ウィジェットのタイトル名
	 */
	function _setTitle($request, &$param)
	{
		return self::DEFAULT_TITLE;
	}
}
?>
