<?php
/**
 * index.php用共通定義クラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2011 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: photo_mainCommonDef.php 4340 2011-09-23 00:47:01Z fishbone $
 * @link       http://www.magic3.org
 */
 
class photo_mainCommonDef
{
	const THUMBNAIL_DIR = '/widgets/photo/image';		// 画像格納ディレクトリ
	const PHOTO_DIR = '/etc/photo';		// マスター画像格納ディレクトリ
	const DEFAULT_THUMBNAIL_SIZE = 128;		// サムネール画像サイズ
	const DEFAULT_IMAGE_EXT = 'jpg';			// 画像ファイルのデフォルト拡張子
	const DEFAULT_PUBLIC_IMAGE_SIZE = 450;		// 一般表示用画像(ウォータマーク入り画像)の縦または横の最大サイズ
	const BUTTON_ICON_SIZE = 16;				// ボタン用アイコンサイズ
	const REF_CONTENT_TYPE = 'pt';		// 参照数カウント用
	
	/**
	 * サムネール画像のパスを取得
	 *
	 * @param string $photoId		画像ID
	 * @return string				画像パス
	 */
	static function getThumbnailPath($photoId)
	{
		global $gEnvManager;
		
		return $gEnvManager->getResourcePath() . self::THUMBNAIL_DIR . '/' . $photoId . '_' . self::DEFAULT_THUMBNAIL_SIZE . '.' . self::DEFAULT_IMAGE_EXT;
	}
	/**
	 * サムネール画像のURLを取得
	 *
	 * @param string $photoId		画像ID
	 * @return string				画像パス
	 */
	static function getThumbnailUrl($photoId)
	{
		global $gEnvManager;
		
		return $gEnvManager->getResourceUrl() . self::THUMBNAIL_DIR . '/' . $photoId . '_' . self::DEFAULT_THUMBNAIL_SIZE . '.' . self::DEFAULT_IMAGE_EXT;
	}
	/**
	 * 公開画像のパスを取得
	 *
	 * @param string $photoId		画像ID
	 * @return string				画像パス
	 */
	static function getPublicImagePath($photoId)
	{
		global $gEnvManager;
		
		return $gEnvManager->getResourcePath() . self::THUMBNAIL_DIR . '/' . $photoId . '.' . self::DEFAULT_IMAGE_EXT;
	}
	/**
	 * 公開画像のURLを取得
	 *
	 * @param string $photoId		画像ID
	 * @return string				画像パス
	 */
	static function getPublicImageUrl($photoId)
	{
		global $gEnvManager;
		
		return $gEnvManager->getResourceUrl() . self::THUMBNAIL_DIR . '/' . $photoId . '.' . self::DEFAULT_IMAGE_EXT;
	}
	/**
	 * 画像取得
	 *
	 * @param string $photoId		画像ID
	 * @param object $db			DBオブジェクト
	 * @return						なし
	 */
	static function getImage($photoId, $db)
	{
		global $gEnvManager;
		global $gPageManager;
		
		// ページ作成処理中断
		$gPageManager->abortPage();

		$ret = $db->getPhotoInfo($photoId, $row);
		if ($ret){
			header('Content-type: ' . $row['ht_mime_type']);// 画像タイプ
			// キャッシュの設定
			header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');// 過去の日付
			header('Cache-Control: no-store, no-cache, must-revalidate');// HTTP/1.1
			header('Cache-Control: post-check=0, pre-check=0');
			header('Pragma: no-cache');

			$imagePath = $gEnvManager->getIncludePath() . self::PHOTO_DIR . $row['ht_dir'] . DIRECTORY_SEPARATOR . $row['ht_public_id'];
			readfile($imagePath);
		}
	
		// システム強制終了
		$gPageManager->exitSystem();
	}
	/**
	 * 画像サイズ調整
	 *
	 * @param int $width		画像横幅
	 * @param int $height		画像高さ
	 * @param int $maxSize		最大サイズ
	 * @return					なし
	 */
	static function adjustImageSize(&$width, &$height, $maxSize)
	{
		// 画像サイズ
		if ($width > $height){
			$height = ($height / $width) * $maxSize;
			$width = $maxSize;
		} else {
			$width = ($width / $height) * $maxSize;
			$height = $maxSize;
		}
	}
	/**
	 * フォトアルバム定義値をDBから取得
	 *
	 * @param object $db	DBオブジェクト
	 * @return array		取得データ
	 */
	static function loadConfig($db)
	{
		$retVal = array();

		// フォトアルバム定義を読み込み
		$ret = $db->getAllConfig($rows);
		if ($ret){
			// 取得データを連想配列にする
			$configCount = count($rows);
			for ($i = 0; $i < $configCount; $i++){
				$key = $rows[$i]['hg_id'];
				$value = $rows[$i]['hg_value'];
				$retVal[$key] = $value;
			}
		}
		return $retVal;
	}
}
?>
