<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2011 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: photo_mainTopWidgetContainer.php 4342 2011-09-23 01:33:57Z fishbone $
 * @link       http://www.magic3.org
 */
//require_once($gEnvManager->getCurrentWidgetContainerPath() . '/photo_mainCommonDef.php');
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/photo_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/photo_mainDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/photo_categoryDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/photo_commentDb.php');

class photo_mainTopWidgetContainer extends photo_mainBaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $photoArray;	// 取得した写真
	private $notfoundThumbnailUrl;		// サムネール画像が見つからない場合の画像
	private $viewCount;		// 表示項目数
	private $shortTitleLength;		// 略式写真タイトルの長さ
	private $photoId;		// 写真ID
	private $startNo;		// 先頭項目番号
	private $currentDay;		// 現在日
	private $currentHour;		// 現在時間
	const CSS_FILE = '/style.css';		// CSSファイルのパス
	const NOT_FOUND_ICON_FILE = 		'/images/system/notfound128.gif';		// 写真が見つからないアイコン
	const BACK_ICON_FILE = 		'/images/system/back.png';		// 「戻る」アイコン
	const PREV_ICON_FILE = 		'/images/system/previous.png';		// 「前へ」アイコン
	const NEXT_ICON_FILE = 		'/images/system/next.png';		// 「次へ」アイコン
	const LOAD_ICON_FILE =				'/loader.gif';			// ロード中アイコン
	const LINK_PAGE_COUNT		= 10;			// リンクページ数
	const BACK_BUTTON_TITLE = '戻る';		// 「戻る」ボタンタイトル
	const PREV_BUTTON_TITLE = '前へ';		// 「前へ」ボタンタイトル
	const NEXT_BUTTON_TITLE = '次へ';		// 「次へ」ボタンタイトル
	// DB定義値
	const CF_PHOTO_LIST_ITEM_COUNT =	'photo_list_item_count';			// 写真一覧表示項目数
	const CF_PHOTO_TITLE_SHORT_LENGTH = 'photo_title_short_length';// 略式写真タイトルの長さ
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
//		$this->db = new photo_mainDb();
		$this->notfoundThumbnailUrl = $this->getUrl($this->gEnv->getRootUrl() . self::NOT_FOUND_ICON_FILE);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$this->photoId = $request->trimValueOf(M3_REQUEST_PARAM_PHOTO_ID);
		if (empty($this->photoId)) $this->photoId = $request->trimValueOf(M3_REQUEST_PARAM_PHOTO_ID_SHORT);		// 略式ID
		
		$act = $request->trimValueOf('act');
		if ($act == 'search'){
			return 'main_list.tmpl.html';
		} else {
			if (empty($this->photoId)){
				return 'main_list.tmpl.html';
			} else {
				return 'photo_detail.tmpl.html';
			}
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		// 初期設定値
		$now = date("Y/m/d H:i:s");	// 現在日時
		$this->currentDay = date("Y/m/d");		// 日
		$this->currentHour = (int)date("H");		// 時間
		$this->currentPageUrl = $this->gEnv->createCurrentPageUrl();// 現在のページURL
		
		$this->viewCount = self::$_configArray[self::CF_PHOTO_LIST_ITEM_COUNT];	// 表示項目数
		$this->shortTitleLength = self::$_configArray[self::CF_PHOTO_TITLE_SHORT_LENGTH];		// 略式写真タイトルの長さ
		
		// POST,GET値取得
		$act = $request->trimValueOf('act');

		if ($act == 'getlist'){		// 画像一覧Ajax取得
			$this->getList($request);
		} else if ($act == 'getdetail'){// 画像詳細Ajax取得
			$this->getDetail($request);
		} else {		// 詳細、一覧画面
			if (empty($this->photoId)){		
				$this->showList($request);
			} else {// 詳細画面
				$this->showDetail($request);
			}
		}
	}
	/**
	 * CSSファイルをHTMLヘッダ部に設定
	 *
	 * CSSファイルをHTMLのheadタグ内に追加出力する。
	 * _assign()よりも後に実行される。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。
	 * @return string 						CSS文字列。出力しない場合は空文字列を設定。
	 */
	function _addCssFileToHead($request, &$param)
	{
		return $this->getUrl($this->gEnv->getCurrentWidgetCssUrl() . self::CSS_FILE);
	}
	/**
	 * 一覧画面表示
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function showList($request)
	{
		$pageNo = $request->trimIntValueOf(M3_REQUEST_PARAM_PAGE_NO, '1');				// ページ番号

		// 写真数を取得
		$totalCount = self::$_mainDb->searchPhotoItemCount($this->_langId, null/*開始日時*/, null/*終了日時*/, null/*カテゴリー*/, ''/*キーワード*/);
		
		// リンク文字列作成、ページ番号調整
		$this->calcPage($pageNo, $totalCount, $this->viewCount, $pageCount, $startNo, $endNo);
		
		if ($startNo > $endNo) $this->setUserErrorMsg('画像が見つかりません');
		
		// ページリンク作成
		$pageLink = $this->createPageLink($pageNo, $pageCount, self::LINK_PAGE_COUNT, $this->gEnv->createCurrentPageUrl());
		if (!empty($pageLink)){
			$this->tmpl->setAttribute('page_link_top', 'visibility', 'visible');		// リンク表示
			$this->tmpl->setAttribute('page_link_bottom', 'visibility', 'visible');		// リンク表示
			$this->tmpl->addVar("page_link_top", "page_link", $pageLink);
			$this->tmpl->addVar("page_link_bottom", "page_link", $pageLink);
		}
		
		// AJAX用URL
		$ajaxUrl = 'act=getlist&page=' . $pageNo;
		
		// 画面埋め込みデータ
		$this->tmpl->addVar("_widget", "photo_count", $this->convertToDispString($this->viewCount));
		$this->tmpl->addVar("_widget", "load_icon_url", $this->getUrl($this->gEnv->getCurrentWidgetImagesUrl() . self::LOAD_ICON_FILE));			// ロード中アイコン
		$this->tmpl->addVar("_widget", "photo_detail_url", $this->getUrl($this->gEnv->getDefaultUrl(), true/*リンク用*/));		// 詳細画面へのリンク
		$this->tmpl->addVar("_widget", "ajax_url", $ajaxUrl);
	}
	/**
	 * 一覧画面データ取得
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function getList($request)
	{
		$pageNo = $request->trimIntValueOf(M3_REQUEST_PARAM_PAGE_NO, '1');				// ページ番号
		
		// デフォルトでは最新の登録画像を取得
		$this->photoArray = array();	// 取得した写真
		$this->startNo = $this->viewCount * ($pageNo -1) + 1;
		self::$_mainDb->searchPhotoItem($this->viewCount, $pageNo, $this->_langId, null/*開始日時*/, null/*終了日時*/, null/*カテゴリー*/, ''/*キーワード*/, array($this, 'viewListLoop'));

		// Ajax戻りデータ
		$this->gInstance->getAjaxManager()->addData('items', $this->photoArray);
		$this->gInstance->getAjaxManager()->addData('pagecount', $pageCount);		// 総ページ数
		$this->gInstance->getAjaxManager()->addData('pageno', $pageNo);			// 現在のページ番号
	}
	/**
	 * 詳細画面表示
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function showDetail($request)
	{
		$ret = self::$_mainDb->getPhotoInfo($this->photoId, $row);
		if ($ret){
			$title = $alt = $row['ht_name'];
			$author = $row['lu_name'];
			$date = $row['ht_date'];		// 撮影日
			if ($date == $this->gEnv->getInitValueOfDate()) $date = '';
			
			// 画像サイズ
			list($width, $height) = explode('x', $row['ht_image_size']);
			if ($width > $height){
				$height = ($height / $width) * photo_mainCommonDef::DEFAULT_PUBLIC_IMAGE_SIZE;
				$width = photo_mainCommonDef::DEFAULT_PUBLIC_IMAGE_SIZE;
			} else {
				$width = ($width / $height) * photo_mainCommonDef::DEFAULT_PUBLIC_IMAGE_SIZE;
				$height = photo_mainCommonDef::DEFAULT_PUBLIC_IMAGE_SIZE;
			}
			if (empty($width) || empty($height)){
				$width = $height = photo_mainCommonDef::DEFAULT_PUBLIC_IMAGE_SIZE;
			}
			
			$imageUrl = photo_mainCommonDef::getPublicImageUrl($this->photoId);
			
			// 前後のリンクを取得
			$this->startNo = $request->trimIntValueOf(M3_REQUEST_PARAM_ITEM_NO, '1');
			self::$_mainDb->searchPhotoItemByNo(3, $this->startNo -1, $this->_langId, null/*開始日時*/, null/*終了日時*/, null/*カテゴリー*/, ''/*キーワード*/, array($this, 'prevNextListLoop'));
		
			$this->tmpl->addVar("_widget", "photo_id", $this->photoId);
			$this->tmpl->addVar("_widget", "author", $this->convertToDispString($author));
			$this->tmpl->addVar("_widget", "place", $this->convertToDispString($row['ht_location']));
			$this->tmpl->addVar("_widget", "camera", $this->convertToDispString($row['ht_camera']));
			$this->tmpl->addVar("_widget", "note", $this->convertToDispString($row['ht_note']));
			$this->tmpl->addVar("_widget", "date", $this->convertToDispDateTime($date));
			$this->tmpl->addVar("_widget", "img_url", $this->getUrl($imageUrl));
			$this->tmpl->addVar("_widget", "width", $width);
			$this->tmpl->addVar("_widget", "height", $height);
			$this->tmpl->addVar("_widget", "title", $this->convertToDispString($title));
			$this->tmpl->addVar("_widget", "alt", $this->convertToDispString($alt));
			$this->tmpl->addVar("_widget", "back_img_url", $this->getUrl($this->gEnv->getRootUrl() . self::BACK_ICON_FILE));// 「戻る」アイコン
			$this->tmpl->addVar("_widget", "icon_size", photo_mainCommonDef::BUTTON_ICON_SIZE);
			$this->tmpl->addVar("_widget", "back_title", self::BACK_BUTTON_TITLE);
			$this->tmpl->addVar("_widget", "back_alt", self::BACK_BUTTON_TITLE);
			
			// ビューカウントを更新
			if (!$this->gEnv->isSystemManageUser()){		// システム運用者以上の場合はカウントしない
				$this->gInstance->getAnalyzeManager()->updateContentViewCount(photo_mainCommonDef::REF_CONTENT_TYPE, $row['ht_id'], $this->currentDay, $this->currentHour);
			}
		} else {
			$this->setUserErrorMsg('画像が見つかりません');
		}
	}
	/**
	 * 詳細画面データ取得
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function getDetail($request)
	{
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function viewListLoop($index, $fetchedRow)
	{
		// サムネール画像が存在するかどうかチェック
		$thumbnailPath = photo_mainCommonDef::getThumbnailPath($fetchedRow['ht_public_id']);
		if (file_exists($thumbnailPath)){
			$thumbnailUrl = $this->getUrl(photo_mainCommonDef::getThumbnailUrl($fetchedRow['ht_public_id']));
		} else {
			$thumbnailUrl = $this->notfoundThumbnailUrl;
		}
		$shortTitle = makeTruncStr($fetchedRow['ht_name'], $this->shortTitleLength);
		
		// 写真詳細へのリンク
		$linkUrl = $this->getUrl($this->gEnv->getDefaultUrl() . '?'. M3_REQUEST_PARAM_PHOTO_ID . '=' . $fetchedRow['ht_public_id'], true/*リンク用*/);
		
		$row = array(
			'id' =>	$fetchedRow['ht_public_id'],		// 公開画像ID
			'no' =>	$this->startNo + $index,		// 画像番号
			'title' => $fetchedRow['ht_name'],		// 写真タイトル
			'title_short' => $shortTitle,		// 略式写真タイトル
			'image_url' => $thumbnailUrl,	// サムネール画像のURL
			'detail_link' => $linkUrl			// 写真詳細へのリンク
		);
		$this->photoArray[] = $row;
		return true;
	}
	/**
	 * 前後のリンク項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function prevNextListLoop($index, $fetchedRow)
	{
		if ($index == 0 && $fetchedRow['ht_public_id'] != $this->photoId){		// 「前へ」リンクのとき
			$this->tmpl->setAttribute('prev_link', 'visibility', 'visible');		// リンク表示
			$this->tmpl->addVar("prev_link", "prev_img_url", $this->getUrl($this->gEnv->getRootUrl() . self::PREV_ICON_FILE));// 「前へ」アイコン
			$this->tmpl->addVar("prev_link", "prev_title", self::PREV_BUTTON_TITLE);
			$this->tmpl->addVar("prev_link", "prev_alt", self::PREV_BUTTON_TITLE);
			$this->tmpl->addVar("prev_link", "icon_size", photo_mainCommonDef::BUTTON_ICON_SIZE);
			
			// リンク作成
			$linkUrl = $this->getUrl($this->gEnv->getDefaultUrl() . '?'. M3_REQUEST_PARAM_PHOTO_ID . '=' . $fetchedRow['ht_public_id'] .
												'&' . M3_REQUEST_PARAM_ITEM_NO . '=' . ($this->startNo -1), true/*リンク用*/);
			$this->tmpl->addVar("prev_link", "prev_url", $this->convertUrlToHtmlEntity($linkUrl));
		} else if ($index >= 1 && $fetchedRow['ht_public_id'] != $this->photoId){// 「次へ」リンクのとき
			$this->tmpl->setAttribute('next_link', 'visibility', 'visible');		// リンク表示
			$this->tmpl->addVar("next_link", "next_img_url", $this->getUrl($this->gEnv->getRootUrl() . self::NEXT_ICON_FILE));// 「次へ」アイコン
			$this->tmpl->addVar("next_link", "next_title", self::NEXT_BUTTON_TITLE);
			$this->tmpl->addVar("next_link", "next_alt", self::NEXT_BUTTON_TITLE);
			$this->tmpl->addVar("next_link", "icon_size", photo_mainCommonDef::BUTTON_ICON_SIZE);
			
			// リンク作成
			$linkUrl = $this->getUrl($this->gEnv->getDefaultUrl() . '?'. M3_REQUEST_PARAM_PHOTO_ID . '=' . $fetchedRow['ht_public_id'] .
												'&' . M3_REQUEST_PARAM_ITEM_NO . '=' . ($this->startNo +1), true/*リンク用*/);
			$this->tmpl->addVar("next_link", "next_url", $this->convertUrlToHtmlEntity($linkUrl));
			return false;
		}
		return true;
	}
	/**
	 * ヘッダ部メタタグの設定
	 *
	 * HTMLのheadタグ内に出力する。
	 * _assign()よりも後に実行される。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ
	 * @return array 						設定データ。連想配列で「title」「description」「keywords」を設定。
	 */
	function _setHeadMeta($request, &$param)
	{
		$headData = array(	'title' => $this->headTitle,
							'description' => $this->headDesc,
							'keywords' => $this->headKeyword);
		return $headData;
	}
	/**
	 * JavascriptライブラリをHTMLヘッダ部に設定
	 *
	 * JavascriptライブラリをHTMLのheadタグ内に追加出力する。
	 * _assign()よりも後に実行される。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。
	 * @return string,array 				Javascriptライブラリ。出力しない場合は空文字列を設定。
	 */
	function _addScriptLibToHead($request, &$param)
	{
		return $this->addLib;
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function searchItemsLoop($index, $fetchedRow)
	{
		$title = $fetchedRow['be_name'];			// タイトル
		$blogId = $fetchedRow['be_blog_id'];						// ブログID
		
		// 記事へのリンクを生成
		//$linkUrl = $this->currentPageUrl . '&entryid=' . $fetchedRow['be_id'];
		$linkUrl = $this->getUrl($this->gEnv->getDefaultUrl() . '?'. M3_REQUEST_PARAM_BLOG_ENTRY_ID . '=' . $fetchedRow['be_id'], true/*リンク用*/);
		$link = '<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >' . $title . '</a>';
		
		// 日付
		$date = $fetchedRow['be_regist_dt'];

		// HTMLを出力(出力内容は特にエラーチェックしない)
		// 続きがある場合はリンクを付加
		$entryText = $fetchedRow['be_html'];
		$entryText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->getUrl($this->gEnv->getRootUrl()), $entryText);// アプリケーションルートを変換
		if (!empty($fetchedRow['be_html_ext'])){
			$entryText .= self::MESSAGE_EXT_ENTRY_PRE . '<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >' . self::MESSAGE_EXT_ENTRY . '</a>';
		}

		// ブログへのリンクを作成
		$blogLink = '';
		if ($this->useMultiBlog && !empty($blogId)){
			$blogName = $fetchedRow['bl_name'];// ブログ名
			$blogUrl = $this->getUrl($this->gEnv->getDefaultUrl() . '?' . M3_REQUEST_PARAM_BLOG_ID . '=' . $blogId);
			$blogLink = '<span style="font-size:smaller;"><a href="' . $this->convertUrlToHtmlEntity($blogUrl) . '" >' . $this->convertToDispString($blogName) . '</a></span>&nbsp;&nbsp;&nbsp;&nbsp;';
		}
		
		$row = array(
			'title' => $link,			// リンク付きタイトル
			'date' => $date,			// 日付
			'entry' => $entryText,	// 投稿記事
			'blog_link' => $blogLink			// マルチブログへのリンク
		);
		$this->tmpl->addVars('entrylist', $row);
		$this->tmpl->parseTemplate('entrylist', 'a');
		$this->isExistsViewData = true;				// 表示データがあるかどうか
		return true;
	}
	/**
	 * ページ番号計算処理
	 *
	 * @param int $pageNo			ページ番号(1～)。ページ番号が範囲外にある場合は自動的に調整
	 * @param int $totalCount		総項目数
	 * @param int $viewItemCount	1ページあたりの項目数
	 * @param int $pageCount		戻り値、ページ総数(1～)。
	 * @param int $startNo			戻り値、先頭項目番号(1～)。
	 * @param int $endNo			戻り値、最後項目番号(1～)。
	 * @return 						なし
	 */
	function calcPage(&$pageNo, $totalCount, $viewItemCount, &$pageCount, &$startNo, &$endNo)
	{
		// 表示するページ番号の修正
		$pageCount = (int)(($totalCount -1) / $viewItemCount) + 1;		// 総ページ数
		if ($pageNo < 1) $pageNo = 1;
		if ($pageNo > $pageCount) $pageNo = $pageCount;
		$startNo = ($pageNo -1) * $viewItemCount +1;		// 先頭の行番号
		$endNo = $pageNo * $viewItemCount > $totalCount ? $totalCount : $pageNo * $viewItemCount;// 最後の行番号
	}
	/**
	 * ページリンク作成
	 *
	 * @param int $pageNo			ページ番号(1～)。
	 * @param int $pageCount		総項目数
	 * @param int $linkCount		最大リンク数
	 * @param string $baseUrl		リンク用のベースURL
	 * @return string				リンクHTML
	 */
	function createPageLink($pageNo, $pageCount, $linkCount, $baseUrl)
	{
		// 表示するページ番号の修正
//		$pageCount = (int)(($totalCount -1) / $viewItemCount) + 1;		// 総ページ数
//		if ($pageNo < 1) $pageNo = 1;
//		if ($pageNo > $pageCount) $pageNo = $pageCount;

		// ページング用リンク作成
		$pageLink = '';
		if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
			//for ($i = 1; $i <= $pageCount; $i++){
			// ページ数1から「LINK_PAGE_COUNT」までのリンクを作成
			$maxPageCount = $pageCount < $linkCount ? $pageCount : $linkCount;
			for ($i = 1; $i <= $maxPageCount; $i++){
				if ($i == $pageNo){
					$link = '&nbsp;[' . $i . ']';
				} else {
					$linkUrl = $this->getUrl($baseUrl . '&page=' . $i, true/*リンク用*/);
					$link = '&nbsp;<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >[' . $i . ']</a>';
				}
				$pageLink .= $link;
			}
			// 残りは「...」表示
			if ($pageCount > $linkCount) $pageLink .= '&nbsp;...';
		}
		if ($pageNo > 1){		// 前ページがあるとき
			$linkUrl = $this->getUrl($baseUrl . '&page=' . ($pageNo -1), true/*リンク用*/);
			$link = '<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >[前へ]</a>';
			$pageLink = $link . $pageLink;
		}
		if ($pageNo < $pageCount){		// 次ページがあるとき
			$linkUrl = $this->getUrl($baseUrl . '&page=' . ($pageNo +1), true/*リンク用*/);
			$link = '&nbsp;<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >[次へ]</a>';
			$pageLink .= $link;
		}
		return $pageLink;
	}
}
?>
