-- *
-- * データ登録スクリプト「開発ウィジェット登録」
-- *
-- * PHP versions 5
-- *
-- * LICENSE: This source file is licensed under the terms of the GNU General Public License.
-- *
-- * @package    Magic3 Framework
-- * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
-- * @copyright  Copyright 2006-2011 Magic3 Project.
-- * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
-- * @version    SVN: $Id: _develop.sql 4389 2011-10-10 22:42:02Z fishbone $
-- * @link       http://www.magic3.org
-- *
-- [開発ウィジェット登録]   *****仕様変更あり注意*****
-- 開発中のウィジェットの登録を行う。
-- ・フォトギャラリー関係

-- *** Eコマーステーブル ***
-- 受注明細トラン
ALTER TABLE order_detail ADD od_product_class     VARCHAR(10)    DEFAULT ''                    NOT NULL;      -- 商品クラス
ALTER TABLE order_detail ADD od_product_type_id   VARCHAR(10)    DEFAULT ''                    NOT NULL;      -- 商品タイプ

-- 商品タイプマスター
DROP TABLE IF EXISTS product_type;
CREATE TABLE product_type (
    py_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    py_product_class     VARCHAR(10)    DEFAULT ''                    NOT NULL,      -- 商品クラス
    py_id                VARCHAR(10)    DEFAULT ''                    NOT NULL,      -- 商品タイプID
    py_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    py_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    
    py_name              VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- 名称
    py_description       VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- 説明
    py_index             INT            DEFAULT 0                     NOT NULL,      -- ソート用
    PRIMARY KEY          (py_serial),
    UNIQUE               (py_product_class,     py_id,        py_language_id,               py_history_index)
) TYPE=innodb;

-- 商品価格マスター
ALTER TABLE product_price DROP INDEX pp_product_id;-- ALTER TABLE product_price DROP CONSTRAINT product_price_pp_product_id_pp_language_id_pp_price_type_id_key; -- ユニーク制約削除
ALTER TABLE product_price ADD pp_product_class     VARCHAR(10)    DEFAULT ''                    NOT NULL;      -- 商品クラス
ALTER TABLE product_price ADD pp_product_type_id   VARCHAR(10)    DEFAULT ''                    NOT NULL;      -- 商品タイプ
ALTER TABLE product_price ADD UNIQUE (pp_product_class,     pp_product_id,    pp_product_type_id,    pp_language_id,      pp_price_type_id,      pp_history_index);                -- ユニーク制約再設定

