-- *
-- * データ登録スクリプト「開発ウィジェット登録」
-- *
-- * PHP versions 5
-- *
-- * LICENSE: This source file is licensed under the terms of the GNU General Public License.
-- *
-- * @package    Magic3 Framework
-- * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
-- * @copyright  Copyright 2006-2011 Magic3 Project.
-- * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
-- * @version    SVN: $Id: _develop.sql 4396 2011-10-15 00:09:22Z fishbone $
-- * @link       http://www.magic3.org
-- *
-- [開発ウィジェット登録]   *****仕様変更あり注意*****
-- 開発中のウィジェットの登録を行う。
-- ・フォトギャラリー関係
-- ウィジェット情報
DELETE FROM _widgets WHERE wd_id = 'photo_cart';
INSERT INTO _widgets 
(wd_id,        wd_name,                     wd_version, wd_author,      wd_copyright, wd_license,                wd_license_type, wd_official_level, wd_description, wd_has_admin, wd_initialized, wd_launch_index, wd_cache_type, wd_view_control_type, wd_install_dt, wd_create_dt) VALUES
('photo_cart', 'フォトギャラリー - カート', '1.0.0',    'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10,                'フォトギャラリーでカート内の商品を表示するボックス。',   false,    true,           100, 0, 0, now(),      now());

-- フォトギャラリー設定マスター
INSERT INTO photo_config
(hg_id,               hg_value,           hg_name,                                  hg_index) VALUES
('online_shop',       '1',                'オンラインショップ機能',                             12);

-- *** Eコマーステーブル ***
-- 受注明細トラン
ALTER TABLE order_detail ADD od_product_class     VARCHAR(10)    DEFAULT ''                    NOT NULL;      -- 商品クラス
ALTER TABLE order_detail ADD od_product_type_id   VARCHAR(10)    DEFAULT ''                    NOT NULL;      -- 商品タイプ

-- 商品タイプマスター
DROP TABLE IF EXISTS product_type;
CREATE TABLE product_type (
    py_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    py_product_class     VARCHAR(10)    DEFAULT ''                    NOT NULL,      -- 商品クラス
    py_id                VARCHAR(10)    DEFAULT ''                    NOT NULL,      -- 商品タイプID
    py_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    py_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    
    py_name              VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- 名称
    py_description       VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- 説明
    py_index             INT            DEFAULT 0                     NOT NULL,      -- ソート用
    PRIMARY KEY          (py_serial),
    UNIQUE               (py_product_class,     py_id,        py_language_id,               py_history_index)
) TYPE=innodb;

-- 商品価格マスター
ALTER TABLE product_price DROP INDEX pp_product_id;-- ALTER TABLE product_price DROP CONSTRAINT product_price_pp_product_id_pp_language_id_pp_price_type_id_key; -- ユニーク制約削除
ALTER TABLE product_price ADD pp_product_class     VARCHAR(10)    DEFAULT ''                    NOT NULL;      -- 商品クラス
ALTER TABLE product_price ADD pp_product_type_id   VARCHAR(10)    DEFAULT ''                    NOT NULL;      -- 商品タイプ
ALTER TABLE product_price ADD UNIQUE (pp_product_class,     pp_product_id,    pp_product_type_id,    pp_language_id,      pp_price_type_id,      pp_history_index);                -- ユニーク制約再設定

-- ショッピングカート商品項目
ALTER TABLE shop_cart_item DROP INDEX si_head_serial;-- ALTER TABLE shop_cart_item DROP CONSTRAINT shop_cart_item_si_head_serial_si_product_id_key; -- ユニーク制約削除
ALTER TABLE shop_cart_item ADD si_product_class     VARCHAR(10)    DEFAULT ''                    NOT NULL;      -- 商品クラス
ALTER TABLE shop_cart_item ADD si_product_type_id   VARCHAR(10)    DEFAULT ''                    NOT NULL;      -- 商品タイプ
ALTER TABLE shop_cart_item ADD UNIQUE (si_head_serial, si_product_class,     si_product_id,    si_product_type_id);                -- ユニーク制約再設定

-- 商品タイプマスター
INSERT INTO product_type
(py_product_class, py_id,      py_language_id, py_name,            py_description, py_index) VALUES 
('photo',          'download', 'ja',           'ダウンロード購入', '',             1);

-- 商品価格マスター
INSERT INTO product_price
(pp_product_class, pp_product_id, pp_product_type_id, pp_language_id, pp_price_type_id, pp_currency_id, pp_price) VALUES 
('photo',          0,             'download',         'ja',           'selling',        'JPY',          100),
('photo',          1,             'download',         'ja',           'selling',        'JPY',          200);
