<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2011 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_photo_mainConfigWidgetContainer.php 4355 2011-09-25 15:32:31Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_photo_mainBaseWidgetContainer.php');

class admin_photo_mainConfigWidgetContainer extends admin_photo_mainBaseWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_config.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$act = $request->trimValueOf('act');
		$listViewCount = $request->trimValueOf('item_view_count');		// 画像一覧表示数
		$listViewOrder = $request->trimValueOf('item_view_order');		// 画像一覧表示順
		$categoryCount = $request->trimValueOf('item_category_count');		// カテゴリ数
		$titleLength = $request->trimValueOf('item_title_length');		// 画像タイトル文字数
		$protectCopyright = ($request->trimValueOf('item_protect_copyright') == 'on') ? 1 : 0;		// 著作権保護
		$thumbBgColor = $request->trimValueOf('item_bg_color');		// サムネール背景色
		
		if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			$this->checkNumeric($listViewCount, '画像一覧表示数');
			$this->checkNumeric($categoryCount, '画像カテゴリー数');
			$this->checkNumeric($titleLength, '画像タイトル文字数');
			
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$isErr = false;
				
				if (!$isErr){
					if (!self::$_mainDb->updateConfig(photo_mainCommonDef::CF_PHOTO_LIST_ITEM_COUNT, $listViewCount)) $isErr = true;// 画像一覧表示数
				}
				if (!$isErr){
					if (!self::$_mainDb->updateConfig(photo_mainCommonDef::CF_PHOTO_LIST_ORDER, $listViewOrder)) $isErr = true;// 画像一覧表示順
				}
				if (!$isErr){
					if (!self::$_mainDb->updateConfig(photo_mainCommonDef::CF_IMAGE_CATEGORY_COUNT, $categoryCount)) $isErr = true;// 画像カテゴリー数
				}
				if (!$isErr){
					if (!self::$_mainDb->updateConfig(photo_mainCommonDef::CF_PHOTO_TITLE_SHORT_LENGTH, $titleLength)) $isErr = true;// 画像タイトル文字数
				}
				if (!$isErr){
					if (!self::$_mainDb->updateConfig(photo_mainCommonDef::CF_IMAGE_PROTECT_COPYRIGHT, $protectCopyright)) $isErr = true;		// 著作権保護
				}
				if (!$isErr){
					if (!self::$_mainDb->updateConfig(photo_mainCommonDef::CF_THUMBNAIL_BG_COLOR, $thumbBgColor)) $isErr = true;		// サムネール背景色
				}
				if ($isErr){
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				} else {
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				}
				// 値を再取得
				$listViewCount	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_PHOTO_LIST_ITEM_COUNT);		// 画像一覧表示数
				$listViewOrder	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_PHOTO_LIST_ORDER);			// 画像一覧表示順
				$categoryCount	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_IMAGE_CATEGORY_COUNT);		// 画像カテゴリー数
				$titleLength	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_PHOTO_TITLE_SHORT_LENGTH);// 画像タイトル文字数
				$protectCopyright	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_IMAGE_PROTECT_COPYRIGHT);// 著作権保護
				$thumbBgColor	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_THUMBNAIL_BG_COLOR);		// サムネール背景色
			}
		} else {		// 初期表示の場合
			$listViewCount	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_PHOTO_LIST_ITEM_COUNT);// 画像一覧表示数
			if (intval($listViewCount) <= 0) $listViewCount = photo_mainCommonDef::DEFAULT_PHOTO_LIST_VIEW_COUNT;
			$listViewOrder	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_PHOTO_LIST_ORDER);// 画像一覧表示順
			$categoryCount	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_IMAGE_CATEGORY_COUNT);// 画像カテゴリー数
			if (intval($categoryCount) <= 0) $categoryCount = photo_mainCommonDef::DEFAULT_CATEGORY_COUNT;
			$titleLength	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_PHOTO_TITLE_SHORT_LENGTH);// 画像タイトル文字数
			if (intval($titleLength) <= 0) $titleLength = photo_mainCommonDef::DEFAULT_PHOTO_TITLE_SHORT_LENGTH;
			$protectCopyright	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_IMAGE_PROTECT_COPYRIGHT);// 画像著作権保護
			$thumbBgColor	= self::$_mainDb->getConfig(photo_mainCommonDef::CF_THUMBNAIL_BG_COLOR);		// サムネール背景色
		}
		// 画面に書き戻す
		$this->tmpl->addVar("_widget", "view_count", $listViewCount);// 画像一覧表示数
		if (empty($listViewOrder)){	// 順方向
			$this->tmpl->addVar("_widget", "view_order_inc_selected", 'selected');// 画像一覧表示順
		} else {
			$this->tmpl->addVar("_widget", "view_order_dec_selected", 'selected');// 画像一覧表示順
		}
		$this->tmpl->addVar("_widget", "category_count", $categoryCount);// 画像カテゴリー数
		$this->tmpl->addVar("_widget", "title_length", $titleLength);// 画像タイトル文字数
		$checked = '';
		if ($protectCopyright) $checked = 'checked';
		$this->tmpl->addVar("_widget", "protect_copyright", $checked);// 画像著作権保護
		$this->tmpl->addVar("_widget", "bg_color", $thumbBgColor);// サムネール背景色
	}
}
?>
