-- *
-- * データ登録スクリプト「開発ウィジェット登録」
-- *
-- * PHP versions 5
-- *
-- * LICENSE: This source file is licensed under the terms of the GNU General Public License.
-- *
-- * @package    Magic3 Framework
-- * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
-- * @copyright  Copyright 2006-2011 Magic3 Project.
-- * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
-- * @version    SVN: $Id: _develop.sql 4626 2012-01-28 12:39:25Z fishbone $
-- * @link       http://www.magic3.org
-- *
-- [開発ウィジェット登録]   *****仕様変更あり注意*****
-- 開発中のウィジェットの登録を行う。
-- ・フォトギャラリー関係
-- ・スマートフォンブログ関係

-- ウィジェット情報

-- ウィジェット情報
DELETE FROM _widgets WHERE wd_id = 'photo_cart';
INSERT INTO _widgets 
(wd_id,        wd_name,                     wd_version, wd_author,      wd_copyright, wd_license,                wd_license_type, wd_official_level, wd_description, wd_has_admin, wd_initialized, wd_launch_index, wd_cache_type, wd_view_control_type, wd_install_dt, wd_create_dt) VALUES
('photo_cart', 'フォトギャラリー - カート', '1.1.0',    'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10,                'フォトギャラリーのカート内の商品を表示するオプションウィジェット。',   true,    true,           100, 0, 0, now(),      now());
DELETE FROM _widgets WHERE wd_id = 'photo_shop';
INSERT INTO _widgets
(wd_id,     wd_name,              wd_version, wd_author,      wd_copyright, wd_license, wd_license_type, wd_official_level, wd_description,                                                        wd_has_admin, wd_initialized, wd_cache_type, wd_view_control_type, wd_install_dt, wd_create_dt) VALUES
('photo_shop', 'フォトギャラリー - ショップ', '1.0.0',    'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License',   1,   10,                'フォトギャラリーの商品購入オプションウィジェット。', true,         true,   0, 2, now(), now());
DELETE FROM _widgets WHERE wd_id = 'photo_login';
INSERT INTO _widgets
(wd_id,         wd_name,                       wd_version, wd_author,      wd_copyright, wd_license,                wd_license_type, wd_official_level, wd_description, wd_add_script_lib, wd_has_admin, wd_initialized, wd_cache_type, wd_view_control_type, wd_install_dt, wd_create_dt) VALUES
('photo_login', 'フォトギャラリー - ログイン', '1.0.0',    'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10, 'フォトギャラリーの会員ログイン用ボックス。', 'md5',     false,     true,           2, -1, now(), now());

-- インナーウィジェット(配送方法)
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'flatrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,      iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'flatrate', '定額', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'classrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'classrate', '購入額基準', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'staterate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'staterate', '送付先基準', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'quantityrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'quantityrate', '商品数基準', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'productrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'productrate', '商品別規定', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'weightrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'weightrate', '送付先+重量基準', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
-- インナーウィジェット(支払方法)
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'epsilon';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,     iw_name,          iw_type,    iw_author,      iw_copyright, iw_license,               iw_license_type, iw_official_level, iw_online, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'epsilon', 'イプシロン決済', 'PAYMENT', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10,                true,      now(),         now());
-- インナーウィジェット(注文計算)
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'lotbuying';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,          iw_type,     iw_author,      iw_copyright, iw_license,               iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'lotbuying', 'まとめ買い割引', 'CALCORDER', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'product_lotbuying';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,               iw_name,                iw_type,     iw_author,      iw_copyright, iw_license,                iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'product_lotbuying', '商品別まとめ買い割引', 'CALCORDER', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10,                now(),         now());

-- インナーウィジェットメソッド定義マスター
TRUNCATE TABLE _iwidget_method;
INSERT INTO _iwidget_method 
(id_type,     id_id, id_language_id, id_name,              id_iwidget_id,          id_index) VALUES 
('CALCORDER', 1,     'ja',           '画像まとめ買い割引', 'photo_shop,lotbuying', 1),
('CALCORDER', 2,     'ja',           'フォト商品まとめ買い割引', 'photo_shop,product_lotbuying', 2);

-- 支払い方法マスター
TRUNCATE TABLE pay_method_def;
INSERT INTO pay_method_def (po_id, po_language_id, po_name, po_index) VALUES ('payment_service',  'ja', '決済サービス', 1);

-- フォトギャラリー設定マスター(Eコマース追加分)
INSERT INTO photo_config
(hg_id,               hg_value,           hg_name,                                  hg_index) VALUES
('online_shop',       '1',                'オンラインショップ機能',                 13),
('accept_order',      '1',                '注文の受付',                             14),
('use_email',         '1',                'メール送信機能',                         15),
('shop_email',        '',                 'ショップ宛てメールアドレス',             16),
('auto_email_sender', '',                 '自動送信メール送信元アドレス',           17),
('use_member_address', '1',               '会員登録の住所使用',                     18),
('auto_regist_member', '0',               '自動会員登録',                           19),
('sell_product_photo', '1',               'フォト商品販売',                         20),
('sell_product_download', '1',            'ダウンロード商品販売',                   21);

-- 商品タイプマスター
INSERT INTO product_type
(py_product_class, py_id,      py_language_id, py_name,            py_code, py_description, py_index, py_single_select) VALUES 
('',               '',         'ja',           '標準商品',         'ST',    '',             1,             false),
('photo',          '',         'ja',           '標準商品',         'ST',    '',             1,             false),
('photo',          'download', 'ja',           'ダウンロード画像', 'DL',    '',             2,             true);

-- 商品価格マスター
INSERT INTO product_price
(pp_product_class, pp_product_id, pp_product_type_id, pp_language_id, pp_price_type_id, pp_currency_id, pp_price) VALUES 
('photo',          0,             'download',         'ja',           'selling',        'JPY',          100);
-- ('photo',          1,             'download',         'ja',           'selling',        'JPY',          200);

-- 商品クラスマスター
INSERT INTO product_class
(pu_id,   pu_language_id, pu_name,                pu_index) VALUES 
('',      'ja',           '一般商品',             1),
('photo', 'ja',           'フォトギャラリー商品', 2);

-- 個人情報追加フィールド
TRUNCATE TABLE person_info_opt_field;
INSERT INTO person_info_opt_field
(pf_id,    pf_language_id, pf_name,   pf_field_type, pf_index) VALUES
('sports', 'ja',           'スポーツ', 'text',        1);

