<?php
/**
 * index.php用共通定義クラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2012 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: default_contentCommonDef.php 5027 2012-07-09 06:24:07Z fishbone $
 * @link       http://www.magic3.org
 */
 
class default_contentCommonDef
{
	static $_contentType = '';	// コンテンツタイプ
	static $_deviceType = 0;	// デバイスタイプ
	static $_deviceTypeName = 'PC';	// デバイスタイプ名
	static $_viewContentType = 'ct';		// 参照数カウント用コンテンツタイプ(将来的にはcontentを使用)

	// DB定義値
	static $CF_USE_PASSWORD			= 'use_password';		// パスワードアクセス制御
	static $CF_PASSWORD_CONTENT		= 'password_content';			// パスワード画面コンテンツ
	
	const CONTENT_WIDGET_ID = 'default_content';		// デフォルトの汎用コンテンツ編集ウィジェット
	const ATTACH_FILE_DIR = '/etc/content';				// 添付ファイル格納ディレクトリ
	
	/**
	 * フォトギャラリー定義値をDBから取得
	 *
	 * @param object $db	DBオブジェクト
	 * @return array		取得データ
	 */
	static function loadConfig($db)
	{
		$retVal = array();

		// 汎用コンテンツ定義を読み込み
		$ret = $db->getAllConfig($rows);
		if ($ret){
			// 取得データを連想配列にする
			$configCount = count($rows);
			for ($i = 0; $i < $configCount; $i++){
				$key = $rows[$i]['ng_id'];
				$value = $rows[$i]['ng_value'];
				$retVal[$key] = $value;
			}
		}
		return $retVal;
	}
	/**
	 * 添付ファイル格納ディレクトリ取得
	 *
	 * @return string		ディレクトリパス
	 */
	static function getAttachFileDir()
	{
		global $gEnvManager;
		$dir = $gEnvManager->getIncludePath() . self::ATTACH_FILE_DIR;
		if (!file_exists($dir)) mkdir($dir, M3_SYSTEM_DIR_PERMISSION, true/*再帰的*/);
		return $dir;
	}
}
?>
