<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2012 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_ec_dispWidgetContainer.php 5322 2012-10-25 15:06:19Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseAdminWidgetContainer.php');

class admin_ec_dispWidgetContainer extends baseAdminWidgetContainer
{
	const DEFAULT_PRODUCT_COUNT = 10;				// デファオルとの表示項目数
	const DEFAULT_TARGET_WIDGET = 'ec_main';		// 呼び出しウィジェットID
	const DEFAULT_STOCK_VIEW_FORMAT = '0:なし;3:残り僅か;:あり';
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$act = $request->trimValueOf('act');
		
		$productCount	= $request->trimValueOf('item_product_list_count');	// 商品表示数
		$targetWidget	= $request->trimValueOf('item_cart_widget');			// カート表示ウィジェット
		$showStock		= ($request->trimValueOf('item_show_stock') == 'on') ? 1 : 0;		// 在庫表示するかどうか
		$stockViewFormat	= $request->trimValueOf('item_stock_view_format');			// 在庫表示フォーマット
		
		if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			$this->checkNumeric($productCount, '表示項目数');
			$this->checkSingleByte($targetWidget, 'カート表示ウィジェット');
			
			if ($this->getMsgCount() == 0){			// エラーのないとき
				if (empty($stockViewFormat)) $stockViewFormat	= self::DEFAULT_STOCK_VIEW_FORMAT;			// 在庫表示フォーマット
				
				$paramObj = new stdClass;
				$paramObj->productCount	= $productCount;		// 商品表示数
				$paramObj->targetWidget = $targetWidget;		// カート表示ウィジェット
				$paramObj->showStock	= $showStock;				// 在庫表示するかどうか
				$paramObj->stockViewFormat	= $stockViewFormat;	// 在庫表示フォーマット
				$ret = $this->updateWidgetParamObj($paramObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
				$this->gPage->updateParentWindow();// 親ウィンドウを更新
			}
		} else {		// 初期表示の場合
			// デフォルト値設定
			$productCount = self::DEFAULT_PRODUCT_COUNT;						// 商品表示数
			$targetWidget = self::DEFAULT_TARGET_WIDGET;		// カート表示ウィジェット
			$showStock		= 0;		// 在庫表示するかどうか
			$stockViewFormat	= self::DEFAULT_STOCK_VIEW_FORMAT;			// 在庫表示フォーマット
			
			// 保存値取得
			$paramObj = $this->getWidgetParamObj();
			if (!empty($paramObj)){
				$productCount = $paramObj->productCount;		// 商品表示数
				$targetWidget = $paramObj->targetWidget;		// カート表示ウィジェット
				$showStock		= $paramObj->showStock;				// 在庫表示するかどうか
				$stockViewFormat	= $paramObj->stockViewFormat;	// 在庫表示フォーマット
			}
		}
		// 画面に書き戻す
		$this->tmpl->addVar("_widget", "product_list_count", $productCount);		// 商品表示数
		$this->tmpl->addVar("_widget", "cart_widget", $targetWidget);		// カート表示ウィジェット
		$this->tmpl->addVar("_widget", "stock_view_format", $stockViewFormat);		// 在庫表示フォーマット
		$checkedStr = '';
		if ($showStock) $checkedStr = 'checked';
		$this->tmpl->addVar("_widget", "show_stock_checked", $checkedStr);		// 在庫表示するかどうか
	}
}
?>
