-- *
-- * データ登録スクリプト「開発ウィジェット登録」
-- *
-- * PHP versions 5
-- *
-- * LICENSE: This source file is licensed under the terms of the GNU General Public License.
-- *
-- * @package    Magic3 Framework
-- * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
-- * @copyright  Copyright 2006-2012 Magic3 Project.
-- * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
-- * @version    SVN: $Id: _develop.sql 5409 2012-11-24 10:10:14Z fishbone $
-- * @link       http://www.magic3.org
-- *
-- [開発ウィジェット登録]   *****仕様変更あり注意*****
-- 開発中のウィジェットの登録を行う。
-- ・フォトギャラリー関係
-- ・スマートフォンブログ関係

-- フォトギャラリー設定マスター

-- ウィジェット情報
DELETE FROM _widgets WHERE wd_id = 'photo_cart';
INSERT INTO _widgets 
(wd_id,        wd_name,                     wd_version, wd_author,      wd_copyright, wd_license,                wd_license_type, wd_official_level, wd_description, wd_has_admin, wd_initialized, wd_launch_index, wd_cache_type, wd_view_control_type, wd_release_dt, wd_install_dt, wd_create_dt) VALUES
('photo_cart', 'フォトギャラリー - カート', '1.1.0',    'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10,                'フォトギャラリーのカート内の商品を表示するオプションウィジェット。',   true,    true,           100, 0, 0, '2012-11-24',now(),      now());
DELETE FROM _widgets WHERE wd_id = 'photo_shop';
INSERT INTO _widgets
(wd_id,     wd_name,              wd_type, wd_edit_content, wd_version, wd_author,      wd_copyright, wd_license, wd_license_type, wd_official_level, wd_description,                                                        wd_has_admin, wd_initialized, wd_cache_type, wd_view_control_type, wd_release_dt, wd_install_dt, wd_create_dt) VALUES
('photo_shop', 'フォトギャラリー - ショップ', 'product', true, '1.0.0',    'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License',   1,   10,                'フォトギャラリーの商品購入オプションウィジェット。', true,         true,   0, 2, '2012-11-24',now(), now());
DELETE FROM _widgets WHERE wd_id = 'photo_login';
INSERT INTO _widgets
(wd_id,         wd_name,                       wd_version, wd_author,      wd_copyright, wd_license,                wd_license_type, wd_official_level, wd_description, wd_add_script_lib, wd_has_admin, wd_initialized, wd_cache_type, wd_view_control_type, wd_release_dt, wd_install_dt, wd_create_dt) VALUES
('photo_login', 'フォトギャラリー - ログイン', '1.0.0',    'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10, 'フォトギャラリーの会員ログイン用ボックス。', 'md5',     false,     true,           2, -1, '2012-11-24',now(), now());
DELETE FROM _widgets WHERE wd_id = 'ec_product_carousel';
INSERT INTO _widgets
(wd_id,         wd_name,               wd_version, wd_author,      wd_copyright, wd_license, wd_official_level, wd_description, wd_add_script_lib, wd_add_script_lib_a,   wd_has_admin, wd_enable_operation, wd_use_instance_def, wd_initialized, wd_cache_type, wd_view_control_type, wd_release_dt, wd_release_dt, wd_install_dt, wd_create_dt) VALUES
('ec_product_carousel', 'Eコマース - 商品カルーセル表示', '1.0.0',    'Naoki Hirata', 'Magic3.org', 'GPL',      10, '商品画像をランダムでカルーセル表示する。', 'jquery.cloudcarousel,jquery.mousewheel', '',   true,        false,               false,true,           0, 0, '2012-11-01', '2012-11-24',now(), now());

-- インナーウィジェット(配送方法)
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'flatrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,      iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'flatrate', '定額', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'classrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'classrate', '購入額基準', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'staterate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'staterate', '送付先基準', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'quantityrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'quantityrate', '商品数基準', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'productrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'productrate', '商品別規定', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'weightrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,    iw_type,    iw_author,      iw_copyright, iw_license, iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'weightrate', '送付先+重量基準', 'DELIVERY', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,      10,                now(),         now());
-- インナーウィジェット(支払方法)
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'epsilon';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,     iw_name,          iw_type,    iw_author,      iw_copyright, iw_license,               iw_license_type, iw_official_level, iw_online, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'epsilon', 'イプシロン決済', 'PAYMENT', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10,                true,      now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'exchange_classrate';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,     iw_name,          iw_type,    iw_author,      iw_copyright, iw_license,               iw_license_type, iw_official_level, iw_online, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'exchange_classrate', '代金引換(購入額基準)', 'PAYMENT', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10,                false,      now(),         now());

-- インナーウィジェット(注文計算)
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'lotbuying';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,       iw_name,          iw_type,     iw_author,      iw_copyright, iw_license,               iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'lotbuying', 'まとめ買い割引', 'CALCORDER', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10,                now(),         now());
DELETE FROM _iwidgets WHERE iw_widget_id = 'photo_shop' AND iw_id = 'product_lotbuying';
INSERT INTO _iwidgets
(iw_widget_id, iw_id,               iw_name,                iw_type,     iw_author,      iw_copyright, iw_license,                iw_license_type, iw_official_level, iw_install_dt, iw_create_dt) VALUES
('photo_shop', 'product_lotbuying', '商品別まとめ買い割引', 'CALCORDER', 'Naoki Hirata', 'Magic3.org', 'Magic3 Commerce License', 1,               10,                now(),         now());

-- インナーウィジェットメソッド定義マスター
TRUNCATE TABLE _iwidget_method;
INSERT INTO _iwidget_method 
(id_type,     id_id, id_language_id, id_name,              id_iwidget_id,          id_index) VALUES 
('CALCORDER', 1,     'ja',           '画像まとめ買い割引', 'photo_shop,lotbuying', 1),
('CALCORDER', 2,     'ja',           'フォト商品まとめ買い割引', 'photo_shop,product_lotbuying', 2);

-- 支払い方法マスター
TRUNCATE TABLE pay_method_def;
INSERT INTO pay_method_def (po_id, po_language_id, po_name, po_index) VALUES ('payment_service',  'ja', '決済サービス', 1);

-- フォトギャラリー設定マスター(Eコマース追加分)
INSERT INTO photo_config
(hg_id,               hg_value,           hg_name,                                  hg_index) VALUES
('online_shop',       '1',                'オンラインショップ機能',                 13),
('auto_stock',        '0',                '在庫自動処理',                           14),
('accept_order',      '1',                '注文の受付',                             15),
('use_email',         '1',                'メール送信機能',                         16),
('shop_email',        '',                 'ショップ宛てメールアドレス',             17),
('auto_email_sender', '',                 '自動送信メール送信元アドレス',           18),
('use_member_address', '1',               '会員登録の住所使用',                     19),
('auto_regist_member', '1',               '自動会員登録',                           20),
('sell_product_photo', '1',               'フォト商品販売',                         21),
('sell_product_download', '1',            'ダウンロード商品販売',                   22),
('member_notice', '',                     '会員向けお知らせ',                       23),
('email_to_order_product', '',            '商品受注時メール送信先',                 24);

-- 商品タイプマスター
INSERT INTO product_type
(py_product_class, py_id,      py_language_id, py_name,            py_code, py_description, py_index, py_single_select) VALUES 
('',               '',         'ja',           '標準商品',         'ST',    '',             1,             false),
('photo',          '',         'ja',           '標準商品',         'ST',    '',             1,             false),
('photo',          'download', 'ja',           'ダウンロード画像', 'DL',    '',             2,             true);

-- 商品価格マスター
INSERT INTO product_price
(pp_product_class, pp_product_id, pp_product_type_id, pp_language_id, pp_price_type_id, pp_currency_id, pp_price) VALUES 
('photo',          0,             'download',         'ja',           'selling',        'JPY',          100);
-- ('photo',          1,             'download',         'ja',           'selling',        'JPY',          200);

-- 商品クラスマスター
INSERT INTO product_class
(pu_id,   pu_language_id, pu_name,                pu_index) VALUES 
('',      'ja',           '一般商品',             1),
('photo', 'ja',           'フォトギャラリー商品', 2);

-- 個人情報追加フィールド
TRUNCATE TABLE person_info_opt_field;
INSERT INTO person_info_opt_field
(pf_id,    pf_language_id, pf_name,   pf_field_type, pf_index) VALUES
('sports', 'ja',           'スポーツ', 'text',        1);

-- メール内容
DELETE FROM _mail_form WHERE mf_id = 'order_product_to_shop_manager';
INSERT INTO _mail_form (mf_id,           mf_language_id, mf_subject,         mf_content,                                                                 mf_create_dt) 
VALUES                 ('order_product_to_shop_manager', 'ja',           '商品受注',         '■受注コード：[#ORDER_NO#]■\n■受注日付：[#DATE#]■\n■会員コード：[#MEMBER_NO#]■\n■会員名：[#NAME#]■\n■会員Eメール：[#EMAIL#]■\n■管理画面URL：[#ADMIN_URL#]■\n■届先名：[#DELIV_NAME#]■\n■届先郵便番号：[#ZIPCODE#]■\n■届先都道府県：[#STATE#]■\n■届先住所１：[#ADDRESS1#]■\n■届先住所２：[#ADDRESS2#]■\n■届先電話番号：[#PHONE#]■\n■配達希望日：[#DEMAND_DATE#]■\n■配達時間帯：[#DEMAND_TIME#]■\n[#BODY#]■配送方法：[#DELIV_METHOD#]■\n■決済方法：[#PAY_METHOD#]■\n■備考：[#NOTE#]■\n\n**********\nお届け先\n**********\n[#DELIV_TEXT#]\n**********\n注文内容\n**********\n[#ORDER_TEXT#]\n', now());
DELETE FROM _mail_form WHERE mf_id = 'order_product_to_customer';
INSERT INTO _mail_form (mf_id,           mf_language_id, mf_subject,         mf_content,                                                                 mf_create_dt) 
VALUES                 ('order_product_to_customer', 'ja',           'ご注文の確認(自動送信)',         '[#NAME#] 様\n\nこの度は[#SHOP_NAME#]をご利用頂きまして誠にありがとうございます。\n下記の通りご注文を承りましたのでご確認ください。\n\n**********\nお届け先\n**********\n[#DELIV_TEXT#]\n**********\n注文内容\n**********\n[#ORDER_TEXT#]\n\n[#SIGNATURE#]', now());

-- 管理画面メニューデータ
DELETE FROM _nav_item;
INSERT INTO _nav_item
(ni_id, ni_parent_id, ni_index, ni_nav_id,    ni_task_id,                     ni_group_id, ni_view_control, ni_param, ni_name,    ni_help_title, ni_help_body, ni_visible) VALUES
(100,   0,            0,        'admin_menu', '_page',                        '',          0,               '',       '画面管理', '画面管理', 'Webサイトのデザインや機能を管理します。', true),
(101,   100,          0,        'admin_menu', 'pagedef',                      '',          0,               '',       'PC用画面', 'PC用画面編集', 'PC用Webサイトの画面を作成します。', true),
(102,   100,          1,        'admin_menu', 'pagedef_smartphone',           '',          0,               '',       'スマートフォン用画面', 'スマートフォン用画面編集',       'スマートフォン用Webサイトの画面を作成します。', true),
(103,   100,          2,        'admin_menu', 'pagedef_mobile',               '',          0,               '',       '携帯用画面', '携帯用画面編集', '携帯用Webサイトの画面を作成します。', true),
(104,   100,          3,        'admin_menu', 'widgetlist',                   '',          0,               '',       'ウィジェット管理', 'ウィジェット管理', 'ウィジェットの管理を行います。', true),
(105,   100,          4,        'admin_menu', 'templist',                     '',          0,               '',       'テンプレート管理', 'テンプレート管理', 'テンプレートの管理を行います。', true),
(106,   100,          5,        'admin_menu', 'smenudef',                      '',          0,               '',       'メニュー管理', 'メニュー管理', 'メニュー定義を管理します。', true),
(200,   0,            1,        'admin_menu', '_login',                       '',          0,               '',       'システム運用', '', '', true),
(201,   200,          0,        'admin_menu', 'userlist',                     '',          0,               '',       'ユーザ一覧',   'ユーザ一覧', 'ログイン可能なユーザを管理します。', true),
(202,   200,          1,        'admin_menu', 'analyzecalc',                  '',          0,               '',       'アクセス解析', 'アクセス解析', 'サイトへのアクセス状況を表示します。', true),
(203,   200,          2,        'admin_menu', 'opelog',                       '',          0,               '',       '運用ログ参照', '運用ログ参照', 'システムの運用状況を表示します。', true),
(204,   200,          3,        'admin_menu', 'accesslog',                    '',          0,               '',       'アクセスログ参照', 'アクセスログ参照', 'サイトへのアクセス状況を表示します。', true),
(205,   200,          4,        'admin_menu', 'searchwordlog',                '',          0,               '',       '検索ログ参照', '検索ログ参照', 'サイトで検索されたキーワードを表示します。', true),
(300,   0,            2,        'admin_menu', '_config',                      '',          0,               '',       'システム管理', '', '', true),
(301,   300,          0,        'admin_menu', 'configsite',                   '',          0,               '',       '基本情報', '基本情報', 'サイト運営に必要な情報を設定します。', true),
(302,   300,          1,        'admin_menu', 'configsys',                    '',          0,               '',       'システム情報', 'システム情報', 'システム全体の設定、運用状況を管理します。', true),
(303,   300,          2,        'admin_menu', 'resbrowse',                    '',          0,               '',       'リソースブラウズ', 'リソースブラウズ', 'リソースファイルを管理します。', true),
(304,   300,          3,        'admin_menu', 'master',                       '',          0,               '',       'システムマスター管理', 'システムマスター管理', 'システムに関するマスターテーブルの管理を行います。', true),
(305,   300,          4,        'admin_menu', 'initsystem',                   '',          0,               '',       'DBメンテナンス', 'DBメンテナンス', 'データの初期化などDBのメンテナンスを行います。', true),
(306,   300,          5,        'admin_menu', 'editmenu',                     '',          0,               '',       '管理メニュー編集', '管理メニュー編集', '管理機能のメインメニューを編集します。', true),
(399,   0,            3,        'admin_menu', '_399',                         '',          1,               '',       '改行', '', '', true),
(500,   0,            3,        'admin_menu', '_daily',                        '',          0,               '',           '日常処理', '', '', true),
(501,   500,          0,        'admin_menu', 'configwidget_photo_shop',       '',             0,               'task=order', '受注管理', '受注管理', '受注管理を行います。', true),
(502,   500,          1,        'admin_menu', 'configwidget_photo_shop',       '',             0,               'task=product', '商品管理', '商品管理', '商品管理を行います。', true),
(503,   500,          2,        'admin_menu', 'configwidget_photo_shop',       '',             0,               'task=member',   '会員管理', '会員管理', '会員情報を管理します。', true),
(600,   0,            4,        'admin_menu', '_content',                      '',          0,               '',       'コンテンツ管理', 'コンテンツ管理', '各種コンテンツを管理します。', true),
(601,   600,          0,        'admin_menu', 'configwidget_banner3',        '',          0,               '',       'バナー', 'バナー', 'バナーを管理します。(バナーメインウィジェット)', true);
