<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2011 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ec_product_displayWidgetContainer.php 4484 2011-11-29 22:30:18Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath()		. '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_product_displayDb.php');

class ec_product_displayWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $langId;		// 現在の言語
	private $ecObj;					// EC共通ライブラリオブジェクト
	private $outputHtml;			// HTML出力
	private $defaultImageSWidth;
	private $defaultImageSHeight;
	private $defaultImageMWidth;
	private $defaultImageMHeight;
	private $defaultImageLWidth;
	private $defaultImageLHeight;
	private $currentSubList;		// 現在の選択中の表題に属する商品項目リスト
	private	$title;// タイトル
	private $detailLabel;	// 詳細へのリンク
	private	$rowCount;			// 表示する行の数
	private	$columnCount;			// 表示する列の数
	private	$imgSize;				// 選択中の画像サイズ
	private	$nameVisible;			// 商品名表示
	private	$codeVisible;			// 商品コード表示
	private	$priceVisible;			// 商品価格表示
	private	$descVisible;			// 商品説明表示
	private	$imgVisible;			// 商品画像表示
	private	$detailVisible;			// 詳細ボタン表示
	const STANDARD_PRICE = 'selling';		// 通常価格
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	//const TARGET_WIDGET = 'ec_main';		// 呼び出しウィジェットID
	const TARGET_WIDGET = 'ec_disp';		// 呼び出しウィジェットID
	const DEFAULT_ROW_COUNT = 2;			// 表示する行の数
	const DEFAULT_COLUMN_COUNT = 3;			// 表示する列の数
	const PRODUCT_IMAGE_SMALL = 'small-product';		// 小サイズ商品画像ID
	const PRODUCT_IMAGE_MEDIUM = 'standard-product';		// 中サイズ商品画像ID
	const PRODUCT_IMAGE_LARGE = 'large-product';		// 大サイズ商品画像ID
	const DEFAULT_CONFIG_ID = 0;		// 定義が設定されていないときのデフォルト値
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_product_displayDb();
		
		// 価格計算用オブジェクト取得
		$this->ecObj = $this->gInstance->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		// 商品や商品カテゴリーが表示されているときは表示しない
		$categoryId = $request->trimValueOf('category');	// カテゴリーID
		$productId = $request->trimValueOf('product');			// 製品ID
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		if (empty($categoryId) && empty($productId) && empty($task)){
			return 'main.tmpl.html';
		} else {
			return '';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		// 商品や商品カテゴリーが表示されているときは表示しない
		$categoryId = $request->trimValueOf('category');	// カテゴリーID
		$productId = $request->trimValueOf('product');			// 製品ID
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		if (!empty($categoryId) || !empty($productId) || !empty($task)) return;
		
		// 環境取得
		$this->langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		
		// 定義ID取得
		$configId = $this->gEnv->getCurrentWidgetConfigId();
		if (empty($configId)) $configId = self::DEFAULT_CONFIG_ID;
		
		// デフォルト値設定
		$this->currentSubList = array();
		$this->title = '[未設定]';	// タイトル
		$this->detailLabel = 'もっと詳しく...';	// 詳細へのリンク
		$this->isVisibleAnytime = 0;		// 常に表示するかどうか
		$this->rowCount = self::DEFAULT_ROW_COUNT;			// 表示する行の数
		$this->columnCount = self::DEFAULT_COLUMN_COUNT;			// 表示する列の数
		$this->imgSize = self::PRODUCT_IMAGE_MEDIUM;				// 選択中の画像サイズ
		$this->nameVisible = 1;			// 商品名表示
		$this->codeVisible = 0;			// 商品コード表示
		$this->priceVisible = 1;			// 商品価格表示
		$this->descVisible = 0;			// 商品説明表示
		$this->imgVisible = 1;			// 商品画像表示
		$this->detailVisible = 0;			// 詳細ボタン表示
		
		// 保存値を取得
		$paramObj = $this->getWidgetParamObj();
		if (!empty($paramObj)){
			// 設定が取得可能なときは取得
			if ($configId < count($paramObj)){
				$this->currentSubList = $paramObj[$configId]->subList;
				$this->title			= $paramObj[$configId]->title;// タイトル
				$this->detailLabel	= $paramObj[$configId]->detailLabel;	// 詳細へのリンク
				$this->rowCount		= $paramObj[$configId]->rowCount;			// 表示する行の数
				$this->columnCount	= $paramObj[$configId]->columnCount;			// 表示する列の数
				$this->imgSize	= $paramObj[$configId]->imgSize;				// 選択中の画像サイズ
				$this->nameVisible	= $paramObj[$configId]->nameVisible;			// 商品名表示
				$this->codeVisible	= $paramObj[$configId]->codeVisible;			// 商品コード表示
				$this->priceVisible	= $paramObj[$configId]->priceVisible;			// 商品価格表示
				$this->descVisible	= $paramObj[$configId]->descVisible;			// 商品説明表示
				$this->imgVisible		= $paramObj[$configId]->imgVisible;			// 商品画像表示
				$this->detailVisible	= $paramObj[$configId]->detailVisible;			// 詳細ボタン表示
			}
		}
		
		// 画像情報を取得
		$this->defaultImageSWidth = 0;
		$this->defaultImageSHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_SMALL, $row);		// 画像小
		if ($ret){
			$this->defaultImageSWidth = $row['is_width'];
			$this->defaultImageSHeight = $row['is_height'];
		}
		$this->defaultImageMWidth = 0;
		$this->defaultImageMHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_MEDIUM, $row);		// 画像中
		if ($ret){
			$this->defaultImageMWidth = $row['is_width'];
			$this->defaultImageMHeight = $row['is_height'];
		}
		$this->defaultImageLWidth = 0;
		$this->defaultImageLHeight = 0;
		$ret = $this->db->getProductImageInfo(self::PRODUCT_IMAGE_LARGE, $row);		// 画像大
		if ($ret){
			$this->defaultImageLWidth = $row['is_width'];
			$this->defaultImageLHeight = $row['is_height'];
		}

		// 商品一覧を作成
		$this->createProductList();

		// 商品情報を埋め込む
		$this->tmpl->addVar("_widget", "new_items", $this->outputHtml);
		
		// その他の出力
		//$this->tmpl->addVar("_widget", "title", $this->title);
	}
	/**
	 * ウィジェットのタイトルを設定
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						ウィジェットのタイトル名
	 */
	function _setTitle($request, &$param)
	{
		return $this->title;
	}
	/**
	 * 商品一覧を作成
	 *
	 * @return なし						
	 */
	function createProductList()
	{
		// パラメータエラーチェック
		if (count($this->currentSubList) <= 0) return;
		
		// 表示順に項目をソートする
		usort($this->currentSubList, array($this, 'sortOrderByIndex'));
		
		// 最大表示可能数
		$maxCount = $this->rowCount * $this->columnCount;
		
		$viewItemCount = 0;		// 表示項目数
		for ($i = 0; $i < count($this->currentSubList); $i++){
			$subObj = $this->currentSubList[$i];
			$id = $subObj->id;
			
			// 商品情報を取得
			$ret = $this->db->getProductByProductId($id, $this->langId, $row, $row2, $row3, $row4);
			if ($ret){
				$name = $this->convertToDispString($row['pt_name']);		// 名前
				
				// 非表示に設定されている場合は、表示しない
				if (!$row['pt_visible']) continue;
			} else {
				//$name = '商品情報取得不可';
				continue;
			}
			
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $priceArray['pp_price'];	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別
			$lang = $row['pt_language_id'];					// 言語				

			// 表示額作成
			$this->ecObj->setCurrencyType($currency, $lang);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $lang);		// 税種別設定
			$totalPrice = $this->ecObj->getPriceWithTax($price, $dispPrice);	// 税込み価格取得
		
			// 通貨情報を取得
			$ret = $this->db->getCurrency($currency, $this->langId, $currencyRow);
			if ($ret){
				$prePrice = $this->convertToDispString($currencyRow['cu_symbol']);
				$postPrice = $this->convertToDispString($currencyRow['cu_post_symbol']);
			}
		
			// 画像を取得
			$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_SMALL);// 商品画像小
			$imageUrl_s = $imageArray['im_url'];	// URL
			$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_MEDIUM);// 商品画像中
			$imageUrl_m = $imageArray['im_url'];	// URL
			$imageArray = $this->getImage($row3, self::PRODUCT_IMAGE_LARGE);// 商品画像大
			$imageUrl_l = $imageArray['im_url'];	// URL
		
			// 画像を配列に保存
			$images = array();// 画像URL保存用
			$images[] = $imageUrl_s;
			$images[] = $imageUrl_m;
			$images[] = $imageUrl_l;
				
			// ######## タグを作成 ########
			$tableColumnCount = 1;		// 商品表示テーブルのカラムの数
			
			// 画像小
			$destImg_s = '';
			$imageUrl_s = $this->getProperImage($images, 0);
			if (empty($imageUrl_s)){
				$destImg_s = '<img id="preview_img_small" style="display:none;" ';
				$destImg_s .= 'width="' . $this->defaultImageSWidth . '" ';
				$destImg_s .= 'height="' . $this->defaultImageSHeight . '" ';
				$destImg_s .= '/>';
			} else {
				// URLマクロ変換
				$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->gEnv->getRootUrl(), $imageUrl_s);
				$destImg_s = '<img id="preview_img_small" src="' . $this->getUrl($imgUrl) . '" ';
				$destImg_s .= 'width="' . $this->defaultImageSWidth . '"';
				$destImg_s .= ' height="' . $this->defaultImageSHeight . '"';
				$destImg_s .= ' />';
			}
			// 画像中
			$destImg_m = '';
			$imageUrl_m = $this->getProperImage($images, 1);
			if (empty($imageUrl_m)){
				$destImg_m = '<img id="preview_img_medium" style="display:none;" ';
				$destImg_m .= 'width="' . $this->defaultImageMWidth . '" ';
				$destImg_m .= 'height="' . $this->defaultImageMHeight . '" ';
				$destImg_m .= 'style="border:0" />';
			} else {
				// URLマクロ変換
				$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->gEnv->getRootUrl(), $imageUrl_m);
				$destImg_m = '<img id="preview_img_medium" src="' . $this->getUrl($imgUrl) . '" ';
				$destImg_m .= 'width="' . $this->defaultImageMWidth . '"';
				$destImg_m .= ' height="' . $this->defaultImageMHeight . '" ';
				$destImg_m .= 'style="border:0" />';
			}
			// 画像大
			$destImg_l = '';
			$imageUrl_l = $this->getProperImage($images, 2);
			if (empty($imageUrl_l)){		// 画像が空のとき
				$destImg_l = '<img id="preview_img_large" style="display:none;" ';
				$destImg_l .= 'width="' . $this->defaultImageLWidth . '" ';
				$destImg_l .= 'height="' . $this->defaultImageLHeight . '" ';
				$destImg_l .= 'style="border:0"/>';
			} else {
				// URLマクロ変換
				$imgUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->gEnv->getRootUrl(), $imageUrl_l);
				$imageUrl_l = $imgUrl;
				$destImg_l = '<img id="preview_img_large" src="' . $this->getUrl($imgUrl) . '" ';
				$destImg_l .= 'width="' . $this->defaultImageLWidth . '"';
				$destImg_l .= ' height="' . $this->defaultImageLHeight . '" ';
				$destImg_l .= 'style="border:0"/>';
			}
		
			// 商品詳細へのリンク
			//$url = $this->createCmdUrlToWidget(self::TARGET_WIDGET, 'product=' . $id);
			$url = $this->gEnv->getDefaultUrl() . '?' . M3_REQUEST_PARAM_PRODUCT_ID . '=' . $id;
			
			// 画像の出力
			if ($this->imgVisible){
				$destImg = '';
				switch ($this->imgSize){
					case self::PRODUCT_IMAGE_SMALL:		// 小サイズ商品画像ID
						$destImg = $destImg_s;
						break;
					case self::PRODUCT_IMAGE_MEDIUM:		// 中サイズ商品画像ID
						$destImg = $destImg_m;
						break;
					case self::PRODUCT_IMAGE_LARGE:		// 大サイズ商品画像ID
						$destImg = $destImg_l;
						break;
				}
				if (!empty($destImg)) $imgSpan = '<div><a href="' . $this->getUrl($url, true) . '">' . $destImg . '</a></div>';
			}
			
			if ($this->nameVisible){			// 商品名表示
				$nameLink = '<div><a href="' . $this->getUrl($url, true) . '">' . $name . '</a></div>';
			}
			if ($this->codeVisible){			// 商品コード表示
				$productCode = '<div>' . $this->convertToDispString($row['pt_code']) . '</div>';
			}
			if ($this->priceVisible){			// 商品価格表示
				$priceStr = '<div>' . $prePrice . $dispPrice . $postPrice . '</div>';
			}
			if ($this->descVisible){			// 商品説明表示
				$tableColumnCount = 2;
				$destStr = '<div>' . $this->convertToDispString($row['pt_description_short']) . '</div>';
			}
			if ($this->detailVisible){			// 詳細ボタン表示
				$detailButton = '<div align="right"><a href="' . $this->getUrl($url, true) . '">' . $this->detailLabel . '</a></div>';
			}
		
			if ($tableColumnCount < 2){
				$itemStr = $imgSpan . $nameLink . $productCode . $priceStr . $detailButton;
			} else {
				$itemStr = '<table><tr><td style="border:none;">';
				$itemStr .= $imgSpan . $nameLink . $productCode . $priceStr;
				$itemStr .= '</td><td style="border:none;">';
				$itemStr .= $destStr . $detailButton;
				$itemStr .= '</td></tr></table>';
			}
		
			$colNo = $viewItemCount % $this->columnCount;
			if ($colNo == 0){// 左端のとき
				$this->outputHtml .= '<tr><td style="border:none;">';
				$this->outputHtml .= $itemStr;
				$this->outputHtml .= '</td>';
			} else if ($colNo == $this->columnCount -1){// 右端のとき
				$this->outputHtml .= '<td style="border:none;">';
				$this->outputHtml .= $itemStr;
				$this->outputHtml .= '</td></tr>';
			} else {
				$this->outputHtml .= '<td style="border:none;">';
				$this->outputHtml .= $itemStr;
				$this->outputHtml .= '</td>';
			}
			// 表示項目数を更新
			$viewItemCount++;
			if ($viewItemCount >= $maxCount) break;
		}
	}
	/**
	 * 画像取得
	 *
	 * @param array  	$srcRows			画像リスト
	 * @param string	$imageType			画像タイプ
	 * @return array						取得した行
	 */
	function getImage($srcRows, $sizeType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['im_size_id'] == $sizeType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * オブジェクトをindexメンバーの値で昇順にソートする
	 *
	 * @param object  	$obj1			比較するオブジェクト1
	 * @param object	$obj2			比較するオブジェクト2
	 * @return int						同じとき0、1が2より大きいとき1,1がより小さいとき-1を返す
	 */
	function sortOrderByIndex($obj1, $obj2)
	{
		if ($obj1->index == $obj2->index) return 0;
		return ($obj1->index < $obj2->index) ? -1 : 1;
	}
	/**
	 * 最適な画像を取得
	 *
	 * @param array  	$images			画像へのパス(優先順)
	 * @param int		$index			目的の画像のインデックス番号
	 * @return string					パス
	 */
	function getProperImage($images, $index)
	{
		// 指定画像が存在する場合はそのまま返す
		if (!empty($images[$index])) return $images[$index];
		
		for ($i = $index + 1; $i < count($images); $i++){
			if (!empty($images[$i])) return $images[$i];
		}
		for ($i = 0; $i < $index; $i++){
			if (!empty($images[$i])) return $images[$i];
		}
		return '';
	}
}
?>
