<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2013 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_commentBaseWidgetContainer.php 6042 2013-05-27 10:57:31Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseAdminWidgetContainer.php');
require_once($gEnvManager->getWidgetContainerPath('comment') . '/commentCommonDef.php');
require_once($gEnvManager->getWidgetDbPath('comment') . '/commentDb.php');

class admin_commentBaseWidgetContainer extends BaseAdminWidgetContainer
{
	protected static $_mainDb;			// DB接続オブジェクト
	protected static $_configArray;		// ブログ定義値
	protected static $_task;			// 現在の画面
	const DEFAULT_COMMENT_LENGTH	= 300;				// デフォルトのコメント最大文字数
	const DEFAULT_CATEGORY_COUNT	= 2;				// デフォルトのカテゴリ数
	
	// カレンダー用スクリプト
	const CALENDAR_SCRIPT_FILE = '/jscalendar-1.0/calendar.js';		// カレンダースクリプトファイル
	const CALENDAR_LANG_FILE = '/jscalendar-1.0/lang/calendar-ja.js';	// カレンダー言語ファイル
	const CALENDAR_SETUP_FILE = '/jscalendar-1.0/calendar-setup.js';	// カレンダーセットアップファイル
	const CALENDAR_CSS_FILE = '/jscalendar-1.0/calendar-win2k-1.css';		// カレンダー用CSSファイル
	
	// 画面
	const TASK_CONFIG			= 'config';				// 基本設定
	const TASK_CONFIG_LIST		= 'config_list';		// コンテンツ個別設定一覧
	const TASK_CONFIG_DETAIL	= 'config_detail';		// コンテンツ個別設定詳細
	const TASK_COMMENT			= 'comment';			// コメント一覧
	const TASK_COMMENT_DETAIL 	= 'comment_detail';		// コメント詳細
	const DEFAULT_TASK			= 'config';
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		if (!isset(self::$_mainDb)) self::$_mainDb = new commentDb();
		
		// ブログ定義を読み込む
		//if (!isset(self::$_configArray)) self::$_configArray = commentCommonDef::loadConfig(self::$_mainDb);
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _postAssign($request, &$param)
	{
		$openBy = $request->trimValueOf(M3_REQUEST_PARAM_OPEN_BY);		// ウィンドウオープンタイプ
		if (!empty($openBy)) $this->addOptionUrlParam(M3_REQUEST_PARAM_OPEN_BY, $openBy);
		if ($openBy == 'simple') return;			// シンプルウィンドウのときはメニューを表示しない
		
		// 表示画面を決定
	//	$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
	//	if (empty($task)) $task = 'config';
		$task = self::$_task;			// 現在の画面を取得
		
		// パンくずリストを作成
		switch ($task){
			case self::TASK_COMMENT:		// コメント一覧
			case self::TASK_COMMENT_DETAIL:	// コメント詳細
				$linkList = ' &gt;&gt; コメント一覧';// パンくずリスト
				break;
			case self::TASK_CONFIG:		// 基本設定
			case self::TASK_CONFIG_LIST:		// コンテンツ個別設定一覧
			case self::TASK_CONFIG_DETAIL:		// コンテンツ個別設定詳細
				$linkList = ' &gt;&gt; 基本設定';// パンくずリスト
				break;
		}

		// ####### 上段メニューの作成 #######
		$menuText = '<div id="configmenu-upper">' . M3_NL;
		$menuText .= '<ul>' . M3_NL;
		
		$current = '';
		$baseUrl = $this->getAdminUrlWithOptionParam();
		
		// コメント一覧
		$current = '';
		$link = $baseUrl . '&task=' . self::TASK_COMMENT;
		if ($task == self::TASK_COMMENT || $task == self::TASK_COMMENT_DETAIL) $current = 'id="current"';
		$menuText .= '<li ' . $current . '><a href="'. $this->getUrl($link) .'"><span>コメント一覧</span></a></li>' . M3_NL;
		
		// 基本設定
		$current = '';
		$link = $baseUrl . '&task=' . self::TASK_CONFIG;
		if ($task == self::TASK_CONFIG || $task == self::TASK_CONFIG_LIST || $task == self::TASK_CONFIG_DETAIL) $current = 'id="current"';
		$menuText .= '<li ' . $current . '><a href="'. $this->getUrl($link) .'"><span>基本設定</span></a></li>' . M3_NL;
		
		// 上段メニュー終了
		$menuText .= '</ul>' . M3_NL;
		$menuText .= '</div>' . M3_NL;
		
		// 作成データの埋め込み
		$linkList = '<div id="configmenu-top"><label>' . '汎用コメント' . $linkList . '</div>';
		$outputText .= '<table width="90%"><tr><td>' . $linkList . $menuText . '</td></tr></table>' . M3_NL;
		$this->tmpl->addVar("_widget", "menu_items", $outputText);
	}
}
?>
