/**
 * Copyright (c) 2009 - 2010 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot  or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * jqPlot includes date instance methods and printf/sprintf functions by other authors:
 *
 * Date instance methods contained in jqplot.dateMethods.js:
 *
 *     author Ken Snyder (ken d snyder at gmail dot com)
 *     date 2008-09-10
 *     version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 *     license Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * JavaScript printf/sprintf functions contained in jqplot.sprintf.js:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */
(function(a){a.jqplot.LogAxisRenderer=function(){a.jqplot.LinearAxisRenderer.call(this);this.axisDefaults={base:10,tickDistribution:"even"}};a.jqplot.LogAxisRenderer.prototype=new a.jqplot.LinearAxisRenderer();a.jqplot.LogAxisRenderer.prototype.constructor=a.jqplot.LogAxisRenderer;a.jqplot.LogAxisRenderer.prototype.init=function(e){a.extend(true,this.renderer,e);for(var h in this.renderer.axisDefaults){if(this[h]==null){this[h]=this.renderer.axisDefaults[h]}}var b=this._dataBounds;for(var f=0;f<this._series.length;f++){var g=this._series[f];var h=g.data;for(var c=0;c<h.length;c++){if(this.name=="xaxis"||this.name=="x2axis"){if(h[c][0]>b.max||b.max==null){b.max=h[c][0]}if(h[c][0]>b.max||b.max==null){b.max=h[c][0]}}else{if(h[c][1]<b.min||b.min==null){b.min=h[c][1]}if(h[c][1]>b.max||b.max==null){b.max=h[c][1]}}}}};a.jqplot.LogAxisRenderer.prototype.createTicks=function(){var A=this._ticks;var x=this.ticks;var D=this.name;var z=this._dataBounds;var s,y;var o,v;var e,d;var b,w;if(x.length){for(w=0;w<x.length;w++){var f=x[w];var k=new this.tickRenderer(this.tickOptions);if(f.constructor==Array){k.value=f[0];k.label=f[1];if(!this.showTicks){k.showLabel=false;k.showMark=false}else{if(!this.showTickMarks){k.showMark=false}}k.setTick(f[0],this.name);this._ticks.push(k)}else{k.value=f;if(!this.showTicks){k.showLabel=false;k.showMark=false}else{if(!this.showTickMarks){k.showMark=false}}k.setTick(f,this.name);this._ticks.push(k)}}this.numberTicks=x.length;this.min=this._ticks[0].value;this.max=this._ticks[this.numberTicks-1].value}else{if(D=="xaxis"||D=="x2axis"){s=this._plotDimensions.width}else{s=this._plotDimensions.height}o=((this.min!=null)?this.min:z.min);v=((this.max!=null)?this.max:z.max);if(o==v){var g=0.05;o=o*(1-g);v=v*(1+g)}if(this.min!=null&&this.min<=0){throw ("log axis minimum must be greater than 0")}if(this.max!=null&&this.max<=0){throw ("log axis maximum must be greater than 0")}var l=v-o;var n,r;if(this.tickDistribution=="even"){n=(this.min!=null)?this.min:o-o*((this.padMin-1)/2);r=(this.max!=null)?this.max:v+v*((this.padMax-1)/2);this.min=n;this.max=r;l=this.max-this.min;if(this.numberTicks==null){if(s>100){this.numberTicks=parseInt(3+(s-100)/75,10)}else{this.numberTicks=2}}var h=Math.pow(this.base,(1/(this.numberTicks-1)*Math.log(this.max/this.min)/Math.log(this.base)));for(var w=0;w<this.numberTicks;w++){b=this.min*Math.pow(h,w);var k=new this.tickRenderer(this.tickOptions);if(!this.showTicks){k.showLabel=false;k.showMark=false}else{if(!this.showTickMarks){k.showMark=false}}k.setTick(b,this.name);this._ticks.push(k)}}else{if(this.tickDistribution=="power"){n=Math.pow(this.base,Math.ceil(Math.log(o*(2-this.padMin))/Math.log(this.base))-1);r=Math.pow(this.base,Math.floor(Math.log(v*this.padMax)/Math.log(this.base))+1);this.min=n;this.max=r;l=this.max-this.min;var q=0;var c=0;if(this.numberTicks==null){if(s>100){this.numberTicks=Math.round(Math.log(this.max/this.min)/Math.log(this.base)+1);if(this.numberTicks<2){this.numberTicks=2}q=parseInt(3+(s-100)/75,10)}else{this.numberTicks=2;q=2}if(this.numberTicks<q-1){c=Math.floor(q/this.numberTicks)}}for(var w=0;w<this.numberTicks;w++){b=Math.pow(this.base,w-this.numberTicks+1)*this.max;var k=new this.tickRenderer(this.tickOptions);if(!this.showTicks){k.showLabel=false;k.showMark=false}else{if(!this.showTickMarks){k.showMark=false}}k.setTick(b,this.name);this._ticks.push(k);if(c&&w<this.numberTicks-1){var m=Math.pow(this.base,w-this.numberTicks+2)*this.max;var B=m-b;var y=m/(c+1);for(var p=c-1;p>=0;p--){var C=m-y*(p+1);var k=new this.tickRenderer(this.tickOptions);if(!this.showTicks){k.showLabel=false;k.showMark=false}else{if(!this.showTickMarks){k.showMark=false}}k.setTick(C,this.name);this._ticks.push(k)}}}}}}};a.jqplot.LogAxisRenderer.prototype.pack=function(n,j){var d=parseInt(this.base,10);var q=this._ticks;var v=function(h){return Math.log(h)/Math.log(d)};var b=function(h){return Math.pow(Math.E,(Math.log(d)*h))};max=v(this.max);min=v(this.min);var g=j.max;var u=j.min;var l=(this._label==null)?false:this._label.show;for(var c in n){this._elem.css(c,n[c])}this._offsets=j;var f=g-u;var s=max-min;this.p2u=function(h){return b((h-u)*s/f+min)};this.u2p=function(h){return(v(h)-min)*f/s+u};if(this.name=="xaxis"||this.name=="x2axis"){this.series_u2p=function(h){return(v(h)-min)*f/s};this.series_p2u=function(h){return b(h*s/f+min)}}else{this.series_u2p=function(h){return(v(h)-max)*f/s};this.series_p2u=function(h){return b(h*s/f+max)}}if(this.show){if(this.name=="xaxis"||this.name=="x2axis"){for(i=0;i<q.length;i++){var r=q[i];if(r.show&&r.showLabel){var k;if(r.constructor==a.jqplot.CanvasAxisTickRenderer&&r.angle){switch(r.labelPosition){case"auto":if(r.angle<0){k=-r.getWidth()+r._textRenderer.height*Math.sin(-r._textRenderer.angle)/2}else{k=-r._textRenderer.height*Math.sin(r._textRenderer.angle)/2}break;case"end":k=-r.getWidth()+r._textRenderer.height*Math.sin(-r._textRenderer.angle)/2;break;case"start":k=-r._textRenderer.height*Math.sin(r._textRenderer.angle)/2;break;case"middle":k=-r.getWidth()/2+r._textRenderer.height*Math.sin(-r._textRenderer.angle)/2;break;default:k=-r.getWidth()/2+r._textRenderer.height*Math.sin(-r._textRenderer.angle)/2;break}}else{k=-r.getWidth()/2}var e=this.u2p(r.value)+k+"px";r._elem.css("left",e);r.pack()}}if(l){var o=this._label._elem.outerWidth(true);this._label._elem.css("left",u+f/2-o/2+"px");if(this.name=="xaxis"){this._label._elem.css("bottom","0px")}else{this._label._elem.css("top","0px")}this._label.pack()}}else{for(i=0;i<q.length;i++){var r=q[i];if(r.show&&r.showLabel){var k;if(r.constructor==a.jqplot.CanvasAxisTickRenderer&&r.angle){switch(r.labelPosition){case"auto":case"end":if(r.angle<0){k=-r._textRenderer.height*Math.cos(-r._textRenderer.angle)/2}else{k=-r.getHeight()+r._textRenderer.height*Math.cos(r._textRenderer.angle)/2}break;case"start":if(r.angle>0){k=-r._textRenderer.height*Math.cos(-r._textRenderer.angle)/2}else{k=-r.getHeight()+r._textRenderer.height*Math.cos(r._textRenderer.angle)/2}break;case"middle":k=-r.getHeight()/2;break;default:k=-r.getHeight()/2;break}}else{k=-r.getHeight()/2}var e=this.u2p(r.value)+k+"px";r._elem.css("top",e);r.pack()}}if(l){var m=this._label._elem.outerHeight(true);this._label._elem.css("top",g-f/2-m/2+"px");if(this.name=="yaxis"){this._label._elem.css("left","0px")}else{this._label._elem.css("right","0px")}this._label.pack()}}}}})(jQuery);