#include "mnDef.h"
#include "mnModel.h"
#include <wx/dir.h>
#include <wx/regex.h>
#include <iconv.h>

/* $B%W%m%H%?%$%W(B */
static char*  decode(const char* string);
static char*  encode(const char* string);
static int compWikiData(const void* wiki1, const void* wiki2);


/******* WikiList ************************/
#include <wx/listimpl.cpp>
WX_DEFINE_LIST(WikiList);


/******* mnModel ************************/

mnModel::mnModel(const char* dataDir)
{
	wxCSConv conv(wxT(CODE_SET_SYSTEM));

    wikiDataDir = new wxString(dataDir, conv);
	searchStrList = new wxArrayString();
}

mnModel::~mnModel()
{
	delete wikiDataDir;
}


WikiList* mnModel::search(const char* searchStr)
{
	wxDir*      dir;
 	FILE*       fp;
    wxString    fullPathName;
    char        buf[MAX_BUF_SIZE];
	WikiData*   wikiData;
    WikiList*   list = new WikiList();
    wxString*   fileName = new wxString();
	wxRegEx*	regStr;
	iconv_t     codeSet;
	char        outbuf[MAX_BUF_SIZE];
	const char*       inbufPtr  = searchStr;
	char*       outbufPtr = outbuf;
	int         inbufSize = strlen(searchStr);
	int         outbufSize = sizeof(outbuf);
	const char* decodeFileName;

	memset(outbuf, 0, outbufSize);
	codeSet = iconv_open(CODE_SET_EUC_JP, CODE_SET_SYSTEM);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}
	iconv(codeSet, (const char**)&inbufPtr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);
	iconv_close(codeSet);

	dir = new wxDir(*wikiDataDir);
    if ( !dir->IsOpened() )
    {
		MN_FATAL_ERROR(wxT("wxDir has faild\n"));
        return NULL;
    }
    bool cont = dir->GetFirst(fileName, wxEmptyString, wxDIR_FILES);
	while(cont){
        fullPathName = *wikiDataDir + wxT("/") + *fileName;
		fp = fopen((const char*)fullPathName.mb_str(), "r");
		if(fp == NULL) {
			MN_FATAL_ERROR(wxT("fopen faild"));
		}
    	while(1){
        	memset(buf, 0, MAX_BUF_SIZE);
            fread(buf, MAX_BUF_SIZE-1, 1, fp);
            if(buf[0] == 0) break;
			decodeFileName = decode(fileName->mb_str());
        	if(strstr((const char*)buf, (const char*)outbuf) ||
			   	strstr((const char*)decodeFileName, (const char*)outbuf)) {
				wikiData = new WikiData(wikiDataDir, (const char*)fileName->mb_str(), fp);
				list->Append(wikiData);
				break;
			}
            buf[0] = 0;
		}
		fclose(fp);
        cont = dir->GetNext(fileName);
	}
	delete dir;

	list->Sort(compWikiData);
	return list;
}

void mnModel::addSearchStr(wxString* searchStr)
{
	wxString *string;

	if(searchStrList->Index(searchStr->c_str()) == wxNOT_FOUND){
		string = new wxString(searchStr->c_str());
		searchStrList->Add(*string, 1);
	}
}

void mnModel::removeSearchStr(wxString searchStr)
{
	if(searchStrList->Index(searchStr.c_str()) != wxNOT_FOUND) {
		searchStrList->Remove(searchStr.c_str());
	}
}

void mnModel::modSearchStr(wxString* oldStr, wxString* newStr)
{
	int index;

	if((index = searchStrList->Index(oldStr->c_str())) != wxNOT_FOUND){
		wxString& itemStr = searchStrList->Item(index);
		itemStr.sprintf(wxT("%s"), newStr->c_str());
	}
}

const wxArrayString* mnModel::getSearchStrList()
{
	return searchStrList;
}

WikiData* mnModel::newWikiData()
{
	WikiData* data = new WikiData(wikiDataDir);

	return data;
}

/******* WikiData ************************/
WikiData::WikiData(wxString* dataDir, const char* file, FILE* fp)
{
	char* decodeStr;
	char  buf[MAX_BUF_SIZE];
	char* inbuf;
	int   inbufSize;
	char  outbuf[MAX_BUF_SIZE];
	char* outbufPtr = outbuf;
	int   outbufSize;
	wxCSConv conv(wxT(CODE_SET_SYSTEM));

	iconv_t codeSet = iconv_open(CODE_SET_SYSTEM, CODE_SET_EUC_JP);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}

	text = NULL;
	memset(outbuf, 0, MAX_BUF_SIZE);
	fileName = new wxString((const char*)file, conv);
	dataDirName = dataDir;
	decodeStr = decode(file);
	inbufSize = strlen(decodeStr);
	outbufSize = sizeof(outbuf);
	iconv(codeSet, (const char**)&decodeStr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);
	subject  = new wxString((const char*)outbuf, conv);
	iconv_close(codeSet);

	date     = NULL;

    rewind(fp); 
	while(fgets(buf, MAX_BUF_SIZE, fp)) {
		if(strstr( (const char*)buf, (const char*)DATE_TAG)) {
			strtok(buf, "\n");
			strtok(buf, "\r");
			date = new wxString((const char*)buf, conv);
			break;
		}
	}
}

WikiData::WikiData(wxString* dataDir) {
	time_t     now;
	char       buf[MAX_BUF_SIZE];
	wxCSConv    conv(wxT(CODE_SET_SYSTEM));

	dataDirName = dataDir;

    time(&now);
	memset(buf, 0, sizeof(buf));
	strftime(buf, sizeof(buf), "%Y/%m/%d-%H%M%S",localtime(&now));
	subject  = new wxString(buf, conv);

	fileName = new wxString(encode(buf), conv);
	fileName->Append(wxT(EXT_TAG));

	memset(buf, 0, sizeof(buf));
	strftime(buf, sizeof(buf), DATE_TAG "%Y/%m/%d %H:%M:%S",localtime(&now));
	date    = new wxString(buf, conv);
	
	memset(buf, 0, sizeof(buf));
	strftime(buf, sizeof(buf), NEW_DATA,localtime(&now));
	text    = new wxString(buf, conv);

}

WikiData::~WikiData()
{
	delete subject;
	delete fileName;
	delete date;
	delete text;
}

const wxString* WikiData::getFileName() 
{
	return fileName;
}

const wxString* WikiData::getSubject() 
{
	return subject;
}

void WikiData::modSubject(wxString* newSubject) 
{
	wxCSConv    conv(wxT(CODE_SET_SYSTEM));
	wxString*   oldFileName = fileName;
	wxString*   oldSubject  = subject;
	char        oldFullPath[MAX_BUF_SIZE];
	char        newFullPath[MAX_BUF_SIZE];
	iconv_t     codeSet;
	char        outbuf[MAX_BUF_SIZE];
	char        inbuf[MAX_BUF_SIZE];
	const char* inbufPtr  = inbuf;
	char*       outbufPtr = outbuf;
	int         inbufSize;
	int         outbufSize = sizeof(outbuf);
	FILE*       fp;

	memset(outbuf, 0, outbufSize);
	memset(inbuf,  0, sizeof(inbuf));
	strcpy(inbuf, (const char*)newSubject->mb_str());
	inbufSize = strlen(inbuf);
	codeSet = iconv_open(CODE_SET_EUC_JP, CODE_SET_SYSTEM);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}
	iconv(codeSet, (const char**)&inbufPtr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);
	iconv_close(codeSet);
	subject  = new wxString(newSubject->c_str());
	fileName = new wxString(encode(outbuf), conv);
	fileName->Append(wxT(EXT_TAG));

	sprintf(oldFullPath, "%s/%s", (const char*)dataDirName->mb_str(), (const char*)oldFileName->mb_str());
	sprintf(newFullPath, "%s/%s", (const char*)dataDirName->mb_str(), (const char*)fileName->mb_str());

	if((fp = fopen(newFullPath, "r")) == NULL) {
		rename(oldFullPath, newFullPath);
	}
	else {
		wxLogMessage(wxT("File has already exist. [%s]"), fileName->c_str());
		fclose(fp);
	}

	delete oldSubject;
	delete oldFileName;
}

const wxString* WikiData::getDate() 
{
	return date;
}


const wxString* WikiData::getText() 
{
	FILE* fp;
	char  buf[MAX_BUF_SIZE];
	char  fullPath[MAX_BUF_SIZE];
	iconv_t     codeSet;
	char        outbuf[MAX_BUF_SIZE];
	char*       inbufPtr;
	char*       outbufPtr;
	int         inbufSize;
	int         outbufSize;
	wxCSConv    conv(wxT(CODE_SET_SYSTEM));
	wxString*   tmpStr;

	codeSet = iconv_open(CODE_SET_SYSTEM, CODE_SET_EUC_JP);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}

	if(text) {
		iconv_close(codeSet);
		return text;
	}

	text = new wxString();
	sprintf(fullPath, "%s/%s", (const char*)dataDirName->mb_str(), (const char*)fileName->mb_str());
	fp = fopen(fullPath, "r");
	if(fp == NULL) {
		MN_FATAL_ERROR(wxT("File open error."));
	}

	while(fgets(buf, MAX_BUF_SIZE, fp)) {
		inbufPtr = buf;
		inbufSize = sizeof(buf);
		outbufPtr = outbuf;
		outbufSize = sizeof(outbuf);
		memset(outbuf, 0, outbufSize);
		iconv(codeSet, (const char**)&inbufPtr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);
		tmpStr = new wxString((char*)outbuf, conv);
		*text += *tmpStr;
		delete tmpStr;
	}
	iconv_close(codeSet);
	fclose(fp);

	return text;
}

void WikiData::modText(wxString* intext) 
{
	delete text;
	text = new wxString(intext->c_str());
}

void WikiData::removeDataFile()
{
	char fullPath[MAX_BUF_SIZE];
	
	sprintf(fullPath, "%s/%s", (const char*)dataDirName->mb_str(), (const char*)fileName->mb_str());
	if(remove(fullPath)) {
		MN_FATAL_ERROR(wxT("remove file error"));
	}
}

void WikiData::save() 
{
	char fullPath[MAX_BUF_SIZE];
	FILE* fp;
	iconv_t     codeSet;
	char        inbuf[MAX_WIKI_TEXT_SIZE];
	char        outbuf[MAX_WIKI_TEXT_SIZE];
	const char*       inbufPtr;
	char*       outbufPtr;
	int         inbufSize;
	int         outbufSize;

	codeSet = iconv_open(CODE_SET_EUC_JP, CODE_SET_SYSTEM);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}

	sprintf(fullPath, "%s/%s", (const char*)dataDirName->mb_str(), (const char*)fileName->mb_str());
	fp = fopen(fullPath, "wb");
	if(fp == NULL) {
		MN_FATAL_ERROR(wxT("File open error."));
	}

	memset(inbuf, 0, sizeof(inbuf));
	strcpy(inbuf,(const char*)text->mb_str());
	inbufPtr = inbuf;
	inbufSize = strlen(inbufPtr);
	outbufPtr = outbuf;
	outbufSize = sizeof(outbuf);
	memset(outbuf, 0, outbufSize);
	iconv(codeSet, (const char**)&inbufPtr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);
	fwrite(outbuf, sizeof(outbuf)-outbufSize, 1, fp);
	fclose(fp);
	iconv_close(codeSet);
}

/******* Tools ************************/

static char* decode(const char* string)
{
	static char buf[MAX_BUF_SIZE];
 	char c[5];
	int i,j;
	char* endPtr = NULL;

	j = 0;
	memset(buf, 0, MAX_BUF_SIZE);	
	for(i = 0; string[i] != 0; i+=2) {
		c[0] = '0'; c[1] = 'x';
		c[2] = string[i]; c[3] = string[i+1]; c[4] = 0;
		buf[j] = strtol(c, &endPtr, 0);
		j++;
		if(j >= MAX_BUF_SIZE) {
			buf[MAX_BUF_SIZE] = 0;
			break;
		}
	}

	return buf;
}

static char* encode(const char* string)
{
	static char buf[MAX_BUF_SIZE];
	int i,j;

	j = 0;
	memset(buf, 0, MAX_BUF_SIZE);
	for(i = 0; string[i] != 0; i++) {
		snprintf(&buf[j], 3, "%02X", (unsigned char)(string[i]));
		j+=2;
		if(j >= MAX_BUF_SIZE) {
			buf[MAX_BUF_SIZE] = 0;
			break;
		}
	}
	return buf;
}

/*
 *    wiki1 > wiki2   ->  return < 0
 *    wiki1 = wiki2   ->  return = 0
 *    wiki1 < wiki2   ->  return > 0
 */
static int compWikiData(const void* wiki1, const void* wiki2)
{
	WikiData* data1 = *(WikiData**)wiki1;
	WikiData* data2 = *(WikiData**)wiki2;
	const wxString* str1 = NULL;
	const wxString* str2 = NULL;

	str1 = data1->getDate();
	str2 = data2->getDate();

	if(str1 != NULL && str2 != NULL) {
		return (strcmp(str2->mb_str(), str1->mb_str()));
	}
	else{
		return 0;
	}
}

