// -*- C++ -*- generated by wxGlade 0.3.5.1 on Wed Jun 29 12:57:38 2005

#include "mnID.h"
#include "mnDef.h"
#include "mnController.h"
#include <wx/config.h>
#include <wx/tokenzr.h>
#include <wx/utils.h>

BEGIN_EVENT_TABLE(mnController, wxEvtHandler)
	EVT_TEXT_ENTER(ID_SearchTextCtrl, mnController::handleSearch)
	EVT_TREE_SEL_CHANGED(ID_SearchTree, mnController::handleTreeItemSelect)
	EVT_TREE_SEL_CHANGING(ID_SearchTree, mnController::handleTreeItemSelecting)
	EVT_TREE_BEGIN_LABEL_EDIT(ID_SearchTree, mnController::handleBeginLabelEdit)
	EVT_TREE_END_LABEL_EDIT(ID_SearchTree, mnController::handleEndLabelEdit)
	EVT_MENU(ID_MenuFileNew, mnController::handleNewButton)
	EVT_MENU(ID_MenuFileRemove, mnController::handleRemoveButton)
	EVT_MENU(ID_MenuFileHighlight, mnController::handleHighlightButton)
	EVT_MENU(ID_MenuFileEdit, mnController::handleEditButton)
	EVT_MENU(ID_MenuFileExit, mnController::handleExit)
	EVT_MENU(ID_MenuFileConfig, mnController::handleConfig)
	EVT_MENU(wxID_ABOUT, mnController::handleAbout)
	EVT_CLOSE(mnController::handleClose)
	EVT_COMMAND(ID_HtmlTextCtrl, mnEVT_LINK_CLICK, mnController::handleLinkClick)
END_EVENT_TABLE()

mnController::mnController(mnFrame* inframe)
{
	wxString* dirName = new wxString();
	wxString gotDirName;
	wxDirDialog* dlg;

	frame = inframe;

	/* create wiki model */
	wxConfig* config = new wxConfig(wxT(CONF_APP_NAME));
	if(config->Read(wxT(CONF_WIKI_DIR), dirName) == FALSE) {
		delete dirName;
		dlg = new wxDirDialog(frame);
		if(dlg->ShowModal() == wxID_OK) {
			gotDirName = dlg->GetPath();
			wiki = new mnModel(gotDirName.mb_str());
			config->Write(wxT(CONF_WIKI_DIR), gotDirName.c_str());
		}
		else {
			frame->Close();
		}
	}
	else {
		wiki = new mnModel(dirName->mb_str());
	}

	delete config;
}

void mnController::handleConfig(wxCommandEvent& event)
{
	wxDirDialog* dlg;
	wxString gotDirName;
	wxString* dirName = new wxString();

	wxConfig* config = new wxConfig(wxT(CONF_APP_NAME));

	if(config->Read(wxT(CONF_WIKI_DIR), dirName)) {
		if(wxMessageBox(*dirName, wxT("Change data directory?"), wxYES_NO|wxICON_QUESTION) == wxNO){
			delete config;
			return;
		}
	}	

	dlg = new wxDirDialog(frame);
	if(dlg->ShowModal() == wxID_OK) {
		gotDirName = dlg->GetPath();
		delete wiki;
		wiki = new mnModel(gotDirName.mb_str());
		config->Write(wxT(CONF_WIKI_DIR), gotDirName.c_str());
	}
	delete config;

	frame->showSearchResult(wiki);
}

void mnController::handleSearch(wxCommandEvent& event)
{
	wxString* str = new wxString(event.GetString());
	WikiList*       wikiList;
	WikiList::Node* node;

	wikiList = wiki->search(str->mb_str());

	node = wikiList->GetFirst();
	if(!node) {
		wxLogMessage(wxT("Not Found! [%s]"), (const char*)str->c_str());
		return;
	}

	wiki->addSearchStr(str);
	frame->showSearchResult(wiki);
}

void mnController::handleNewButton(wxCommandEvent& event)
{
	int             ans;
	WikiData* wikiData = wiki->newWikiData();
	wxString        plainTextStr;
	wxString        newSubjectStr;
	mnWikiDataEntryDialog* dlg = new mnWikiDataEntryDialog(frame, -1, wxT("Malon Note"));
	const wxString* wikiText = wikiData->getText();
	const wxString* subject  = wikiData->getSubject();

	dlg->setSubject(*subject);
	dlg->setPlainText(*wikiText);
	ans = dlg->ShowModal();

	if(ans != wxID_OK) return ;

	plainTextStr = dlg->getPlainText();
	newSubjectStr   = dlg->getSubject();
	wikiData->modText(&plainTextStr);
	wikiData->save();

	wikiData->modSubject(&newSubjectStr);

	frame->showSearchResult(wiki);
	delete dlg;
}

void mnController::handleRemoveButton(wxCommandEvent& event)
{
	wxTreeItemData* item = frame->getSelectedItem();

	if(item){
		((WikiData*)(item))->removeDataFile();
	}
	else {
		wiki->removeSearchStr(frame->getSelectedLabel());
	}
	frame->showSearchResult(wiki);
}

void mnController::handleHighlightButton(wxCommandEvent& event)
{
	frame->highlightSelectedItem();
}


void mnController::handleTreeItemSelect(wxTreeEvent& event)
{
	frame->showSelectedItemText(event);
}


void mnController::handleTreeItemSelecting(wxTreeEvent& event)
{
}

void mnController::handleBeginLabelEdit(wxTreeEvent& event)
{
	if(!frame->isEditableTreeLabel(event.GetItem())) event.Veto();
}

void mnController::handleEndLabelEdit(wxTreeEvent& event)
{
	wxString newSubject   = event.GetLabel();
	wxTreeItemData* item  = frame->getSelectedItem();

	if(item == NULL) {
		return ;
	}
	
	if(newSubject.Len() == 0) {
		event.Veto();
		frame->showSearchResult(wiki);
		return;
	}

	((WikiData*)(item))->modSubject(&newSubject);

	event.Veto();
	frame->showSearchResult(wiki);
}

void mnController::handleClose(wxCloseEvent& event)
{
	frame->Destroy();
}

void mnController::handleExit(wxCommandEvent& event)
{
	frame->Close();
}


void mnController::handleAbout(wxCommandEvent& event)
{
	wxMessageBox(wxT(MN_APP_VERSION), wxT("Abount MalonNote"), wxOK|wxICON_INFORMATION);
}


void mnController::handleEditButton(wxCommandEvent& event)
{
	wxString        plainTextStr;
	wxString        newSubjectStr;
	wxTreeItemData* itemData = frame->getSelectedItem();
	wxString        subject  = frame->getSelectedLabel();
	mnWikiDataEntryDialog* dlg = new mnWikiDataEntryDialog(frame, -1, wxT("Malon Note"));
	int             ans;

	if(itemData == NULL) return; 
	const wxString* wikiText = ((WikiData*)(itemData))->getText();

	dlg->setSubject(subject);
	dlg->setPlainText(*wikiText);
	ans = dlg->ShowModal();

	if(ans != wxID_OK) return ;
	if(itemData == NULL) return ;

	plainTextStr = dlg->getPlainText();
	newSubjectStr   = dlg->getSubject();
	((WikiData*)(itemData))->modText(&plainTextStr);
	((WikiData*)(itemData))->save();

	((WikiData*)(itemData))->modSubject(&newSubjectStr);

	frame->showSearchResult(wiki);
	delete dlg;
}

void mnController::handleLinkClick(wxCommandEvent &event)
{
	const wxString* wikiDataDir;
	wxString href = event.GetString();
	wxString tag;
	wxString val;
	wxString doc;
	wxStringTokenizer tkz(href, wxT(":"));

	tag = tkz.GetNextToken();	
	val = tkz.GetNextToken();
	if(tag.CmpNoCase(wxT("mnlink")) == 0) {
		event.SetString(val);
		handleSearch(event);
	}
	else if(tag.CmpNoCase(wxT("mndoc")) == 0) {
		wikiDataDir = wiki->getWikiDataDir();
		doc = *wikiDataDir + wxT("/docs/") + val;
		openDoc(doc);
	}
	else {
		openUrl(href);
	}
}

void mnController::openUrl(wxString& url)
{
	wxString cmd;

#ifdef __WXMSW__
	cmd.sprintf(wxT("explorer %s"), url.c_str());
#endif

#ifdef __WXMAC__
	cmd.sprintf(wxT("open %s"), url.c_str());
#endif

#ifdef __WXCOCOA__
	cmd.sprintf(wxT("open %s"), url.c_str());
#endif

#ifdef __WXGTK__
	cmd.sprintf(wxT("gnome-open %s"), url.c_str());
#endif

	//wxExecute(argv);
	wxExecute(cmd);
}

void mnController::openDoc(wxString& doc)
{
	wxString cmd;

#ifdef __WXMSW__
	cmd.sprintf(wxT("cmd /c \"start %s\""), doc.c_str());
#endif

#ifdef __WXMAC__
	cmd.sprintf(wxT("open %s"), doc.c_str());
#endif

#ifdef __WXCOCOA__
	cmd.sprintf(wxT("open %s"), doc.c_str());
#endif

#ifdef __WXGTK__
	cmd.sprintf(wxT("gnome-open %s"), doc.c_str());
#endif

	wxExecute(cmd);
}
