// -*- C++ -*- generated by wxGlade 0.3.5.1 on Wed Jun 29 12:57:38 2005
#include <wx/regex.h>
#include <wx/tokenzr.h>
#include "mnID.h"
#include "mnDef.h"
#include "mnFrame.h"
#include "mnDialog.h"


mnFrame::mnFrame(wxWindow* parent, int id, const wxString& title, const wxPoint& pos, const wxSize& size, long style):
    wxFrame(parent, id, title, pos, size, wxDEFAULT_FRAME_STYLE)
{
    // begin wxGlade: mnFrame::mnFrame
    splitWindow = new wxSplitterWindow(this, -1, wxDefaultPosition, wxDefaultSize, wxSP_3D|wxSP_BORDER);
    rightPanel = new wxPanel(splitWindow, -1);
    leftPanel = new wxPanel(splitWindow, -1);
    panel = new wxPanel(this, -1);
    searchLaebl = new wxStaticText(panel, -1, wxT("Search"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    searchTextCtrl = new wxTextCtrl(this, ID_SearchTextCtrl, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER);
    searchTree = new wxTreeCtrl(leftPanel, ID_SearchTree, wxDefaultPosition, wxDefaultSize, wxTR_HAS_BUTTONS|wxTR_LINES_AT_ROOT|wxTR_DEFAULT_STYLE|wxSUNKEN_BORDER|wxTR_EDIT_LABELS);
	wikiHtmlTextCtrl = new mnHtmlWindow(rightPanel, ID_HtmlTextCtrl);

    // begin add by hand
    menuBar = new wxMenuBar();
    SetMenuBar(menuBar);

	// File menu
    wxMenu* tmp_menu_1 = new wxMenu();
    tmp_menu_1->Append(ID_MenuFileNew, _("New\tCtrl+N"), wxT(""), wxITEM_NORMAL);
    tmp_menu_1->Append(ID_MenuFileEdit, _("Edit\tCtrl+E"), wxT(""), wxITEM_NORMAL);
    tmp_menu_1->Append(ID_MenuFileRemove, _("Remove\tCtrl+R"), wxT(""), wxITEM_NORMAL);
    tmp_menu_1->Append(ID_MenuFileHighlight, _("Highlight\tCtrl+L"), wxT(""), wxITEM_NORMAL);
	tmp_menu_1->AppendSeparator();
    tmp_menu_1->Append(ID_MenuFileGroup, _("Group by TYPE\tCtrl+G"), wxT(""), wxITEM_NORMAL);
	tmp_menu_1->AppendSeparator();
    tmp_menu_1->Append(ID_MenuFileConfig, _("Configure..."), wxT(""), wxITEM_NORMAL);
	tmp_menu_1->AppendSeparator();
    tmp_menu_1->Append(ID_MenuFileExit, _("Quit\tCtrl+Q"), wxT(""), wxITEM_NORMAL);
	menuBar->Append(tmp_menu_1, _("&File"));
	
	// Tree menu
    wxMenu* tmp_menu_3 = new wxMenu();
    tmp_menu_3->Append(ID_MenuTreeExpand, _("Expand All\tCtrl+D"), wxT(""), wxITEM_NORMAL);
    tmp_menu_3->Append(ID_MenuTreeCollapse, _("Collapse All\tCtrl+U"), wxT(""), wxITEM_NORMAL);
    tmp_menu_3->Append(ID_MenuTreeClear, _("Clear All\tCtrl+K"), wxT(""), wxITEM_NORMAL);
	//tmp_menu_3->AppendSeparator();
    //tmp_menu_3->AppendCheckItem(ID_MenuTreeDisableUpdate, _("Disable AutoUpdate"));
	menuBar->Append(tmp_menu_3, _("&Tree"));

	// Help menu
    wxMenu* tmp_menu_2 = new wxMenu();
    tmp_menu_2->Append(wxID_ABOUT, _("&About"), wxT(""), wxITEM_NORMAL);
	menuBar->Append(tmp_menu_2, _("&Help"));

#ifdef __WXMSW__
    wxIcon icon(wxT(APP_ICON_NAME), wxBITMAP_TYPE_ICO_RESOURCE);
    SetIcon(icon);
#endif
    // end add by hand
    
    set_properties();
    do_layout();
    // end wxGlade

	/* create search tree */
	searchItemRoot = searchTree->AddRoot(wxT(LABEL_ITEM_TREE), -1, -1, NULL);
}

void mnFrame::set_properties()
{
    // begin wxGlade: mnFrame::set_properties
    SetTitle(wxT("Malon Note"));
    SetSize(wxSize(900, 572));
    searchTextCtrl->SetFocus();
    // end wxGlade

	wxFont font(12, wxFONTFAMILY_DEFAULT, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL);	
	wikiHtmlTextCtrl->SetFonts(font.GetFaceName(), font.GetFaceName());
}


void mnFrame::do_layout()
{
    wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);
    rightPanelSizer = new wxGridSizer(1, 1, 0, 0);
    wxBoxSizer* leftPanelSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* topSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* labelSizer = new wxBoxSizer(wxHORIZONTAL);
    labelSizer->Add(searchLaebl, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    panel->SetAutoLayout(true);
    panel->SetSizer(labelSizer);
    labelSizer->Fit(panel);
    labelSizer->SetSizeHints(panel);
    topSizer->Add(panel, 0, wxEXPAND, 0);
    topSizer->Add(searchTextCtrl, 1, wxTOP|wxBOTTOM|wxEXPAND|wxFIXED_MINSIZE, 1);
    mainSizer->Add(topSizer, 0, wxEXPAND, 0);
    leftPanelSizer->Add(searchTree, 1, wxEXPAND, 0);
    leftPanel->SetAutoLayout(true);
    leftPanel->SetSizer(leftPanelSizer);
    leftPanelSizer->Fit(leftPanel);
    leftPanelSizer->SetSizeHints(leftPanel);
    rightPanelSizer->Add(wikiHtmlTextCtrl, 0, wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    rightPanel->SetAutoLayout(true);
    rightPanel->SetSizer(rightPanelSizer);
    rightPanelSizer->Fit(rightPanel);
    rightPanelSizer->SetSizeHints(rightPanel);
    splitWindow->SplitVertically(leftPanel, rightPanel, 250);
    mainSizer->Add(splitWindow, 1, wxEXPAND, 0);
    SetAutoLayout(true);
    SetSizer(mainSizer);
    Layout();

	searchTree->Expand(searchItemRoot);
}

void mnFrame::showSearchResult(mnModel* wiki, bool isExpand)
{
	wxLogMessage(wxT("showSearchResult is not available"));
}

void mnFrame::updateSearchResult(mnModel* wiki, wxString* searchStr, bool isExpand)
{
	wxTreeItemIdValue cookie1, cookie2;
	wxTreeItemId      searchStrId;
	wxTreeItemId      wikiDataId;
	const WikiList* wikiList;
	WikiList::Node* node;
	WikiData*       data;
	const wxString* subject;

	memset(&cookie1, 1, sizeof(cookie1));
	memset(&cookie2, 2, sizeof(cookie2));
	searchStrId = searchTree->GetFirstChild(searchItemRoot, cookie1);
	while(searchStrId.IsOk()) {
		if(searchTree->GetItemText(searchStrId) == *searchStr) {
			wikiDataId = searchTree->GetFirstChild(searchStrId, cookie2);
			while(wikiDataId.IsOk()) {
				searchTree->SetItemData(wikiDataId, NULL);
				wikiDataId = searchTree->GetNextChild(searchStrId, cookie2);
			}
			searchTree->DeleteChildren(searchStrId);
			break;
		}		
		searchStrId = searchTree->GetNextChild(searchItemRoot, cookie1);
	}

	wikiList = wiki->getSearchResultList(searchStr);
	if(wikiList == NULL) {
		MN_FATAL_ERROR(wxT("wikiList is null"));
		return;
	}

	node = wikiList->GetFirst();
	while(node) {
		data = node->GetData();
		subject = data->getSubject();
		searchTree->AppendItem(searchStrId, *subject, -1, -1, (wxTreeItemData*)data);
		node = node->GetNext();
	}
	if(isExpand){
	   	searchTree->Expand(searchStrId);
	}
	else {
	   	searchTree->Collapse(searchStrId);
	}
}

void mnFrame::addSearchResult(mnModel* wiki, wxString* searchStr, bool isExpand)
{
	wxTreeItemId    searchItem;
	const WikiList* wikiList;
	WikiList::Node* node;
	WikiData*       data;
	const wxString* subject;

	wikiList = wiki->getSearchResultList(searchStr);
	if(wikiList == NULL) {
		MN_FATAL_ERROR(wxT("wikiList is null"));
		return;
	}

	//searchItem = searchTree->AppendItem(searchItemRoot, *searchStr, -1, -1, NULL);
	searchItem = searchTree->InsertItem(searchItemRoot, 0, *searchStr, -1, -1, NULL);
	node = wikiList->GetFirst();
	while(node) {
		data = node->GetData();
		subject = data->getSubject();
		searchTree->AppendItem(searchItem, *subject, -1, -1, (wxTreeItemData*)data);
		node = node->GetNext();
	}

	searchTree->Expand(searchItemRoot);
	if(isExpand){
	   	searchTree->Expand(searchItem);
	}
	else {
	   	searchTree->Collapse(searchItem);
	}
}

void mnFrame::makeHtml(WikiData* wikiData, bool isHighlight)
{
	const wxString* fileName = wikiData->getFileName();
	const wxString* wikiText = wikiData->getText();
	wxString htmlText(*wikiText);

	/* escape < */
	wxRegEx exp01(wxT("<"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp01.Replace(&htmlText, wxT("\\&lt "));

	/* escape > */
	wxRegEx exp02(wxT(">"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp02.Replace(&htmlText, wxT("\\&gt "));
	
	/* [[ ]] */
	wxRegEx exp1(wxT("\\[\\[([^\\}]+)\\]\\]"));
	exp1.Replace(&htmlText, wxT("<a href=mnlink:\\1>\\1</a>"));

 	/* http://  */	
	wxRegEx exp2(wxT("(http://[-_.!~*'a-zA-Z0-9;/?:@&=+$,%#]+)"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp2.Replace(&htmlText, wxT("<a href=\\1>\\1</a>"));

 	/* file://  */	
	wxRegEx exp3(wxT("(file://[^ ]+)"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp3.Replace(&htmlText, wxT("<a href=\\1>\\1</a>"));

	/* *XXXX */
	wxRegEx exp4(wxT("^\\*([^\\*]+)"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp4.Replace(&htmlText, wxT("<h3>\\1</h3>"));
	
	/* **XXXX */
	wxRegEx exp5(wxT("^\\*\\*([^\\*]+)"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp5.Replace(&htmlText, wxT("<h4>\\1</h4>"));
	
	/* :''XXXX'': */
	wxRegEx exp6(wxT("^:''(.+)'':(.+)"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp6.Replace(&htmlText, wxT("<u><b>\\1:\\2</b></u>"));

	/* ---- */
	wxRegEx exp7(wxT("^----.*"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp7.Replace(&htmlText, wxT("<hr>"));

	/* {{ }} */
	wxRegEx exp8(wxT("\\{\\{([^\\}]+)\\}\\}"));
	exp8.Replace(&htmlText, wxT("<a href=mndoc:\\1>\\1</a>"));

	/* Highlight search text */
	highlight = isHighlight;
	if(isHighlight) {
        wxTreeItemId parentId = searchTree->GetItemParent(searchTree->GetSelection());
		wxString     searchWords = searchTree->GetItemText(parentId);
		wxStringTokenizer tkz(searchWords, wxT(" "));
		while ( tkz.HasMoreTokens() )
		{
			wxString token = tkz.GetNextToken();
			wxRegEx exp9(wxT("(?!<[^>]+)(") + token + wxT(")(?![^<]+>)"), wxRE_ADVANCED|wxRE_ICASE|wxRE_NEWLINE);
			exp9.Replace(&htmlText, wxT("<b><font color=\"red\">\\1</font></b>"));
		}
	}

	
	/* make HTML document */
	wxString wikiHtml;
	wikiHtml.Append(wxT("<meta http-equiv=\"Content-Type\"content=\"text/html; charset="));
	wikiHtml.Append(wxT(CODE_SET_SYSTEM));
	wikiHtml.Append(wxT("\">"));
	wikiHtml.Append(wxT("<pre>"));
	wikiHtml.Append(htmlText);
	wikiHtml.Append(wxT("</pre>"));

	wikiHtmlTextCtrl->SetPage(wikiHtml);
}

void mnFrame::showSelectedItemText(wxTreeEvent& event)
{
	wxTreeItemId    id;
	wxTreeItemData* item;

	id = searchTree->GetSelection();
	item = searchTree->GetItemData(id);

	if(!id.IsOk() || !isEditableTreeLabel(id) || item == NULL) { /* selection is not memo data */
		wikiHtmlTextCtrl->SetPage(wxT(""));
		return;
	}
	makeHtml((WikiData*)item, false);
}

wxTreeItemId mnFrame::getSelection()
{
	return searchTree->GetSelection();
}

void mnFrame::highlightSelectedItem()
{
	wxTreeItemData* item    = getSelectedItem();
	
	if(!isEditableTreeLabel(searchTree->GetSelection())) { /* selection is not memo data */
		wikiHtmlTextCtrl->SetPage(wxT(""));
		return;
	}

	if(highlight){
		makeHtml((WikiData*)item, false);
	}
	else {
		makeHtml((WikiData*)item, true);
	}
}

void mnFrame::expandAllTree()
{
	wxTreeItemIdValue cookie;
	wxTreeItemId      itemId;

	memset(&cookie, 1, sizeof(cookie));
	itemId = searchTree->GetFirstChild(searchItemRoot, cookie);
	while(itemId.IsOk()) {
		searchTree->Expand(itemId);	
		itemId = searchTree->GetNextChild(searchItemRoot, cookie);
	}
}

void mnFrame::collapseAllTree()
{
	wxTreeItemIdValue cookie;
	wxTreeItemId      itemId;

	memset(&cookie, 1, sizeof(cookie));
	itemId = searchTree->GetFirstChild(searchItemRoot, cookie);
	while(itemId.IsOk()) {
		searchTree->Collapse(itemId);	
		itemId = searchTree->GetNextChild(searchItemRoot, cookie);
	}
}

void mnFrame::clearAllTree()
{
	wxTreeItemIdValue cookie1, cookie2;
	wxTreeItemId      searchStrId;
	wxTreeItemId      wikiDataId;

	memset(&cookie1, 1, sizeof(cookie1));
	memset(&cookie2, 2, sizeof(cookie2));
	searchStrId = searchTree->GetFirstChild(searchItemRoot, cookie1);
	while(searchStrId.IsOk()) {
		wikiDataId = searchTree->GetFirstChild(searchStrId, cookie2);
		while(wikiDataId.IsOk()) {
			searchTree->SetItemData(wikiDataId, NULL);
			wikiDataId = searchTree->GetNextChild(searchStrId, cookie2);
		}
		searchStrId = searchTree->GetNextChild(searchItemRoot, cookie1);
	}

	searchTree->DeleteChildren(searchItemRoot);
}

void mnFrame::removeSelectedItem()
{
	searchTree->Delete(searchTree->GetSelection());
}

wxTreeItemData* mnFrame::getSelectedItem()
{
	return searchTree->GetItemData(searchTree->GetSelection());
}

wxString mnFrame::getSelectedLabel()
{
	return searchTree->GetItemText(searchTree->GetSelection());
}

bool mnFrame::isEditableTreeLabel(wxTreeItemId id)
{
	if(id.IsOk()){ 
		return !(searchTree->GetItemParent(id) == searchItemRoot || id == searchItemRoot);
	}
	else {
		return false;
	}
}

