#include <wx/wx.h>
#include <wx/regex.h>
#include <wx/tokenzr.h>
#include <wx/xrc/xmlres.h>
#include "mnDef.h"
#include "mnFrame.h"
#include "mnNotePanel.h"
#include "mnNotePanelController.h"


mnFrame::mnFrame(wxWindow* parent)
{
	wxXmlResource::Get()->LoadFrame(this, parent, wxT("mnFrame"));

#ifdef __WXMSW__
    wxIcon icon(wxT(APP_ICON_NAME), wxBITMAP_TYPE_ICO_RESOURCE);
    SetIcon(icon);
#endif
    
	/* init members */
	searchTextCtrl   = XRCCTRL(*this, "searchTextCtrl", wxTextCtrl);
	noteBook         = XRCCTRL(*this, "noteBook", wxNotebook);

	CreateStatusBar();
}

void mnFrame::setFocusToSearchTextCtrl()
{
	searchTextCtrl->SetFocus();
}

void mnFrame::addNotePanel(wxString* dirName)
{
	mnNotePanel* panel = new mnNotePanel(noteBook, dirName);
	wxFileName fileName(*dirName);

	noteBook->AddPage(panel, fileName.GetName(), true);  // only filename as page title

	setFocusToSearchTextCtrl();
}

void mnFrame::removeSelectedNotePanel()
{
	noteBook->DeletePage(noteBook->GetSelection());
}

mnNotePanel* mnFrame::getNotePanel()
{
	int selection = noteBook->GetSelection();

	return (mnNotePanel*)noteBook->GetPage(selection);
}

wxNotebook* mnFrame::getNotebook()
{
	return noteBook;
}
