// -*- C++ -*- generated by wxGlade 0.3.5.1 on Wed Jun 29 12:57:38 2005

#include "mnID.h"
#include "mnDef.h"
#include "mnFrameController.h"
#include "mnNotePanelController.h"
#include <wx/config.h>
#include <wx/tokenzr.h>
#include <wx/utils.h>
#include <wx/xrc/xmlres.h>

BEGIN_EVENT_TABLE(mnFrameController, wxEvtHandler)
	EVT_TEXT_ENTER(XRCID("searchTextCtrl"), mnFrameController::handleSearch)
	EVT_MENU(XRCID("New"), mnFrameController::handleNew)
	EVT_MENU(XRCID("Remove"), mnFrameController::handleRemove)
	EVT_MENU(XRCID("Edit"), mnFrameController::handleEdit)
	EVT_MENU(XRCID("Highlight"), mnFrameController::handleHighlight)
	EVT_MENU(XRCID("Expand"), mnFrameController::handleTreeExpand)
	EVT_MENU(XRCID("Collapse"), mnFrameController::handleTreeCollapse)
	EVT_MENU(XRCID("Clear"), mnFrameController::handleTreeClear)
	EVT_MENU(XRCID("Group"), mnFrameController::handleGroup)
	EVT_MENU(XRCID("OpenDocsDir"), mnFrameController::handleOpenDocsDir)
	EVT_MENU(XRCID("AddDir"), mnFrameController::handleAddDir)
	EVT_MENU(XRCID("RemoveDir"), mnFrameController::handleRemoveDir)
	EVT_MENU(XRCID("Quit"), mnFrameController::handleExit)
	EVT_MENU(XRCID("FastSearch"), mnFrameController::handleFastSearch)
	EVT_MENU(wxID_ABOUT, mnFrameController::handleAbout)
	EVT_CLOSE(mnFrameController::handleClose)
	EVT_NOTEBOOK_PAGE_CHANGED(XRCID("noteBook"), mnFrameController::handlePageChange)
	EVT_TIMER(wxID_ANY, mnFrameController::handleDiskSearchTimer)
END_EVENT_TABLE()

mnFrameController::mnFrameController(mnFrame* inframe)
{
	frame = inframe;

	diskSearchTimer = new wxTimer(this);
	diskSearchTimer->Start(MN_READ_INTERVAL, wxTIMER_CONTINUOUS);
}

void mnFrameController::readAll(bool flag)
{
	int count = 0;
	mnNotePanel* panel;
	mnNotePanelController* controller;

	count = frame->getNotebook()->GetPageCount();
	for(int i = 0; i < count; i++)
	{
		panel = (mnNotePanel*)frame->getNotebook()->GetPage(i);
		controller = panel->getController();
		controller->readAll(flag);
	}
}

void mnFrameController::handleDiskSearchTimer(wxTimerEvent& event)
{
	readAll(false); /* search disk background */
}

void mnFrameController::handleConfig(wxCommandEvent& event)
{
	wxLogMessage(wxT("Config..."));
}

void mnFrameController::handleSearch(wxCommandEvent& event)
{
	frame->getNotePanel()->getController()->handleSearch(event);
}

void mnFrameController::handleNew(wxCommandEvent& event)
{
	frame->getNotePanel()->getController()->handleNew(event);
}

void mnFrameController::handleRemove(wxCommandEvent& event)
{
	frame->getNotePanel()->getController()->handleRemove(event);
}

void mnFrameController::handleEdit(wxCommandEvent& event)
{
	frame->getNotePanel()->getController()->handleEdit(event);
}

void mnFrameController::handleHighlight(wxCommandEvent& event)
{
	frame->getNotePanel()->getController()->handleHighlight(event);
}

void mnFrameController::handleTreeExpand(wxCommandEvent& event)
{
	frame->getNotePanel()->getController()->handleTreeExpand(event);
}

void mnFrameController::handleTreeCollapse(wxCommandEvent& event)
{
	frame->getNotePanel()->getController()->handleTreeCollapse(event);
}

void mnFrameController::handleTreeClear(wxCommandEvent& event)
{
	frame->getNotePanel()->getController()->handleTreeClear(event);
}

void mnFrameController::handleGroup(wxCommandEvent& event)
{
	frame->getNotePanel()->getController()->handleGroup(event);
}

void mnFrameController::handleOpenDocsDir(wxCommandEvent& event)
{
	frame->getNotePanel()->getController()->handleOpenDocsDir(event);
}

void mnFrameController::handleClose(wxCloseEvent& event)
{
	frame->Destroy();
}

void mnFrameController::handleExit(wxCommandEvent& event)
{
	frame->Close();
}

void mnFrameController::handleFastSearch(wxCommandEvent& event)
{
	if( event.IsChecked() ) {
		readAll(true); /* Search disk foreground */
		diskSearchTimer->Start(MN_READ_INTERVAL, wxTIMER_CONTINUOUS);
	}
	else {
		diskSearchTimer->Stop();
	}
}


void mnFrameController::handleAbout(wxCommandEvent& event)
{
	wxMessageBox(wxT(MN_APP_VERSION), wxT("Abount MalonNote"), wxOK|wxICON_INFORMATION);
}

void mnFrameController::handleAddDir(wxCommandEvent& event)
{
	wxDirDialog* dlg;
	wxString gotDirName;
	wxString* dirName = new wxString();
	
	dlg = new wxDirDialog(frame);
	if(dlg->ShowModal() == wxID_OK) {
		gotDirName = dlg->GetPath();
		if(isExistConfig(&gotDirName) == false){
			frame->addNotePanel(&gotDirName);
		}
		else {
			wxMessageBox(wxT("It already exist in MalonNote"), wxT("Already exist"), wxOK|wxICON_INFORMATION);
			return;
		}
	}
	updateConfig();
}

void mnFrameController::handleRemoveDir(wxCommandEvent& event)
{
	frame->removeSelectedNotePanel();
	updateConfig();
}

void mnFrameController::updateConfig()
{
	wxString  confKey;
	wxNotebook* notebook;
	mnNotePanel* panel;

	wxConfig* config = new wxConfig(wxT(CONF_APP_NAME));
	config->DeleteAll();
	delete config;
	config = new wxConfig(wxT(CONF_APP_NAME)); // recreate config object
	notebook = frame->getNotebook();
	int count = notebook->GetPageCount();
	for(int i = 0; i < count; i++) {
		panel = (mnNotePanel*)notebook->GetPage(i);
		const wxString* dataDir = panel->getController()->getWikiDataDir();

		if(i == 0){
			config->Write(wxT(CONF_WIKI_DIR), dataDir->c_str());
		}
		else{
 			confKey.sprintf(wxT(CONF_WIKI_DIR) "%d", i);
			config->Write(confKey.c_str(), dataDir->c_str());
		}
	}
	delete config;
}

bool mnFrameController::isExistConfig(wxString* dir)
{
	wxString* dirName = new wxString();
	wxString gotDirName;
	wxDirDialog* dlg;
	wxString confKey;

	wxConfig* config = new wxConfig(wxT(CONF_APP_NAME));
	for(int i = 0; ;i++) {
		if(i == 0) {
			confKey.sprintf(wxT(CONF_WIKI_DIR));
		}
		else {
 			confKey.sprintf(wxT(CONF_WIKI_DIR) "%d", i);
		}
		if(config->Read(confKey.c_str(), dirName)) {
			if(*dir == *dirName) return true;    /* Exist */
		}
		else {
			break;
		}
	}
	
	delete dirName;
	delete config;

	return false;
}


void mnFrameController::handlePageChange(wxNotebookEvent& event) 
{
	wxNotebook* notebook;
	mnNotePanel* panel;

	notebook = frame->getNotebook();
	panel = (mnNotePanel*)notebook->GetPage(event.GetSelection());
	const wxString* dataDir = panel->getController()->getWikiDataDir();

	frame->GetStatusBar()->SetStatusText(*dataDir);
}
