package mandelbrotExplorer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class MandelbrotDrawing extends Thread {
	private MandelbrotSet ms;
	private BufferedImage image;
	private Rectangle rect;
	private MandelbrotImage mandelbrotImage;
	private Point offset;
	private boolean stop=false;

	
	public MandelbrotDrawing(MandelbrotSet ms,Rectangle r,MandelbrotImage mi){
		this.ms = ms;
		this.rect = new Rectangle(r);
		this.mandelbrotImage = mi;
		offset = new Point(rect.x,rect.y);
	}
	
	public void moveOffset(Point distance){
		offset.translate(distance.x,distance.y);
	}
	
	public void run() {
		if( rect.width<= 0  || rect.height<= 0 ) {
			return;
		}
		System.out.printf("start %s:offset(%d,%d):size(%d,%d)\n",Thread.currentThread().getName(),offset.x,offset.y,rect.width,rect.height );
		image = new BufferedImage(rect.width ,rect.height, BufferedImage.TYPE_INT_BGR); 
		Graphics2D g = image.createGraphics();

		Point p = new Point(0,0);

		for(p.x=0; p.x<image.getWidth() && !stop; ++p.x){
			for( p.y=0; p.y<image.getHeight() && !stop; ++p.y){
				g.setColor( getColor( ms , rect.x + p.x , rect.y + p.y ) );
				g.fillRect(p.x, p.y, 1, 1);
			}
		}
		if( !stop ) {
			System.out.printf("end   %s:offset(%d,%d):size(%d,%d)\n",Thread.currentThread().getName(),offset.x,offset.y,rect.width,rect.height );
			mandelbrotImage.paintImageThread(this);   // imagem点A`˗
		}else{
			System.out.printf("stop  %s:offset(%d,%d):size(%d,%d)\n",Thread.currentThread().getName(),offset.x,offset.y,rect.width,rect.height );
		}
	}
	
	public void stopDrawing(){
		stop = true;
	}
	
	public BufferedImage getImage(){
		return image;
	}
	
	public Rectangle getRect(){
		return new Rectangle(rect);
	}
	
	public Point getOffset(){
		return new Point(offset);
	}
	
	private Color getColor(MandelbrotSet ms,int r,int i){
		Color rc;
		int nc;

		nc = (int)(ms.calcMandel(r , i , 511));
		
		if( nc>=0 ){
			rc = new Color(((nc>>3)%8)*32 , (nc%8)*32,((nc>>6)%8)*32);
		}else{
			rc = new Color(0,0,0);
		}
		return rc;
	}

}
