package mandelbrotExplorer;

import java.util.HashMap;

public class DebugThread {
	private static HashMap<String,String> threadTab = new HashMap<String,String>();
	private static int tabCount=0;
	
	public synchronized static String tab(){
		String threadName = Thread.currentThread().getName();
		String r = threadTab.get(threadName);
		if( r!=null && r.getClass()==String.class ){
			return r;
		}
		r = "";
		for(int i=0;i<tabCount;++i){
			r = r.concat("\t");
		}
		//r = r + String.format("[%d]", tabCount);
		r = r + String.format("[%s]", threadName);
		threadTab.put(threadName,r);
		tabCount++;
		return r;
	}
	
	public synchronized static void printf(String format, Object ... args){
		System.out.print( DebugThread.tab() +  String.format(format, args) );
	}

}
