package mandelbrotExplorer;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.concurrent.Callable;

public class DrawingTask implements Callable<ImagePiece>  {
	private MandelbrotSet ms;
	private Rectangle rect;
	
	private int state;
	public static final int NEW=0;
	public static final int RUNNING=1;
	public static final int TERMINATE=2;
	public static final int TERMINATED=3;
	
	public DrawingTask(MandelbrotSet ms,Rectangle r){
		if( r.isEmpty() ){ return; }
		this.ms = ms;
		this.rect = new Rectangle(r);
		state = NEW;
	}
	
	public void stop(){
		state = TERMINATE;
	}

	public ImagePiece call() {
		state=RUNNING;
		if( rect==null || rect.width<= 0  || rect.height<= 0 ) {
			state = TERMINATED;
			return null;
		}

		//DebugThread.printf("start:offset(%d,%d):size(%d,%d)\n",rect.x,rect.y,rect.width,rect.height );
		BufferedImage image = new BufferedImage(rect.width ,rect.height, BufferedImage.TYPE_INT_BGR);
		WritableRaster raster = image.getRaster();

		Point p = new Point(0,0);

		for(p.x=0; p.x<image.getWidth() && state!=TERMINATE; ++p.x){
			for( p.y=0; p.y<image.getHeight() && state!=TERMINATE; ++p.y){
				raster.setPixel( p.x, p.y, getRGB( ms , rect.x + p.x , rect.y + p.y ) );
			}
		}
		
		ImagePiece ip;
		if( state!=TERMINATE ) {
			//DebugThread.printf("end :offset(%d,%d):size(%d,%d)\n",rect.x,rect.y,rect.width,rect.height );
			ip = new ImagePiece(raster , rect);
		}else{
			//DebugThread.printf("stop :offset(%d,%d):size(%d,%d)\n",rect.x,rect.y,rect.width,rect.height );
			ip = new ImagePiece(null , rect );
		}
		state = TERMINATED;
		return ip;
	}
	
	public Rectangle getRect(){
		return new Rectangle(rect);
	}
	
	private int[] getRGB(MandelbrotSet ms,int r,int i){
		int d[]=new int[3];
		int nc;

		nc = (int)(ms.calcMandel(r , i , 511));
		
		if( nc>=0 ){
			d[0] = ((nc>>3)%8)*32;	// R
			d[1] = (nc%8)*32;		// G
			d[2] = ((nc>>6)%8)*32;	// B
		}else{
			d[0] = 0;
			d[1] = 0;
			d[2] = 0;
		}
		return d;
	}

	public final int getState() {
		return state;
	}

}
