package mandelbrotExplorer;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MandelbrotThreadExecutor extends ThreadPoolExecutor {
	private MandelbrotImage mi;
	volatile private int taskCount;
	
	public MandelbrotThreadExecutor(MandelbrotImage mi) {
		// Executors.newCachedThreadPool();
		super(0, Integer.MAX_VALUE,
				60L, TimeUnit.SECONDS,
				new SynchronousQueue<Runnable>());
		this.mi = mi;
		taskCount=0;
	}
	public void addTaskCount(int n){
		taskCount+=n;
	}
	
	public boolean isEmptyTask(){
		return taskCount==0;
	}
	
	
	@Override
	protected void beforeExecute(Thread t, Runnable r) {
		super.beforeExecute(t, r);
		
		//DebugThread.printf("beforeExecute,threadCount %d\n",this.taskCount);
		
		//threadCount++;
		//System.out.println("beforeExecute,threadCount "+this.threadCount);
	}

	@Override
	protected void afterExecute(Runnable r, Throwable t) {
		taskCount--;
		//DebugThread.printf("afterExecute,threadCount %d\n",this.taskCount);
		if( taskCount==0 ){
			mi.paintImagePiece();
		}
		
		super.afterExecute(r, t);
	}

	@Override
	protected void terminated() {
		super.terminated();
	}

}
