/*******************************************************************************
 * ManjyuBase64
 * Copyright (C) 2012 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2012 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright 2012 Toshiki IGA and others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.manjyu.base64;

import java.util.HashMap;
import java.util.Map;

/**
 * Class for convert Base64 as URL.
 * 
 * @author Toshiki Iga
 */
class Base64ForUrl extends Base64Rfc2045 {
	/**
	 * Convert table for URL MIME Base64
	 */
	private static final char[] BASE64_CONVERT_TABLE = { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L',
			'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g',
			'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1',
			'2', '3', '4', '5', '6', '7', '8', '9', '-'/* + to - */, '_'/*/ to _ */, '=' /* END OF MIME Base64 */};

	char[] getBase64ConvertTable() {
		return BASE64_CONVERT_TABLE;
	}

	/**
	 * Cache map for BASE 64 CONVERT TABLE.
	 */
	private static final Map<String, Integer> mapBase64ConvertTabelForUrlBase64 = new HashMap<String, Integer>();

	int convertChar2Index(final char cRead) {
		synchronized (mapBase64ConvertTabelForUrlBase64) {
			if (mapBase64ConvertTabelForUrlBase64.isEmpty()) {
				for (int index = 0; index < getBase64ConvertTable().length; index++) {
					mapBase64ConvertTabelForUrlBase64.put(String.valueOf(getBase64ConvertTable()[index]),
							Integer.valueOf(index));
				}
			}

			final Integer lookup = mapBase64ConvertTabelForUrlBase64.get(String.valueOf(cRead));
			if (lookup == null) {
				return -1;
			}

			return lookup.intValue();
		}
	}
}
