/*******************************************************************************
 * ManjyuJsf
 * Copyright (C) 2012 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2012 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright 2012 Toshiki IGA and others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.manjyu.jsf;

import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * JavaServer Faces Servlet Utility for Java.
 * 
 * @author Toshiki Iga
 */
public class ManjyuJsfServletUtil {
	/**
	 * Hide default constructor.
	 */
	private ManjyuJsfServletUtil() {
	}

	/**
	 * Get FacesContext for Servlet.
	 * 
	 * @param request Servlet request.
	 * @param response Servlet response.
	 * @return FacesContext instance.
	 */
	public static FacesContext getFacesContext(final HttpServletRequest request, final HttpServletResponse response) {
		final FacesContext currentFacesContextOnThreadLocal = FacesContext.getCurrentInstance();
		if (currentFacesContextOnThreadLocal != null) {
			return currentFacesContextOnThreadLocal;
		} else {
			final FacesContextFactory facesContextFactory = (FacesContextFactory) FactoryFinder
					.getFactory(FactoryFinder.FACES_CONTEXT_FACTORY);
			final LifecycleFactory lifecycleFactory = (LifecycleFactory) FactoryFinder
					.getFactory(FactoryFinder.LIFECYCLE_FACTORY);
			final Lifecycle defaultLifecycle = lifecycleFactory.getLifecycle(LifecycleFactory.DEFAULT_LIFECYCLE);
			final FacesContext foundFacesContext = facesContextFactory.getFacesContext(request.getSession()
					.getServletContext(), request, response, defaultLifecycle);
			PrivateHiddenLocalFacesContext.setFacesContext(foundFacesContext);
			foundFacesContext.setViewRoot(foundFacesContext.getApplication().getViewHandler()
					.createView(foundFacesContext, ""));
			return foundFacesContext;
		}
	}

	/**
	 * Class to remember FacesContext on thread local.
	 */
	private abstract static class PrivateHiddenLocalFacesContext extends FacesContext {
		/**
		 * Set FacesContext to thread local.
		 * 
		 * @param facesContext FacesContext instance to set thread local.
		 */
		protected static void setFacesContext(final FacesContext facesContext) {
			FacesContext.setCurrentInstance(facesContext);
		}
	}
}
