;GIMP Script-Fu Mansiki Libs
;Tiny-fu版に変更
(define ( Mansiki-ini ) 
	(gimp-message  "ini")
	
)

;--------------------------------------------------iniファイル名
(define ( MSK-getINIFileName) 
    "mansiki/init/Mansiki.ini"
)
;--------------------------------------------------
(define ( MSK-exceptINIComments input) 
    (MSK-getValueByIndex (MSK-split input ";") 0)
)
;--------------------------------------------------
(define ( MSK-parseBigSect input) 
	(let* (
	        (result "")
	    )
        (if (>= (MSK-index "[" input 0) 0)
            (begin 
                (set! result (MSK-getValueByIndex (MSK-split input "[")1))
                (if (>= (MSK-index "]" result 0) 0)
                    (MSK-getValueByIndex (MSK-split result "]")0)
                    ""
                )
            )
            result
        )
    )
)
;--------------------------------------------------
(define ( MSK-LoadINI) 
	(let* (
			(iniRows (MSK-ReadIn ( MSK-getINIFileName) ))
			(iniRowsCount (MSK-count iniRows))
			(count 0)
			(bigSect "")
			(row "")
			(result (list ""))b
		)
		
		(while (> iniRowsCount count)
		    (set! row (MSK-getValueByIndex iniRows count))
		    (set! row ( MSK-exceptINIComments row))
		    (set! bigSect ( MSK-parseBigSect row) )
		    (set! result (MSK-push result bigSect))
		    (set! count (+ count 1))
		)
		result
    )
)
;--------------------------------------------------文字コード　Scheme　Gimp

(define ( MSK-getBigSectHash bigSect) 
	(let* (
			(fileName ( MSK-getINIFileName) )
		)
		( MSK-getBigSectHashFromFile bigSect fileName)
    )
)
;--------------------------------------------------文字コード　Scheme　Gimp

(define ( MSK-getBigSectHashFromFile bigSect fileName) 
	(let* (
			(iniRows (MSK-ReadIn fileName ))
			(iniRowsCount (MSK-count iniRows))
			(count 0)
			(tempSect "")
			(nowSect "")
			(row "")
			(result (list ))
			(keyAndValue (list "" ""))
		)
		(while (> iniRowsCount count)
		    (set! row (MSK-getValueByIndex iniRows count))
		    (set! row ( MSK-exceptINIComments row))
		    (set! tempSect ( MSK-parseBigSect row) )
		    (if (and (equal? tempSect bigSect)(not (equal? tempSect nowSect)))
		        (set! nowSect tempSect)
		        (begin
		            (if (and (equal? bigSect nowSect) (not (equal? row "")) (equal? tempSect ""))
		                (begin
	                        (set! keyAndValue (MSK-getKeyAndValue row))
	                        (set! result ( MSK-addElement2Hash result (MSK-getValueByIndex keyAndValue 0) (MSK-getValueByIndex keyAndValue 1)))
		                )
		            )
		        )
		    )
		    (if (and (not (equal? tempSect nowSect))(not (equal? tempSect "")))
                (set! nowSect tempSect)
            )
		    (set! count (+ count 1))
		)
		result
    )
)
;--------------------------------------------------文字コード　Scheme　Gimp

(define ( MSK-setBigSectHashToIni bigSect hash) 
	(let* (
			(fileName ( MSK-getINIFileName) )
		)
		( MSK-setBigSectHashToFile bigSect hash fileName)
    )
)
;--------------------------------------------------文字コード　Scheme　Gimp

(define ( MSK-setBigSectHashToFile bigSect hash fileName) 
	(let* (
			(iniRows (MSK-ReadIn fileName ))
			(iniRowsCount (MSK-count iniRows))
			(count 0)
			(tempSect "")
			(nowSect "")
			(row "")
			(result (list ))
			(keyAndValue (list "" ""))
			(writeList (list ""))
			(hashCount 0)
			(hashKeyList (list ""))
			(hashValueList (list ""))
			(overWriteFlag 0)
			(hashLength 0)
		)
		(while (> iniRowsCount count)
		    (set! row (MSK-getValueByIndex iniRows count))
		    (set! tempSect ( MSK-parseBigSect row) )
		    (if (and (equal? tempSect bigSect)(not (equal? tempSect nowSect)))
		        (begin 
		            (set! nowSect tempSect)
		            (set! writeList (MSK-push writeList row))
		        )
		        (begin
		            (if (and (equal? bigSect nowSect) (not (equal? row "")) (equal? tempSect "")(eqv? overWriteFlag 0))
		                (begin
		                    (set! overWriteFlag 1)
		                    (set! hashKeyList (MSK-getKeyListFromHash hash))
		                    (set! hashValueList (MSK-getValueListFromHash hash))
		                    (set! hashLength (MSK-count hashKeyList))
		                    (while (> hashLength hashCount )
		                    (if(not (equal? (MSK-getValueByIndex hashKeyList hashCount) ""))
	                            (set! result (string-append 
	                                (MSK-getValueByIndex hashKeyList hashCount) 
	                                "='"
	                                (MSK-getValueByIndex hashValueList hashCount) 
	                                "'")
	                            )
	                            (set! result "")
	                        )
		                    (set! writeList (MSK-push writeList result))
		                    (set! hashCount(+ hashCount 1))
		                    )
		                )
		            )
		        )
		    )
		    (if (and (not (equal? tempSect nowSect))(not (equal? tempSect "")))
		        (begin
                    (set! nowSect tempSect)
                    (set! writeList (MSK-push writeList row))
                )
                (begin
                    (if (and (or (equal? tempSect "") (not (equal? bigSect nowSect)))
                            (not (and (eqv? overWriteFlag 1)(equal? bigSect nowSect)))
                        )
                        (begin 
                            (set! writeList (MSK-push writeList row))
                        )
                    )
                )
            )
		    (set! count (+ count 1))
		)
		( MSK-WriteOut fileName (MSK-shift writeList)) 
    )
)

;--------------------------------------------------


(define ( MSK-getKeyAndValue row) 
	(let* (
	        (splited (MSK-split row "="))
	        (key "")
	        (value "")
	    )
	    (if (> (MSK-count splited) 1)
	        (begin
	            (set! key (MSK-getValueByIndex splited 0))
	            (set! value (MSK-getValueByIndex splited 1))
	        )
	    )
	    (set! key( MSK-replace key " " ""))
	    (set! key( MSK-replace key "\t" ""))
	    (set! value( MSK-replace value " " ""))
	    (set! value( MSK-replace value "\t" ""))
	    (set! value( MSK-replace value "'" ""))
	    (set! value( MSK-replace value "\"" ""))
	    (list key value)
	)
)

;--------------------------------------------------
(script-fu-register "Mansiki-ini"
		    "Mansiki-ini(Lib)"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2007/05/27"
		    "GPL"
	)

(script-fu-menu-register "Mansiki-ini"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
