; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-Logger ) 
	(gimp-message  "Logger")
	
)
;--------------------------------------------------Loggerの初期化：Gimpの一時ファイルにキーを埋め込む
(define ( MSK-LoggerInit fileName Context) 
	(let* (
			(preFix "MSK-Logger")
		)
	    (if (or (null? fileName) (null? Context) (equal? fileName "") (equal? Context ""))
	        (gimp-message  (string-append "fileName:" fileName  "/Context:" Context))
            (begin 
            	(MSK-RCBufferSet (string-append preFix ":fileName") fileName)
            	(MSK-RCBufferSet (string-append preFix ":Context") Context)
        	)
        )
	)
)
;--------------------------------------------------Loggerの初期化：Gimpの一時ファイルにキーを埋め込む
(define ( MSK-LoadLoggerSetting ) 
	(list 
	    (MSK-RCBufferQuery "MSK-Logger:fileName")
	    (MSK-RCBufferQuery "MSK-Logger:Context")
	)
)
;--------------------------------------------------Loggerの初期化：Gimpの一時ファイルにキーを埋め込む
(define ( MSK-Logger type massage) 
	(let* (
			(count 0)
		)	
		(cond 
		    ((equal? type "info") (MSK-Info massage))
		    ((equal? type "war") (MSK-Warn massage))
		    ((equal? type "err") (MSK-Error massage))
		    ((equal? type "dbg") (MSK-Debug massage))
		)
	)
)
;--------------------------------------------------指定ファイルにリストのデータを\n区切りで書き込み(追記)
(define ( MSK-LogWrite Level massage) 
	(let* (
			(settingList (MSK-LoadLoggerSetting))
			(fileName (MSK-getValueByIndex settingList 0))
			(Context (MSK-getValueByIndex settingList 1))
			(nowTime (MSK-getNowDateTime))
		)	
		 ;(gimp-message  (string-append fileName nowTime "[" Context "] " Level ":" massage))
		(MSK-WriteAdd fileName (list (string-append nowTime "[" Context "] " Level ":" massage)))
	)
)
;--------------------------------------------------指定ファイルにリストのデータを\n区切りで書き込み(追記)
(define ( MSK-Info massage) 
    (MSK-LogWrite "INFO" massage) 
)
;--------------------------------------------------指定ファイルにリストのデータを\n区切りで書き込み(追記)
(define ( MSK-Warn  massage) 
    (MSK-LogWrite "WAR" massage) 
)
;--------------------------------------------------指定ファイルにリストのデータを\n区切りで書き込み(追記)
(define ( MSK-Error massage) 
    (MSK-LogWrite "ERR" massage) 
)
;--------------------------------------------------指定ファイルにリストのデータを\n区切りで書き込み(追記)
(define ( MSK-Debug massage) 
    (MSK-LogWrite "DBG" massage) 
)
;--------------------------------------------------指定ファイルにリストのデータを\n区切りで書き込み(追記)
(define ( MSK-ShowLog maxRowNum) 
	(let* (
			(settingList (MSK-LoadLoggerSetting))
			(fileName (MSK-getValueByIndex settingList 0))
			(dataList  ( MSK-ReadIn fileName))
			(len (length dataList))
			(defaultRowNum 20)
			(count 0)
			(tempList (list ""))
		)	
		(if (and (not(null? maxRowNum)) (not (string? maxRowNum )) (> maxRowNum 0))
		    (set! defaultRowNum maxRowNum)
		)
		(set! tempList (list (string-append "--" (number->string defaultRowNum) "------------------------------------------------------" )))
		(if (<= defaultRowNum len)
		    (set! count (- len defaultRowNum))
		)
		(while (< count len)
		    (set! tempList (MSK-push tempList (MSK-getValueByIndex dataList count)))
		    (set! count (+ count 1))
		)
		(set! tempList (MSK-push tempList (string-append "--" (number->string defaultRowNum) "------------------------------------------------------" )))
	    (gimp-message  (MSK-join tempList "\n"))
	)
)
;--------------------------------------------------
(script-fu-register "Mansiki-Logger"
		    "Mansiki-Logger"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2007/05/27"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-Logger"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
