; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-TextLayer ) 
	(gimp-message  "TextLayer")
	
)
(define ( Mansiki-TextLayer ) 
	(gimp-message  "TextLayer")
	
)
;--------------------------------------------------レイヤー?
(define ( MSK-isTextLayer layerID ) 
	(gimp-drawable-is-layer layerID)
)
;--------------------------------------------------テキストレイヤー作成
(define ( MSK-makeTextLayerAntiAlias imageID newText Size fontName) 
	(let* (
			(offsetX 0)
			(offsetY 0)
			(offsetZ -1)
			(borderSize 0)
			(isAntiAlias TRUE)
			(sizearray (MSK-sizeSplit Size))
			(size (MSK-getValueByIndex sizearray 0))
			(unit (MSK-getValueByIndex sizearray 1))
			(fontName2Set fontName)
			(newLayerID -1)
		)
		(if (equal? fontName "") (set! fontName2Set "Sans" ))
		(set! newLayerID 
			(MSK-first 
				(gimp-text-fontname imageID offsetZ offsetX offsetY 
					newText 
					borderSize 
					isAntiAlias 
					size
					unit
					fontName2Set
				)
			)
		)
		( MSK-setParasite2TextLayer newLayerID newText isAntiAlias size unit fontName2Set)
		newLayerID
	)
)
;--------------------------------------------------テキストレイヤー作成
(define ( MSK-makeTextLayer imageID newText ) 
	(MSK-first (gimp-text-fontname imageID -1 0 0 newText 0 TRUE 10 PIXELS "Sans"))
)
;--------------------------------------------------テキストレイヤー情報パラサイト作成
(define ( MSK-setParasite2TextLayer newLayerID newText isAntiAlias size unit fontName2Set) 
	( MSK-setParasiteToDrowable newLayerID "MSK-TEXTLAYER_Text" newText)
	( MSK-setParasiteToDrowable newLayerID "MSK-TEXTLAYER_isAntiAlias" (number->string  isAntiAlias))
	( MSK-setParasiteToDrowable newLayerID "MSK-TEXTLAYER_size" (number->string size))
	( MSK-setParasiteToDrowable newLayerID "MSK-TEXTLAYER_unit" (number->string unit))
	( MSK-setParasiteToDrowable newLayerID "MSK-TEXTLAYER_fontName2Set" fontName2Set)
	;( MSK-setParasiteToDrowable newLayerID "MSK-TEXTLAYER_contextColor" (""))
	( MSK-setParasiteToDrowable newLayerID "MSK-TEXTLAYER_ID" (string-append "ID_"(number->string newLayerID)( MSK-getNowDateTime )))
)
;--------------------------------------------------テキストレイヤー情報パラサイト値取得
(define ( MSK-getParasiteTextOnTextLayer newLayerID )
	( MSK-getParasiteStringFromDrowable newLayerID "MSK-TEXTLAYER_Text")  
)
;--------------------------------------------------テキストレイヤー情報パラサイト値取得
(define ( MSK-getParasiteIsAntiAliasOnTextLayer newLayerID )
	(MSK-string2number ( MSK-getParasiteStringFromDrowable newLayerID "MSK-TEXTLAYER_isAntiAlias"))  
)

;--------------------------------------------------テキストレイヤー情報パラサイト値取得
(define ( MSK-getParasiteSizeOnTextLayer newLayerID )
	(MSK-string2number ( MSK-getParasiteStringFromDrowable newLayerID "MSK-TEXTLAYER_size"))
)

;--------------------------------------------------テキストレイヤー情報パラサイト値取得
(define ( MSK-getParasiteUnitOnTextLayer newLayerID )
	(MSK-string2number ( MSK-getParasiteStringFromDrowable newLayerID "MSK-TEXTLAYER_unit"))
)

;--------------------------------------------------テキストレイヤー情報パラサイト値取得
(define ( MSK-getParasiteFontNameOnTextLayer newLayerID )
	( MSK-getParasiteStringFromDrowable newLayerID "MSK-TEXTLAYER_fontName2Set" )
)

;--------------------------------------------------テキストレイヤー情報パラサイト値取得
(define ( MSK-getParasiteIDOnTextLayer newLayerID )
	( MSK-getParasiteStringFromDrowable newLayerID "MSK-TEXTLAYER_ID")  
)

;--------------------------------------------------特定テキストレイヤー情報値変更
(define ( MSK-modifyTextOnTextLayer newLayerID newText)
	(let* (
			(offsetX ( MSK-getOffsetX  newLayerID))
			(offsetY ( MSK-getOffsetY  newLayerID))
			(offsetZ ( MSK-getZindexLayer  newLayerID ) )
			(borderSize 0)
			(isAntiAlias ( MSK-getParasiteIsAntiAliasOnTextLayer newLayerID ))
			(size ( MSK-getParasiteSizeOnTextLayer newLayerID ))
			(unit ( MSK-getParasiteUnitOnTextLayer newLayerID ))
			(fontName2Set ( MSK-getParasiteFontNameOnTextLayer newLayerID ))
			(neoLayerID -1)
			(imageID ( MSK-getImageIDByLayerID newLayerID))
		)
		(if (equal? fontName2Set "") (set! fontName2Set "Sans" ))
		(set! neoLayerID 
			(MSK-first 
				(gimp-text-fontname imageID offsetZ offsetX offsetY 
					newText 
					borderSize 
					isAntiAlias 
					size
					unit
					fontName2Set
				)
			)
		)
		( MSK-setParasite2TextLayer neoLayerID newText isAntiAlias size unit fontName2Set)
		(MSK-deleteLayer newLayerID)
		neoLayerID
	)  
)
;--------------------------------------------------特定テキストレイヤー情報値変更
(define ( MSK-modifyAntiAliasFlagOnTextLayer newLayerID isAntiAlias)
	(let* (
			(offsetX ( MSK-getOffsetX  newLayerID))
			(offsetY ( MSK-getOffsetY  newLayerID))
			(offsetZ ( MSK-getZindexLayer  newLayerID ) )
			(borderSize 0)
			(newText ( MSK-getParasiteTextOnTextLayer newLayerID ))
			(size ( MSK-getParasiteSizeOnTextLayer newLayerID ))
			(unit ( MSK-getParasiteUnitOnTextLayer newLayerID ))
			(fontName2Set ( MSK-getParasiteFontNameOnTextLayer newLayerID ))
			(neoLayerID -1)
			(imageID ( MSK-getImageIDByLayerID newLayerID))
		)
		(if (equal? fontName2Set "") (set! fontName2Set "Sans" ))
		(set! neoLayerID 
			(MSK-first 
				(gimp-text-fontname imageID offsetZ offsetX offsetY 
					newText 
					borderSize 
					isAntiAlias 
					size
					unit
					fontName2Set
				)
			)
		)
		( MSK-setParasite2TextLayer neoLayerID newText isAntiAlias size unit fontName2Set)
		(MSK-deleteLayer newLayerID)
		neoLayerID
	)  
)
;--------------------------------------------------特定テキストレイヤー情報値変更
(define ( MSK-modifySizeOnTextLayer newLayerID size)
	(let* (
			(offsetX ( MSK-getOffsetX  newLayerID))
			(offsetY ( MSK-getOffsetY  newLayerID))
			(offsetZ ( MSK-getZindexLayer  newLayerID ) )
			(borderSize 0)
			(newText ( MSK-getParasiteTextOnTextLayer newLayerID ))
			(isAntiAlias ( MSK-getParasiteIsAntiAliasOnTextLayer newLayerID ))
			(unit ( MSK-getParasiteUnitOnTextLayer newLayerID ))
			(fontName2Set ( MSK-getParasiteFontNameOnTextLayer newLayerID ))
			(neoLayerID -1)
			(imageID ( MSK-getImageIDByLayerID newLayerID))
		)
		(if (equal? fontName2Set "") (set! fontName2Set "Sans" ))
		(set! neoLayerID 
			(MSK-first 
				(gimp-text-fontname imageID offsetZ offsetX offsetY 
					newText 
					borderSize 
					isAntiAlias 
					size
					unit
					fontName2Set
				)
			)
		)
		( MSK-setParasite2TextLayer neoLayerID newText isAntiAlias size unit fontName2Set)
		(MSK-deleteLayer newLayerID)
		neoLayerID
	)  
)
;--------------------------------------------------特定テキストレイヤー情報値変更
(define ( MSK-modifyUnitOnTextLayer newLayerID unit)
	(let* (
			(offsetX ( MSK-getOffsetX  newLayerID))
			(offsetY ( MSK-getOffsetY  newLayerID))
			(offsetZ ( MSK-getZindexLayer  newLayerID ) )
			(borderSize 0)
			(newText ( MSK-getParasiteTextOnTextLayer newLayerID ))
			(isAntiAlias ( MSK-getParasiteIsAntiAliasOnTextLayer newLayerID ))
			(size ( MSK-getParasiteSizeOnTextLayer newLayerID ))
			(fontName2Set ( MSK-getParasiteFontNameOnTextLayer newLayerID ))
			(neoLayerID -1)
			(imageID ( MSK-getImageIDByLayerID newLayerID))
		)
		(if (equal? fontName2Set "") (set! fontName2Set "Sans" ))
		(set! neoLayerID 
			(MSK-first 
				(gimp-text-fontname imageID offsetZ offsetX offsetY 
					newText 
					borderSize 
					isAntiAlias 
					size
					unit
					fontName2Set
				)
			)
		)
		( MSK-setParasite2TextLayer neoLayerID newText isAntiAlias size unit fontName2Set)
		(MSK-deleteLayer newLayerID)
		neoLayerID
	)  
)
;--------------------------------------------------特定テキストレイヤー情報値変更
(define ( MSK-modifyFontNameOnTextLayer newLayerID fontName2Set)
	(let* (
			(offsetX ( MSK-getOffsetX  newLayerID))
			(offsetY ( MSK-getOffsetY  newLayerID))
			(offsetZ ( MSK-getZindexLayer  newLayerID ) )
			(borderSize 0)
			(newText ( MSK-getParasiteTextOnTextLayer newLayerID ))
			(isAntiAlias ( MSK-getParasiteIsAntiAliasOnTextLayer newLayerID ))
			(size ( MSK-getParasiteSizeOnTextLayer newLayerID ))
			(unit ( MSK-getParasiteUnitOnTextLayer newLayerID ))
			(neoLayerID -1)
			(imageID ( MSK-getImageIDByLayerID newLayerID))
		)
		(if (equal? fontName2Set "") (set! fontName2Set "Sans" ))
		(set! neoLayerID 
			(MSK-first 
				(gimp-text-fontname imageID offsetZ offsetX offsetY 
					newText 
					borderSize 
					isAntiAlias 
					size
					unit
					fontName2Set
				)
			)
		)
		( MSK-setParasite2TextLayer neoLayerID newText isAntiAlias size unit fontName2Set)
		(MSK-deleteLayer newLayerID)
		neoLayerID
	)  
)

;--------------------------------------------------サイズしてい分解
(define ( MSK-sizeSplit Size  ) 
	(let* (
			(sizelength (MSK-length Size))
			(count 0)
			(array (MSK-split Size ""))
			(resultNum 0)
			(resultNumString "0")
			(resultUnit "")
			(unitFlag  0)
		)
		(while (> sizelength count )
			(if(and 
					(MSK-isNumber (MSK-getValueByIndex array count))
				　　 (eqv? unitFlag 0))
				(set! resultNumString (string-append resultNumString (MSK-getValueByIndex array count)))
				(begin 
					(set! resultUnit (string-append resultUnit (MSK-getValueByIndex array count)))
					(set! unitFlag 1)
				)
			)
			(set! count (+ count 1))
		)
		(if(equal? "POINTS" (MSK-upcase resultUnit ))
			(set! resultUnit 0)
			(set! resultUnit 1)
		)
		(list (string->number resultNumString) resultUnit)
	)
)
;--------------------------------------------------ラスター変換
(define ( MSK-comvertToRaster layerID ) 
	( MSK-comvertToRasterWithColorSetting layerID 
		(MSK-first (gimp-context-get-foreground )) 
		(MSK-first (gimp-context-get-background ))
	) 
)
;--------------------------------------------------ラスター変換
(define ( MSK-comvertToRasterWithColorSetting layerID textColor bgColor ) 
	(let* (
			(rasterLayer ( MSK-newLayer ( MSK-getImageIDByLayerID layerID ) ))
		)
    	(gimp-context-push)
		(gimp-selection-none ( MSK-getImageIDByLayerID layerID ))
		( MSK-setLayerWidth rasterLayer ( MSK-getLayerWidth  layerID))
		( MSK-setLayerHeight rasterLayer ( MSK-getLayerHeight  layerID)) 
		( MSK-setOffsetX rasterLayer ( MSK-getOffsetX  layerID))
		( MSK-setOffsetY rasterLayer ( MSK-getOffsetY  layerID))
    	;(gimp-layer-set-lock-alpha layerID TRUE)
    	(gimp-context-set-foreground textColor)
    	(gimp-context-set-background bgColor)
    	(gimp-selection-layer-alpha layerID)
    	(gimp-edit-fill rasterLayer FOREGROUND-FILL)
		(gimp-selection-none ( MSK-getImageIDByLayerID layerID ))
    	(gimp-selection-layer-alpha layerID)
		(gimp-selection-invert ( MSK-getImageIDByLayerID layerID ))
    	(gimp-edit-fill rasterLayer BACKGROUND-FILL)
    	(gimp-edit-clear rasterLayer)
		(gimp-selection-none ( MSK-getImageIDByLayerID layerID ))
    	(MSK-deleteLayer layerID)
    	(gimp-context-pop)
    	rasterLayer
	)
)
;--------------------------------------------------
(script-fu-register "Mansiki-TextLayer"
		    "Mansiki-TextLayer(Lib)"
		    "Mansiki"
		    "name"
		    "Rongfu"
		    "2008/06/19"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-TextLayer"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
