package com.marevol.utils.portlet.faces;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.faces.context.FacesContext;

public class PortletResourceBundleUtil
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(PortletResourceBundleUtil.class);

    public static ResourceBundle getBundle(Locale locale)
    {
        return PortletConfigUtil.getResourceBundle(locale);
    }

    private static Locale getLocale()
    {
        try
        {
            return FacesContext.getCurrentInstance().getViewRoot().getLocale();
        }
        catch (RuntimeException e)
        {
            log.error("FacesContext.getCurrentInstance().getViewRoot().getLocale() is invalid state.");
            return Locale.ENGLISH;
        }
    }

    public static Enumeration getKeys()
    {
        ResourceBundle bundle = getBundle(getLocale());
        if (bundle != null)
        {
            return bundle.getKeys();
        }
        return null;
    }

    public static Object getObject(String key)
    {
        ResourceBundle bundle = getBundle(getLocale());
        if (bundle != null)
        {
            return bundle.getObject(key);
        }
        return null;
    }

    public static String getString(String key)
    {
        return (String) getObject(key);
    }

    public static String[] getStringArray(String key)
    {
        return (String[]) getObject(key);
    }

    public static String getString(String key, Object[] params)
    {
        MessageFormat format = new MessageFormat(getString(key), getLocale());
        return format.format(params);
    }
}
