package com.marevol.utils.logparser;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Unit test for simple App.
 *
 * @author <a href="mailto:jason@zenplex.com">Jason van Zyl</a>
 */
public class LogParserTest extends AbstractTestCase
{
    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public LogParserTest(String testName)
    {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        TestSuite suite = new TestSuite();
        suite.addTest(new LogParserTest("testCase1"));
        suite.addTest(new LogParserTest("testCase2"));
        return suite;
    }

    /**
     * %S host (the client hostname, or address of the computer making the request) 
     * %s numerical IP address of client (if recorded in a separate field; used when %S is empty) 
     * %r file requested 
     * %q query string (part of filename after ?, if recorded in a separate field) 
     * %B browser 
     * %A browser with +'s instead of spaces 
     * %f referrer 
     * %u user (tip: a cookie or session id can usefully be defined as %u too) 
     * %v virtual host (the server hostname, also called the virtual domain) 
     * %d day of the month 
     * %m month in digits 
     * %M month, three letter English abbreviation 
     * %y year, last two digits 
     * %Y year, four digits 
     * %Z year, two or four digits (less efficient) 
     * %h hour of the day 
     * %n minute of the hour 
     * %a a or A for am, or p or P for pm, if %h is in the 12-hour clock. (So to match "am" you need %am and to match "AM" you need %aM) 
     * %U "Unix time" (seconds since beginning of 1970, GMT). If it includes decimals, use %U.%j 
     * %b number of bytes transferred 
     * %t processing time in seconds 
     * %T processing time in milliseconds 
     * %D processing time in microseconds 
     * %c HTTP status code 
     * %C code words used instead of HTTP status code in some servers -- only used internally 
     * %j junk: ignore this field (field can be empty too) 
     * %w white space: spaces or tabs 
     * %W optional white space 
     * %% % sign 
     * \n new line 
     * \t tab stop 
     * \\ single backslash
     */
    public void testCase1()
    {
        /*
         * %h  Remote host name
         * %l  Remote user name by ident
         * %u  Remote user name by user authentication
         * %t  Access timestamp
         * %r  Http request header
         * %s  Status code
         * %b  Transferred bytes
         * %U  Requested URL
         * %v  Server name
         * %{STRING}i  Content for STRING in Request
         * %{STRING}o  Content for STRING in Response
         * %f  Access file name
         */

        LogParser parser = LogParserFactory.getInstance("com.marevol.utils.logparser.DefaultLogParser");
        parser.setFormat("%t %h %l %v %p %r %f %s %q %B");
        LogEntry entry = parser.parse("A B C D E F G H I J");

        assertEquals("A", entry.get("%t"));
        assertEquals("B", entry.get("%h"));
        assertEquals("C", entry.get("%l"));
        assertEquals("D", entry.get("%v"));
        assertEquals("E", entry.get("%p"));
        assertEquals("F", entry.get("%r"));
        assertEquals("G", entry.get("%f"));
        assertEquals("H", entry.get("%s"));
        assertEquals("I", entry.get("%q"));
        assertEquals("J", entry.get("%B"));
    }

    public void testCase2()
    {
        LogParser parser = LogParserFactory.getInstance("com.marevol.utils.logparser.DefaultLogParser");
        parser.setFormat("%Y-%m-%d %h:%n:%t %s %u %v %p %j %r %q %c %B");
        LogEntry entry = parser
                .parse("2005-09-01 00:01:42 172.29.3.54 - 10.11.43.11 80 GET /anzen/frame4.html - 200 Mozilla/4.0+(compatible;+MSIE+5.5;+Windows+NT+5.0;+istb+702;+.NET+CLR+1.0.3705;+.NET+CLR+1.1.4322)");

        assertEquals("2005", entry.get("%Y"));
        assertEquals("09", entry.get("%m"));
        assertEquals("01", entry.get("%d"));
        assertEquals("00", entry.get("%h"));
        assertEquals("01", entry.get("%n"));
        assertEquals("42", entry.get("%t"));
        assertEquals("172.29.3.54", entry.get("%s"));
        assertEquals("-", entry.get("%u"));
        assertEquals("10.11.43.11", entry.get("%v"));
        assertEquals("80", entry.get("%p"));
        assertEquals("GET", entry.get("%j"));
        assertEquals("/anzen/frame4.html", entry.get("%r"));
        assertEquals("-", entry.get("%q"));
        assertEquals("200", entry.get("%c"));
        assertEquals(
                "Mozilla/4.0+(compatible;+MSIE+5.5;+Windows+NT+5.0;+istb+702;+.NET+CLR+1.0.3705;+.NET+CLR+1.1.4322)",
                entry.get("%B"));
    }
}
